/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Cookie;
import zio.http.Flash;
import zio.http.Flash$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Header$Cookie$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.MediaType;
import zio.http.Method;
import zio.http.Path;
import zio.http.QueryParams;
import zio.http.Request$;
import zio.http.Request$Patch$;
import zio.http.URL;
import zio.http.Version;
import zio.http.internal.HeaderOps;
import zio.http.internal.QueryOps;

public final class Request
implements HeaderOps<Request>,
QueryOps<Request>,
Product,
Serializable {
    private final Version version;
    private final Method method;
    private final URL url;
    private final Headers headers;
    private final Body body;
    private final Option remoteAddress;
    private Headers allHeaders$lzy1;
    private boolean allHeadersbitmap$1;

    public static Request apply(Version version, Method method, URL uRL, Headers headers, Body body, Option<InetAddress> option) {
        return Request$.MODULE$.apply(version, method, uRL, headers, body, option);
    }

    public static Request delete(String string) {
        return Request$.MODULE$.delete(string);
    }

    public static Request delete(URL uRL) {
        return Request$.MODULE$.delete(uRL);
    }

    public static Request fromProduct(Product product) {
        return Request$.MODULE$.fromProduct(product);
    }

    public static Request get(String string) {
        return Request$.MODULE$.get(string);
    }

    public static Request get(URL uRL) {
        return Request$.MODULE$.get(uRL);
    }

    public static Request head(String string) {
        return Request$.MODULE$.head(string);
    }

    public static Request head(URL uRL) {
        return Request$.MODULE$.head(uRL);
    }

    public static Request options(String string) {
        return Request$.MODULE$.options(string);
    }

    public static Request options(URL uRL) {
        return Request$.MODULE$.options(uRL);
    }

    public static Request post(String string, Body body) {
        return Request$.MODULE$.post(string, body);
    }

    public static Request post(URL uRL, Body body) {
        return Request$.MODULE$.post(uRL, body);
    }

    public static Request put(String string, Body body) {
        return Request$.MODULE$.put(string, body);
    }

    public static Request put(URL uRL, Body body) {
        return Request$.MODULE$.put(uRL, body);
    }

    public static Request unapply(Request request) {
        return Request$.MODULE$.unapply(request);
    }

    public static Version $lessinit$greater$default$1() {
        return Request$.MODULE$.$lessinit$greater$default$1();
    }

    public static Method $lessinit$greater$default$2() {
        return Request$.MODULE$.$lessinit$greater$default$2();
    }

    public static URL $lessinit$greater$default$3() {
        return Request$.MODULE$.$lessinit$greater$default$3();
    }

    public static Headers $lessinit$greater$default$4() {
        return Request$.MODULE$.$lessinit$greater$default$4();
    }

    public static Body $lessinit$greater$default$5() {
        return Request$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<InetAddress> $lessinit$greater$default$6() {
        return Request$.MODULE$.$lessinit$greater$default$6();
    }

    public Request(Version version, Method method, URL url, Headers headers, Body body, Option<InetAddress> remoteAddress) {
        this.version = version;
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.remoteAddress = remoteAddress;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Request)) return false;
        Request request = (Request)object;
        Version version = this.version();
        Version version2 = request.version();
        if (version == null) {
            if (version2 != null) {
                return false;
            }
        } else if (!version.equals(version2)) return false;
        Method method = this.method();
        Method method2 = request.method();
        if (method == null) {
            if (method2 != null) {
                return false;
            }
        } else if (!method.equals(method2)) return false;
        URL uRL = this.url();
        URL uRL2 = request.url();
        if (uRL == null) {
            if (uRL2 != null) {
                return false;
            }
        } else if (!((Object)uRL).equals(uRL2)) return false;
        Headers headers = this.headers();
        Headers headers2 = request.headers();
        if (headers == null) {
            if (headers2 != null) {
                return false;
            }
        } else if (!headers.equals(headers2)) return false;
        Body body = this.body();
        Body body2 = request.body();
        if (body == null) {
            if (body2 != null) {
                return false;
            }
        } else if (!body.equals(body2)) return false;
        Option<InetAddress> option = this.remoteAddress();
        Option<InetAddress> option2 = request.remoteAddress();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Request;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "Request";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "version";
            }
            case 1: {
                return "method";
            }
            case 2: {
                return "url";
            }
            case 3: {
                return "headers";
            }
            case 4: {
                return "body";
            }
            case 5: {
                return "remoteAddress";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Version version() {
        return this.version;
    }

    public Method method() {
        return this.method;
    }

    public URL url() {
        return this.url;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    public Body body() {
        return this.body;
    }

    public Option<InetAddress> remoteAddress() {
        return this.remoteAddress;
    }

    public Request $plus$plus(Request that) {
        return Request$.MODULE$.apply(this.version().$plus$plus(that.version()), this.method().$plus$plus(that.method()), this.url().$plus$plus(that.url()), this.headers().$plus$plus(that.headers()), this.body().$plus$plus(that.body()), (Option<InetAddress>)that.remoteAddress().orElse(this::$plus$plus$$anonfun$1));
    }

    public Headers allHeaders() {
        if (!this.allHeadersbitmap$1) {
            Headers headers;
            Option<MediaType> option = this.body().mediaType();
            if (option instanceof Some) {
                MediaType mediaType = (MediaType)((Some)option).value();
                headers = this.headers().$plus$plus(Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(mediaType, this.body().boundary(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())})));
            } else if (None$.MODULE$.equals(option)) {
                headers = this.headers();
            } else {
                throw new MatchError(option);
            }
            this.allHeaders$lzy1 = headers;
            this.allHeadersbitmap$1 = true;
        }
        return this.allHeaders$lzy1;
    }

    public Request addLeadingSlash() {
        URL uRL = this.url().addLeadingSlash();
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        Headers headers = this.copy$default$4();
        Body body = this.copy$default$5();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, uRL, headers, body, option);
    }

    public Request addTrailingSlash() {
        URL uRL = this.url().addTrailingSlash();
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        Headers headers = this.copy$default$4();
        Body body = this.copy$default$5();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, uRL, headers, body, option);
    }

    public ZIO<Object, Throwable, Request> collect(Object trace) {
        if (this.body().isComplete()) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this, trace);
        }
        return this.body().asChunk(trace).map((Function1 & Serializable)bytes -> {
            Body body = Body$.MODULE$.fromChunk((Chunk<Object>)bytes);
            Version version = this.copy$default$1();
            Method method = this.copy$default$2();
            URL uRL = this.copy$default$3();
            Headers headers = this.copy$default$4();
            Option<InetAddress> option = this.copy$default$6();
            return this.copy(version, method, uRL, headers, body, option);
        }, trace);
    }

    public Request dropLeadingSlash() {
        return this.updateURL((Function1<URL, URL>)(Function1 & Serializable)_$1 -> _$1.dropLeadingSlash());
    }

    public Request dropTrailingSlash() {
        return this.updateURL((Function1<URL, URL>)(Function1 & Serializable)_$2 -> _$2.dropTrailingSlash());
    }

    public ZIO<Object, Throwable, Request> ignoreBody(Object trace) {
        return this.collect(trace).map((Function1 & Serializable)_$3 -> {
            Body body = Body$.MODULE$.empty();
            Version version = _$3.copy$default$1();
            Method method = _$3.copy$default$2();
            URL uRL = _$3.copy$default$3();
            Headers headers = _$3.copy$default$4();
            Option<InetAddress> option = _$3.copy$default$6();
            return _$3.copy(version, method, uRL, headers, body, option);
        }, trace);
    }

    public Request patch(Patch p) {
        Headers headers = this.headers().$plus$plus(p.addHeaders());
        URL uRL = this.url().addQueryParams(p.addQueryParams());
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        Body body = this.copy$default$5();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, uRL, headers, body, option);
    }

    public Path path() {
        return this.url().path();
    }

    public Request path(Path path) {
        return this.updateURL((Function1<URL, URL>)(Function1 & Serializable)_$4 -> _$4.path(path));
    }

    @Override
    public QueryParams queryParameters() {
        return this.url().queryParams();
    }

    @Override
    public Request updateHeaders(Function1<Headers, Headers> update, Object trace) {
        Headers headers = (Headers)update.apply((Object)this.headers());
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        URL uRL = this.copy$default$3();
        Body body = this.copy$default$5();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, uRL, headers, body, option);
    }

    @Override
    public Request updateQueryParams(Function1<QueryParams, QueryParams> f) {
        Object object = this.url().updateQueryParams((Function1)f);
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        Headers headers = this.copy$default$4();
        Body body = this.copy$default$5();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, (URL)object, headers, body, option);
    }

    public Request updateURL(Function1<URL, URL> f) {
        URL uRL = (URL)f.apply((Object)this.url());
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        Headers headers = this.copy$default$4();
        Body body = this.copy$default$5();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, uRL, headers, body, option);
    }

    public Request updatePath(Function1<Path, Path> f) {
        URL uRL = this.url().copy((Path)f.apply((Object)this.path()), this.url().copy$default$2(), this.url().copy$default$3(), this.url().copy$default$4());
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        Headers headers = this.copy$default$4();
        Body body = this.copy$default$5();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, uRL, headers, body, option);
    }

    public Request unnest(Path prefix) {
        URL uRL = this.url().copy(this.url().path().unnest(prefix), this.url().copy$default$2(), this.url().copy$default$3(), this.url().copy$default$4());
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        Headers headers = this.copy$default$4();
        Body body = this.copy$default$5();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, uRL, headers, body, option);
    }

    public Request updateBody(Function1<Body, Body> f) {
        Body body = (Body)f.apply((Object)this.body());
        Version version = this.copy$default$1();
        Method method = this.copy$default$2();
        URL uRL = this.copy$default$3();
        Headers headers = this.copy$default$4();
        Option<InetAddress> option = this.copy$default$6();
        return this.copy(version, method, uRL, headers, body, option);
    }

    public <R, E> ZIO<R, E, Request> updateBodyZIO(Function1<Body, ZIO<R, E, Body>> f) {
        return ((ZIO)f.apply((Object)this.body())).map((Function1 & Serializable)body -> this.withBody((Body)body), (Object)"zio.http.Request.updateBodyZIO(Request.scala:127)");
    }

    public Request withBody(Body body) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), body, this.copy$default$6());
    }

    public Option<Cookie> cookie(String name) {
        return this.cookies().find((Function1 & Serializable)_$5 -> {
            String string = _$5.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public <R, A> ZIO<R, Throwable, A> cookieWithZIO(String name, Function1<Cookie, ZIO<R, Throwable, A>> f, Object trace) {
        return this.cookieWithOrFailImpl(name, new NoSuchElementException(new StringBuilder(22).append("cookie doesn't exist: ").append(name).toString()), f, trace);
    }

    public <R, E, A> ZIO<R, E, A> cookieWithOrFail(String name, E missingCookieError, Function1<Cookie, ZIO<R, E, A>> f, Object trace) {
        return this.cookieWithOrFailImpl(name, missingCookieError, f, trace);
    }

    private <R, E, A> ZIO<R, E, A> cookieWithOrFailImpl(String name, E e, Function1<Cookie, ZIO<R, E, A>> f, Object trace) {
        Option<Cookie> option = this.cookie(name);
        if (option instanceof Some) {
            Cookie value = (Cookie)((Some)option).value();
            return (ZIO)f.apply((Object)value);
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(() -> Request.cookieWithOrFailImpl$$anonfun$1(e), trace);
        }
        throw new MatchError(option);
    }

    public Chunk<Cookie> cookies() {
        return (Chunk)this.header(Header$Cookie$.MODULE$).fold(Request::cookies$$anonfun$1, (Function1 & Serializable)_$6 -> _$6.value().toChunk());
    }

    public <A> Option<A> flash(Flash<A> flash) {
        return Flash$.MODULE$.run(flash, this).toOption();
    }

    public Request copy(Version version, Method method, URL url, Headers headers, Body body, Option<InetAddress> remoteAddress) {
        return new Request(version, method, url, headers, body, remoteAddress);
    }

    public Version copy$default$1() {
        return this.version();
    }

    public Method copy$default$2() {
        return this.method();
    }

    public URL copy$default$3() {
        return this.url();
    }

    public Headers copy$default$4() {
        return this.headers();
    }

    public Body copy$default$5() {
        return this.body();
    }

    public Option<InetAddress> copy$default$6() {
        return this.remoteAddress();
    }

    public Version _1() {
        return this.version();
    }

    public Method _2() {
        return this.method();
    }

    public URL _3() {
        return this.url();
    }

    public Headers _4() {
        return this.headers();
    }

    public Body _5() {
        return this.body();
    }

    public Option<InetAddress> _6() {
        return this.remoteAddress();
    }

    private final Option $plus$plus$$anonfun$1() {
        return this.remoteAddress();
    }

    private static final Object cookieWithOrFailImpl$$anonfun$1(Object e$1) {
        return e$1;
    }

    private static final Chunk cookies$$anonfun$1() {
        return Chunk$.MODULE$.empty();
    }

    public static final class Patch
    implements Product,
    Serializable {
        private final Headers addHeaders;
        private final QueryParams addQueryParams;

        public static Patch apply(Headers headers, QueryParams queryParams) {
            return Request$Patch$.MODULE$.apply(headers, queryParams);
        }

        public static Patch empty() {
            return Request$Patch$.MODULE$.empty();
        }

        public static Patch fromProduct(Product product) {
            return Request$Patch$.MODULE$.fromProduct(product);
        }

        public static Patch unapply(Patch patch) {
            return Request$Patch$.MODULE$.unapply(patch);
        }

        public Patch(Headers addHeaders, QueryParams addQueryParams) {
            this.addHeaders = addHeaders;
            this.addQueryParams = addQueryParams;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Patch)) return false;
            Patch patch = (Patch)object;
            Headers headers = this.addHeaders();
            Headers headers2 = patch.addHeaders();
            if (headers == null) {
                if (headers2 != null) {
                    return false;
                }
            } else if (!headers.equals(headers2)) return false;
            QueryParams queryParams = this.addQueryParams();
            QueryParams queryParams2 = patch.addQueryParams();
            if (queryParams == null) {
                if (queryParams2 == null) return true;
                return false;
            } else {
                if (!((Object)queryParams).equals(queryParams2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Patch;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Patch";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "addHeaders";
            }
            if (1 == n2) {
                return "addQueryParams";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Headers addHeaders() {
            return this.addHeaders;
        }

        public QueryParams addQueryParams() {
            return this.addQueryParams;
        }

        public Patch $plus$plus(Patch that) {
            return Request$Patch$.MODULE$.apply(this.addHeaders().$plus$plus(that.addHeaders()), (QueryParams)this.addQueryParams().$plus$plus(that.addQueryParams()));
        }

        public Patch copy(Headers addHeaders, QueryParams addQueryParams) {
            return new Patch(addHeaders, addQueryParams);
        }

        public Headers copy$default$1() {
            return this.addHeaders();
        }

        public QueryParams copy$default$2() {
            return this.addQueryParams();
        }

        public Headers _1() {
            return this.addHeaders();
        }

        public QueryParams _2() {
            return this.addQueryParams();
        }
    }
}

