/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.time.Duration;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Trace$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Handler;
import zio.http.Handler$;
import zio.http.Handler$FromFunctionHandler$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.HttpApp$;
import zio.http.HttpApp$Tree$;
import zio.http.Method;
import zio.http.Method$GET$;
import zio.http.Middleware;
import zio.http.Middleware$;
import zio.http.Path;
import zio.http.Path$;
import zio.http.Request;
import zio.http.Request$;
import zio.http.Response;
import zio.http.Route;
import zio.http.RoutePattern;
import zio.http.Routes;
import zio.http.Status;
import zio.http.Status$NotFound$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;

public final class HttpApp<Env>
implements PartialFunction<Request, ZIO<Env, Response, Response>>,
Product,
Serializable {
    private final Routes routes;
    private Tree<?> _tree;
    private final Handler toHandler;

    public static HttpApp<Object> empty() {
        return HttpApp$.MODULE$.empty();
    }

    public static HttpApp<?> fromProduct(Product product) {
        return HttpApp$.MODULE$.fromProduct(product);
    }

    public HttpApp(Routes<Env, Response> routes) {
        this.routes = routes;
        PartialFunction.$init$((PartialFunction)this);
        this._tree = null;
        Object trace = Trace$.MODULE$.empty();
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionHandler();
        this.toHandler = Handler$FromFunctionHandler$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)req -> {
            Chunk<Handler<Env, Response, Request, Response>> chunk = this.tree(trace).get(req.method(), req.path());
            if (chunk.length() == 0) {
                return Handler$.MODULE$.notFound();
            }
            if (chunk.length() == 1) {
                return (Handler)chunk.apply(0);
            }
            return (Handler)((Chunk)chunk.tail()).foldLeft(chunk.head(), (Function2 & Serializable)(acc, h) -> acc.catchAll((Function1 & Serializable)response -> {
                Status status = response.status();
                Status$NotFound$ status$NotFound$ = Status$NotFound$.MODULE$;
                if (!(status != null ? !status.equals(status$NotFound$) : status$NotFound$ != null)) {
                    return h;
                }
                return Handler$.MODULE$.fail(() -> HttpApp.$init$$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(response));
            }, trace));
        }).merge($less$colon$less$.MODULE$.refl(), trace);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HttpApp)) return false;
        HttpApp httpApp = (HttpApp)object;
        Routes<Env, Response> routes = this.routes();
        Routes<Env, Response> routes2 = httpApp.routes();
        if (routes != null) {
            if (!routes.equals(routes2)) return false;
            return true;
        }
        if (routes2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof HttpApp;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "HttpApp";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "routes";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Routes<Env, Response> routes() {
        return this.routes;
    }

    public <Env1 extends Env> HttpApp<Env1> $at$at(Middleware<Env1> aspect) {
        return this.copy(this.routes().$at$at(aspect));
    }

    public <Env1 extends Env> HttpApp<Env1> $plus$plus(HttpApp<Env1> that) {
        return this.copy(this.routes().$plus$plus(that.routes()));
    }

    public ZIO<Env, Response, Response> apply(Request request) {
        return this.runZIO(request);
    }

    public boolean isDefinedAt(Request request) {
        return this.tree(Trace$.MODULE$.empty()).get(request.method(), request.path()).nonEmpty();
    }

    public HttpApp<Object> provideEnvironment(ZEnvironment<Env> env) {
        return this.copy(this.routes().provideEnvironment(env));
    }

    public ZIO<Env, Nothing$, Response> run(Method method, Path path, Headers headers, Body body) {
        URL uRL = URL$.MODULE$.root().path(path);
        Version version = Request$.MODULE$.$lessinit$greater$default$1();
        Option<InetAddress> option = Request$.MODULE$.$lessinit$greater$default$6();
        return this.runZIO(Request$.MODULE$.apply(version, method, uRL, headers, body, option));
    }

    public Method run$default$1() {
        return Method$GET$.MODULE$;
    }

    public Path run$default$2() {
        return Path$.MODULE$.root();
    }

    public Headers run$default$3() {
        return Headers$.MODULE$.empty();
    }

    public Body run$default$4() {
        return Body$.MODULE$.empty();
    }

    public ZIO<Env, Nothing$, Response> runZIO(Request request) {
        return this.toHandler().apply(request);
    }

    public HttpApp<Env> timeout(Duration duration, Object trace) {
        return this.$at$at(Middleware$.MODULE$.timeout(duration, trace));
    }

    public Handler<Env, Nothing$, Request, Response> toHandler() {
        return this.toHandler;
    }

    public Tree<Env> tree(Object trace) {
        if (this._tree == null) {
            this._tree = HttpApp$Tree$.MODULE$.fromRoutes(this.routes(), trace);
        }
        return this._tree;
    }

    public <Env> HttpApp<Env> copy(Routes<Env, Response> routes) {
        return new HttpApp<Env>(routes);
    }

    public <Env> Routes<Env, Response> copy$default$1() {
        return this.routes();
    }

    public Routes<Env, Response> _1() {
        return this.routes();
    }

    private static final Response $init$$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Response response$1) {
        return response$1;
    }

    public static final class Tree<Env>
    implements Product,
    Serializable {
        private final RoutePattern.Tree tree;

        public static <Env> Tree<Env> apply(RoutePattern.Tree<Handler<Env, Response, Request, Response>> tree) {
            return HttpApp$Tree$.MODULE$.apply(tree);
        }

        public static Tree<Object> empty() {
            return HttpApp$Tree$.MODULE$.empty();
        }

        public static Tree<?> fromProduct(Product product) {
            return HttpApp$Tree$.MODULE$.fromProduct(product);
        }

        public static <Env> Tree<Env> fromRoutes(Routes<Env, Response> routes, Object object) {
            return HttpApp$Tree$.MODULE$.fromRoutes(routes, object);
        }

        public static <Env> Tree<Env> unapply(Tree<Env> tree) {
            return HttpApp$Tree$.MODULE$.unapply(tree);
        }

        public Tree(RoutePattern.Tree<Handler<Env, Response, Request, Response>> tree) {
            this.tree = tree;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Tree)) return false;
            Tree tree = (Tree)object;
            RoutePattern.Tree<Handler<Env, Response, Request, Response>> tree2 = this.tree();
            RoutePattern.Tree<Handler<Env, Response, Request, Response>> tree3 = tree.tree();
            if (tree2 != null) {
                if (!((Object)tree2).equals(tree3)) return false;
                return true;
            }
            if (tree3 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Tree;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Tree";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tree";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public RoutePattern.Tree<Handler<Env, Response, Request, Response>> tree() {
            return this.tree;
        }

        public final <Env1 extends Env> Tree<Env1> $plus$plus(Tree<Env1> that) {
            return HttpApp$Tree$.MODULE$.apply(this.tree().$plus$plus(that.tree()));
        }

        public final <Env1 extends Env> Tree<Env1> add(Route<Env1, Response> route, Object trace) {
            return HttpApp$Tree$.MODULE$.apply(this.tree().add(route.routePattern(), route.toHandler((.less.colon.less<Response, Response>)$less$colon$less$.MODULE$.refl(), trace)));
        }

        public final <Env1 extends Env> Tree<Env1> addAll(Iterable<Route<Env1, Response>> routes, Object trace) {
            return HttpApp$Tree$.MODULE$.apply(this.tree().addAll((Iterable)routes.map((Function1 & Serializable)r -> Tuple2$.MODULE$.apply(r.routePattern(), r.toHandler($less$colon$less$.MODULE$.refl(), trace)))));
        }

        public final Chunk<Handler<Env, Response, Request, Response>> get(Method method, Path path) {
            return this.tree().get(method, path);
        }

        public <Env> Tree<Env> copy(RoutePattern.Tree<Handler<Env, Response, Request, Response>> tree) {
            return new Tree<Env>(tree);
        }

        public <Env> RoutePattern.Tree<Handler<Env, Response, Request, Response>> copy$default$1() {
            return this.tree();
        }

        public RoutePattern.Tree<Handler<Env, Response, Request, Response>> _1() {
            return this.tree();
        }
    }
}

