/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Request;
import zio.http.Response;
import zio.http.codec.HttpContentCodec$;
import zio.http.internal.HeaderOps;
import zio.schema.Schema;
import zio.schema.codec.BinaryCodec;
import zio.schema.codec.Encoder;

public final class HttpContentCodec<A>
implements Product,
Serializable {
    private final ListMap choices;
    private final Schema schema;
    private Map<MediaType, Option<BinaryCodec<A>>> lookupCache;
    private final MediaType defaultMediaType;
    private final BinaryCodec defaultCodec;

    public static <A> HttpContentCodec<A> apply(ListMap<MediaType, BinaryCodec<A>> listMap, Schema<A> schema) {
        return HttpContentCodec$.MODULE$.apply(listMap, schema);
    }

    public static HttpContentCodec<Chunk<Object>> byteChunkCodec() {
        return HttpContentCodec$.MODULE$.byteChunkCodec();
    }

    public static HttpContentCodec<Object> byteCodec() {
        return HttpContentCodec$.MODULE$.byteCodec();
    }

    public static HttpContentCodec<?> fromProduct(Product product) {
        return HttpContentCodec$.MODULE$.fromProduct(product);
    }

    public static <A> HttpContentCodec<A> fromSchema(Schema<A> schema) {
        return HttpContentCodec$.MODULE$.fromSchema(schema);
    }

    public static <A> HttpContentCodec<A> unapply(HttpContentCodec<A> httpContentCodec) {
        return HttpContentCodec$.MODULE$.unapply(httpContentCodec);
    }

    public HttpContentCodec(ListMap<MediaType, BinaryCodec<A>> choices, Schema<A> schema) {
        this.choices = choices;
        this.schema = schema;
        this.lookupCache = Predef$.MODULE$.Map().empty();
        this.defaultMediaType = (MediaType)choices.headOption().map((Function1 & Serializable)_$1 -> (MediaType)_$1._1()).getOrElse(HttpContentCodec::$init$$$anonfun$2);
        this.defaultCodec = (BinaryCodec)choices.headOption().map((Function1 & Serializable)_$2 -> (BinaryCodec)_$2._2()).getOrElse(HttpContentCodec::$init$$$anonfun$4);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HttpContentCodec)) return false;
        HttpContentCodec httpContentCodec = (HttpContentCodec)object;
        ListMap<MediaType, BinaryCodec<A>> listMap = this.choices();
        ListMap<MediaType, BinaryCodec<A>> listMap2 = httpContentCodec.choices();
        if (listMap == null) {
            if (listMap2 != null) {
                return false;
            }
        } else if (!listMap.equals(listMap2)) return false;
        Schema<A> schema = this.schema();
        Schema<A> schema2 = httpContentCodec.schema();
        if (schema == null) {
            if (schema2 == null) return true;
            return false;
        } else {
            if (!schema.equals(schema2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof HttpContentCodec;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "HttpContentCodec";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "choices";
        }
        if (1 == n2) {
            return "schema";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ListMap<MediaType, BinaryCodec<A>> choices() {
        return this.choices;
    }

    public Schema<A> schema() {
        return this.schema;
    }

    public HttpContentCodec<A> $plus$plus(HttpContentCodec<A> that) {
        return HttpContentCodec$.MODULE$.apply((ListMap)this.choices().$plus$plus(that.choices()), this.schema());
    }

    public ZIO<Object, Throwable, A> decodeRequest(Request request) {
        MediaType contentType = this.mediaTypeFromContentTypeHeader(request);
        Option<BinaryCodec<A>> option = this.lookup(contentType);
        if (option instanceof Some) {
            BinaryCodec codec = (BinaryCodec)((Some)option).value();
            return request.body().asChunk("zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:33)").flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.fromEither(() -> HttpContentCodec.decodeRequest$$anonfun$1$$anonfun$1(codec, bytes), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:34)"), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:35)");
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(() -> HttpContentCodec.decodeRequest$$anonfun$2(contentType), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:37)");
        }
        throw new MatchError(option);
    }

    public ZIO<Object, Throwable, A> decodeResponse(Response response) {
        MediaType contentType = this.mediaTypeFromContentTypeHeader(response);
        Option<BinaryCodec<A>> option = this.lookup(contentType);
        if (option instanceof Some) {
            BinaryCodec codec = (BinaryCodec)((Some)option).value();
            return response.body().asChunk("zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:45)").flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.fromEither(() -> HttpContentCodec.decodeResponse$$anonfun$1$$anonfun$1(codec, bytes), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:46)"), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:47)");
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(() -> HttpContentCodec.decodeResponse$$anonfun$2(contentType), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:49)");
        }
        throw new MatchError(option);
    }

    private MediaType mediaTypeFromContentTypeHeader(HeaderOps<?> header) {
        if (header.headers().contains(Header$ContentType$.MODULE$.name())) {
            String contentType = header.headers().getUnsafe(Header$ContentType$.MODULE$.name());
            if (MediaType$.MODULE$.contentTypeMap().contains((Object)contentType)) {
                return (MediaType)MediaType$.MODULE$.contentTypeMap().apply((Object)contentType);
            }
            return MediaType$.MODULE$.unsafeParseCustomMediaType(contentType);
        }
        return MediaType$.MODULE$.application().json();
    }

    public Either<String, Body> encode(A value) {
        if (this.choices().isEmpty()) {
            return package$.MODULE$.Left().apply((Object)"No codec defined");
        }
        return package$.MODULE$.Right().apply((Object)Body$.MODULE$.fromChunk((Chunk<Object>)((Chunk)((Encoder)((Tuple2)this.choices().head())._2()).encode(value)), (MediaType)((Tuple2)this.choices().head())._1()));
    }

    public HttpContentCodec<A> only(MediaType mediaType) {
        Object[] objectArray = new Tuple2[1];
        MediaType mediaType2 = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mediaType);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType2, this.lookup(mediaType).getOrElse(() -> this.only$$anonfun$1(mediaType)));
        return HttpContentCodec$.MODULE$.apply((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), this.schema());
    }

    public HttpContentCodec<A> only(Option<MediaType> mediaType) {
        Option<MediaType> option = mediaType;
        if (option instanceof Some) {
            MediaType mediaType2 = (MediaType)((Some)option).value();
            Object[] objectArray = new Tuple2[1];
            MediaType mediaType3 = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mediaType2);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType3, this.lookup(mediaType2).getOrElse(() -> this.only$$anonfun$2(mediaType2)));
            return HttpContentCodec$.MODULE$.apply((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), this.schema());
        }
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        throw new MatchError(option);
    }

    public Tuple2<MediaType, BinaryCodec<A>> chooseFirst(Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return Tuple2$.MODULE$.apply((Object)this.defaultMediaType(), this.defaultCodec());
        }
        Tuple2 result = null;
        for (int i = 0; i < mediaTypes.size(); ++i) {
            Header.Accept.MediaTypeWithQFactor mediaType = (Header.Accept.MediaTypeWithQFactor)mediaTypes.apply(i);
            if (!this.choices().contains((Object)mediaType.mediaType())) continue;
            result = Tuple2$.MODULE$.apply((Object)mediaType.mediaType(), this.choices().apply((Object)mediaType.mediaType()));
            i = mediaTypes.size();
        }
        if (result == null) {
            throw new IllegalArgumentException(new StringBuilder(42).append("None of the media types ").append(mediaTypes).append(" are supported by ").append(this).toString());
        }
        return result;
    }

    public Option<BinaryCodec<A>> lookup(MediaType mediaType) {
        if (this.lookupCache.contains((Object)mediaType)) {
            return (Option)this.lookupCache.apply((Object)mediaType);
        }
        Option codec = this.choices().collectFirst((PartialFunction)new Serializable(mediaType){
            private final MediaType mediaType$3;
            {
                this.mediaType$3 = mediaType$4;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    MediaType mt = (MediaType)tuple2._1();
                    BinaryCodec codec = (BinaryCodec)tuple2._2();
                    if (mt.matches(this.mediaType$3)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    MediaType mt = (MediaType)tuple2._1();
                    BinaryCodec codec = (BinaryCodec)tuple2._2();
                    if (mt.matches(this.mediaType$3)) {
                        return codec;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        MediaType mediaType2 = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mediaType);
        this.lookupCache = (Map)this.lookupCache.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType2, (Object)codec));
        return codec;
    }

    public MediaType defaultMediaType() {
        return this.defaultMediaType;
    }

    public BinaryCodec<A> defaultCodec() {
        return this.defaultCodec;
    }

    public <A> HttpContentCodec<A> copy(ListMap<MediaType, BinaryCodec<A>> choices, Schema<A> schema) {
        return new HttpContentCodec<A>(choices, schema);
    }

    public <A> ListMap<MediaType, BinaryCodec<A>> copy$default$1() {
        return this.choices();
    }

    public <A> Schema<A> copy$default$2() {
        return this.schema();
    }

    public ListMap<MediaType, BinaryCodec<A>> _1() {
        return this.choices();
    }

    public Schema<A> _2() {
        return this.schema();
    }

    private static final MediaType $init$$$anonfun$2() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static final BinaryCodec $init$$$anonfun$4() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static final Either decodeRequest$$anonfun$1$$anonfun$1(BinaryCodec codec$2, Chunk bytes$1) {
        return codec$2.decode((Object)bytes$1);
    }

    private static final Nothing$ decodeRequest$$anonfun$2(MediaType contentType$1) {
        throw new IllegalArgumentException(new StringBuilder(32).append("No codec found for content type ").append(contentType$1).toString());
    }

    private static final Either decodeResponse$$anonfun$1$$anonfun$1(BinaryCodec codec$4, Chunk bytes$2) {
        return codec$4.decode((Object)bytes$2);
    }

    private static final Nothing$ decodeResponse$$anonfun$2(MediaType contentType$2) {
        throw new IllegalArgumentException(new StringBuilder(32).append("No codec found for content type ").append(contentType$2).toString());
    }

    private final BinaryCodec only$$anonfun$1(MediaType mediaType$1) {
        throw new IllegalArgumentException(new StringBuilder(31).append("MediaType ").append(mediaType$1).append(" is not supported by ").append(this).toString());
    }

    private final BinaryCodec only$$anonfun$2(MediaType mediaType$2) {
        throw new IllegalArgumentException(new StringBuilder(31).append("MediaType ").append(mediaType$2).append(" is not supported by ").append(this).toString());
    }
}

