/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import scala.;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.ListMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.Chunk$;
import zio.Zippable;
import zio.Zippable$;
import zio.http.Handler;
import zio.http.HandlerAspect;
import zio.http.HandlerAspect$;
import zio.http.Method;
import zio.http.Method$ANY$;
import zio.http.Path;
import zio.http.Request;
import zio.http.RequestHandlerInput;
import zio.http.Response;
import zio.http.Route;
import zio.http.Route$;
import zio.http.Route$Builder$;
import zio.http.Route$UnhandledConstructor$;
import zio.http.RoutePattern$;
import zio.http.RoutePattern$Tree$;
import zio.http.codec.Combiner;
import zio.http.codec.Combiner$;
import zio.http.codec.Doc;
import zio.http.codec.HttpCodec;
import zio.http.codec.HttpCodec$Path$;
import zio.http.codec.HttpCodecType;
import zio.http.codec.MethodCodec$;
import zio.http.codec.PathCodec;

public final class RoutePattern<A>
implements Product,
Serializable {
    private final Method method;
    private final PathCodec pathCodec;

    public static RoutePattern<BoxedUnit> CONNECT() {
        return RoutePattern$.MODULE$.CONNECT();
    }

    public static RoutePattern<BoxedUnit> DELETE() {
        return RoutePattern$.MODULE$.DELETE();
    }

    public static RoutePattern<BoxedUnit> GET() {
        return RoutePattern$.MODULE$.GET();
    }

    public static RoutePattern<BoxedUnit> HEAD() {
        return RoutePattern$.MODULE$.HEAD();
    }

    public static RoutePattern<BoxedUnit> OPTIONS() {
        return RoutePattern$.MODULE$.OPTIONS();
    }

    public static RoutePattern<BoxedUnit> PATCH() {
        return RoutePattern$.MODULE$.PATCH();
    }

    public static RoutePattern<BoxedUnit> POST() {
        return RoutePattern$.MODULE$.POST();
    }

    public static RoutePattern<BoxedUnit> PUT() {
        return RoutePattern$.MODULE$.PUT();
    }

    public static RoutePattern<BoxedUnit> TRACE() {
        return RoutePattern$.MODULE$.TRACE();
    }

    public static RoutePattern<Path> any() {
        return RoutePattern$.MODULE$.any();
    }

    public static RoutePattern<BoxedUnit> apply(Method method, Path path) {
        return RoutePattern$.MODULE$.apply(method, path);
    }

    public static <A> RoutePattern<A> apply(Method method, PathCodec<A> pathCodec) {
        return RoutePattern$.MODULE$.apply(method, pathCodec);
    }

    public static RoutePattern<BoxedUnit> apply(Method method, String string) {
        return RoutePattern$.MODULE$.apply(method, string);
    }

    public static RoutePattern<BoxedUnit> fromMethod(Method method) {
        return RoutePattern$.MODULE$.fromMethod(method);
    }

    public static RoutePattern<?> fromProduct(Product product) {
        return RoutePattern$.MODULE$.fromProduct(product);
    }

    public RoutePattern(Method method, PathCodec<A> pathCodec) {
        this.method = method;
        this.pathCodec = pathCodec;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RoutePattern)) return false;
        RoutePattern routePattern = (RoutePattern)object;
        Method method = this.method();
        Method method2 = routePattern.method();
        if (method == null) {
            if (method2 != null) {
                return false;
            }
        } else if (!method.equals(method2)) return false;
        PathCodec<A> pathCodec = this.pathCodec();
        PathCodec<A> pathCodec2 = routePattern.pathCodec();
        if (pathCodec == null) {
            if (pathCodec2 == null) return true;
            return false;
        } else {
            if (!pathCodec.equals(pathCodec2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof RoutePattern;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "RoutePattern";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "method";
        }
        if (1 == n2) {
            return "pathCodec";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Method method() {
        return this.method;
    }

    public PathCodec<A> pathCodec() {
        return this.pathCodec;
    }

    public RoutePattern<A> $qmark$qmark(Doc doc) {
        PathCodec<A> pathCodec = this.pathCodec().$qmark$qmark(doc);
        Method method = this.copy$default$1();
        return this.copy(method, pathCodec);
    }

    public <B> RoutePattern<Object> $div(PathCodec<B> that, Combiner<A, B> combiner) {
        PathCodec<Object> pathCodec = this.pathCodec().$plus$plus(that, combiner);
        Method method = this.copy$default$1();
        return this.copy(method, pathCodec);
    }

    public <Env, Err, I> Route<Env, Err> $minus$greater(Handler<Env, Err, I, Response> handler, RequestHandlerInput<A, I> zippable, Object trace) {
        Route.Builder builder = Route$.MODULE$.route(Route$Builder$.MODULE$.apply(this, HandlerAspect$.MODULE$.identity(), Zippable$.MODULE$.ZippableRightIdentity()));
        return Route$UnhandledConstructor$.MODULE$.apply$extension(builder, handler, zippable.zippable(), trace);
    }

    public <Env, Err> Route<Env, Err> $minus$greater(Handler<Env, Response, Request, Response> handler, Object trace) {
        return Route$.MODULE$.handled(this, handler, trace);
    }

    public <Env, Context> Route.Builder<Env, Object> $minus$greater(HandlerAspect<Env, Context> middleware, Zippable<A, Context> zippable) {
        return Route$Builder$.MODULE$.apply(this, middleware, zippable);
    }

    public <B> RoutePattern<B> asType(.eq.colon.eq<A, B> ev) {
        return this;
    }

    public Either<String, A> decode(Method actual, Path path) {
        if (!this.method().matches(actual)) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(39).append("Expected HTTP method ").append(this.method()).append(" but found method ").append(actual).toString());
        }
        return this.pathCodec().decode(path);
    }

    public Doc doc() {
        return this.pathCodec().doc();
    }

    public Either<String, Tuple2<Method, Path>> encode(A value) {
        return this.format(value).map((Function1 & Serializable)_$1 -> Tuple2$.MODULE$.apply((Object)this.method(), _$1));
    }

    public Either<String, Path> format(A value) {
        return this.pathCodec().format(value);
    }

    public boolean matches(Method method, Path path) {
        return this.decode(method, path).isRight();
    }

    public RoutePattern<A> nest(PathCodec<BoxedUnit> prefix) {
        PathCodec<Object> pathCodec = prefix.$plus$plus(this.pathCodec(), Combiner$.MODULE$.leftUnit());
        Method method = this.copy$default$1();
        return this.copy(method, pathCodec);
    }

    public String render() {
        return new StringBuilder(1).append(this.method().render()).append(" ").append(this.pathCodec().render()).toString();
    }

    public HttpCodec<HttpCodecType, A> toHttpCodec() {
        return MethodCodec$.MODULE$.method(this.method()).$plus$plus(HttpCodec$Path$.MODULE$.apply(this.pathCodec(), HttpCodec$Path$.MODULE$.$lessinit$greater$default$2()), Combiner$.MODULE$.leftUnit());
    }

    public String toString() {
        return this.render();
    }

    public Option<A> unapply(Tuple2<Method, Path> tuple) {
        return this.decode((Method)tuple._1(), (Path)tuple._2()).toOption();
    }

    public <A> RoutePattern<A> copy(Method method, PathCodec<A> pathCodec) {
        return new RoutePattern<A>(method, pathCodec);
    }

    public <A> Method copy$default$1() {
        return this.method();
    }

    public <A> PathCodec<A> copy$default$2() {
        return this.pathCodec();
    }

    public Method _1() {
        return this.method();
    }

    public PathCodec<A> _2() {
        return this.pathCodec();
    }

    public static final class Tree<A>
    implements Product,
    Serializable {
        private final ListMap roots;

        public static <A> Tree<A> apply(ListMap<Method, PathCodec.SegmentSubtree<A>> listMap) {
            return RoutePattern$Tree$.MODULE$.apply(listMap);
        }

        public static <A> Tree<A> apply(RoutePattern<?> routePattern, A a) {
            return RoutePattern$Tree$.MODULE$.apply(routePattern, a);
        }

        public static Tree<Nothing$> empty() {
            return RoutePattern$Tree$.MODULE$.empty();
        }

        public static Tree<?> fromProduct(Product product) {
            return RoutePattern$Tree$.MODULE$.fromProduct(product);
        }

        public static <A> Tree<A> unapply(Tree<A> tree) {
            return RoutePattern$Tree$.MODULE$.unapply(tree);
        }

        public Tree(ListMap<Method, PathCodec.SegmentSubtree<A>> roots) {
            this.roots = roots;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Tree)) return false;
            Tree tree = (Tree)object;
            ListMap<Method, PathCodec.SegmentSubtree<A>> listMap = this.roots();
            ListMap<Method, PathCodec.SegmentSubtree<A>> listMap2 = tree.roots();
            if (listMap != null) {
                if (!listMap.equals(listMap2)) return false;
                return true;
            }
            if (listMap2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Tree;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Tree";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "roots";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ListMap<Method, PathCodec.SegmentSubtree<A>> roots() {
            return this.roots;
        }

        public <A1> Tree<A1> $plus$plus(Tree<A1> that) {
            return RoutePattern$Tree$.MODULE$.apply(RoutePattern$.MODULE$.zio$http$RoutePattern$$$mergeMaps(this.roots(), that.roots(), (Function2 & Serializable)(_$2, _$3) -> _$2.$plus$plus(_$3)));
        }

        public <A1> Tree<A1> add(RoutePattern<?> routePattern, A1 value) {
            return this.$plus$plus(RoutePattern$Tree$.MODULE$.apply(routePattern, value));
        }

        public <A1> Tree<A1> addAll(Iterable<Tuple2<RoutePattern<?>, A1>> pathPatterns) {
            return (Tree)pathPatterns.foldLeft((Object)this, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Tree tree = (Tree)tuple2._1();
                    if (tuple22 != null) {
                        RoutePattern p = (RoutePattern)tuple22._1();
                        Object v = tuple22._2();
                        return tree.add(p, v);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public Chunk<A> get(Method method, Path path) {
            Chunk chunk;
            Chunk chunk2;
            Option option = this.roots().get((Object)Method$ANY$.MODULE$);
            if (None$.MODULE$.equals(option)) {
                chunk2 = Chunk$.MODULE$.empty();
            } else if (option instanceof Some) {
                PathCodec.SegmentSubtree value = (PathCodec.SegmentSubtree)((Some)option).value();
                chunk2 = value.get(path);
            } else {
                throw new MatchError((Object)option);
            }
            Chunk wildcards = chunk2;
            Option option2 = this.roots().get((Object)method);
            if (None$.MODULE$.equals(option2)) {
                chunk = Chunk$.MODULE$.empty();
            } else if (option2 instanceof Some) {
                PathCodec.SegmentSubtree value = (PathCodec.SegmentSubtree)((Some)option2).value();
                chunk = value.get(path);
            } else {
                throw new MatchError((Object)option2);
            }
            return chunk.$plus$plus(wildcards);
        }

        public <B> Tree<B> map(Function1<A, B> f) {
            return RoutePattern$Tree$.MODULE$.apply((ListMap)this.roots().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method k = (Method)tuple2._1();
                    PathCodec.SegmentSubtree v = (PathCodec.SegmentSubtree)tuple2._2();
                    Method method = (Method)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)method, v.map(f));
                }
                throw new MatchError((Object)tuple2);
            }));
        }

        public <A> Tree<A> copy(ListMap<Method, PathCodec.SegmentSubtree<A>> roots) {
            return new Tree<A>(roots);
        }

        public <A> ListMap<Method, PathCodec.SegmentSubtree<A>> copy$default$1() {
            return this.roots();
        }

        public ListMap<Method, PathCodec.SegmentSubtree<A>> _1() {
            return this.roots();
        }
    }
}

