/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike$;
import zio.IsSubtypeOfError$;
import zio.http.codec.internal.TextBinaryCodec$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.codec.BinaryCodec;
import zio.schema.codec.DecodeError;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public final class TextBinaryCodec$ {
    public static TextBinaryCodec$ MODULE$;

    static {
        new TextBinaryCodec$();
    }

    private <A> BinaryCodec<A> errorCodec(Schema<A> schema) {
        return new BinaryCodec<A>(schema){
            private final Schema schema$1;

            public Either<DecodeError, A> decode(Chunk<Object> whole) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
            }

            public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
            }

            public Chunk<Object> encode(A value) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
            }

            public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
            }
            {
                this.schema$1 = schema$1;
            }
        };
    }

    public <A> BinaryCodec<A> fromSchema(Schema<A> schema) {
        while (true) {
            if (schema instanceof Schema.Enum) {
                Schema.Enum enum_ = (Schema.Enum)schema;
                return this.errorCodec((Schema<A>)enum_);
            }
            if (schema instanceof Schema.Record) {
                Schema.Record record = (Schema.Record)schema;
                return this.errorCodec((Schema<A>)record);
            }
            if (schema instanceof Schema.Collection) {
                Schema.Collection collection = (Schema.Collection)schema;
                return this.errorCodec((Schema<A>)collection);
            }
            if (schema instanceof Schema.Transform) {
                Schema.Transform transform = (Schema.Transform)schema;
                Schema schema2 = transform.schema();
                Function1 f = transform.f();
                Function1 g = transform.g();
                BinaryCodec<A> codec2 = this.fromSchema(schema2);
                return new BinaryCodec<A>(codec2, g, f){
                    private final BinaryCodec codec$1;
                    private final Function1 g$1;
                    private final Function1 f$1;

                    public Chunk<Object> encode(A a) {
                        return (Chunk)this.codec$1.encode(((Either)this.g$1.apply(a)).fold((Function1 & Serializable & scala.Serializable)e -> {
                            throw new Exception((String)e);
                        }, (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)));
                    }

                    public Either<DecodeError, A> decode(Chunk<Object> c) {
                        return this.codec$1.decode(c).flatMap((Function1 & Serializable & scala.Serializable)x -> ((Either)$this.f$1.apply(x)).left().map((Function1 & Serializable & scala.Serializable)x$1 -> new DecodeError.ReadError(Cause$.MODULE$.fail((Object)new Exception("Error during decoding"), Cause$.MODULE$.fail$default$2()), x$1)));
                    }

                    public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                        return ZPipeline$.MODULE$.mapChunks((Function1 & Serializable & scala.Serializable)x$2 -> (Chunk)x$2.flatMap((Function1 & Serializable & scala.Serializable)a -> this.encode((A)a), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.chunkCanBuildFromByte())), (Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:49)");
                    }

                    public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                        return this.codec$1.streamDecoder().map((Function1 & Serializable & scala.Serializable)x -> {
                            Either either = (Either)$this.f$1.apply(x);
                            if (either instanceof Left) {
                                String value = (String)((Left)either).value();
                                throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)new Exception("Error in decoding"), Cause$.MODULE$.fail$default$2()), value);
                            }
                            if (either instanceof Right) {
                                return ((Right)either).value();
                            }
                            throw new MatchError((Object)either);
                        }, (Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:50)");
                    }
                    {
                        this.codec$1 = codec$1;
                        this.g$1 = g$1;
                        this.f$1 = f$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$encode$1(java.lang.String ), $anonfun$encode$2(java.lang.Object ), $anonfun$decode$1(zio.http.codec.internal.TextBinaryCodec$$anon$2 java.lang.Object ), $anonfun$streamEncoder$1(zio.http.codec.internal.TextBinaryCodec$$anon$2 zio.Chunk ), $anonfun$streamDecoder$1(zio.http.codec.internal.TextBinaryCodec$$anon$2 java.lang.Object ), $anonfun$decode$2(java.lang.String ), $anonfun$streamEncoder$2(zio.http.codec.internal.TextBinaryCodec$$anon$2 java.lang.Object )}, serializedLambda);
                    }
                };
            }
            if (schema instanceof Schema.Primitive) {
                return new BinaryCodec<A>(schema){
                    private final Function1<String, Either<DecodeError, Object>> decode0;
                    private volatile boolean bitmap$init$0;
                    private final Schema schema$2;

                    private Function1<String, Either<DecodeError, Object>> decode0() {
                        if (!this.bitmap$init$0) {
                            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/codec/internal/TextBinaryCodec.scala: 59");
                        }
                        return this.decode0;
                    }

                    public Chunk<Object> encode(A a) {
                        if (this.schema$2 instanceof Schema.Primitive) {
                            return Chunk$.MODULE$.fromArray((Object)a.toString().getBytes());
                        }
                        throw new IllegalArgumentException(new StringBuilder(36).append("Cannot encode ").append(a).append(" of type ").append(a.getClass()).append(" with schema ").append(this.schema$2).toString());
                    }

                    public Either<DecodeError, A> decode(Chunk<Object> c) {
                        return ((Either)this.decode0().apply((Object)c.asString(Chunk.IsText$.MODULE$.byteIsText()))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6);
                    }

                    public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                        return ZPipeline$.MODULE$.map((Function1 & Serializable & scala.Serializable)a -> Chunk$.MODULE$.fromArray((Object)a.toString().getBytes()), (Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:275)").flattenChunks(Predef$.MODULE$.$conforms(), (Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:275)");
                    }

                    public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                        return ZPipeline$.MODULE$.apply((Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:278)").$greater$greater$greater((Function0 & Serializable & scala.Serializable)() -> ZPipeline$.MODULE$.utf8Decode((Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:278)"), (Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:278)").map((Function1 & Serializable & scala.Serializable)s -> this.decode((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)s.getBytes())).fold((Function1 & Serializable & scala.Serializable)x$7 -> {
                            throw (Throwable)x$7;
                        }, (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)), (Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:279)").mapErrorCause((Function1 & Serializable & scala.Serializable)e -> Cause$.MODULE$.fail((Object)new DecodeError.ReadError(e, e.squash(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms())).getMessage()), Cause$.MODULE$.fail$default$2()), (Object)"zio.http.codec.internal.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:280)");
                    }

                    public static final /* synthetic */ Right $anonfun$decode0$1(Right result$1, String x$3) {
                        return result$1;
                    }

                    public static final /* synthetic */ Left $anonfun$decode0$10(Left result$2, String x$4) {
                        return result$2;
                    }

                    public static final /* synthetic */ Left $anonfun$decode0$31(Left result$3, String x$5) {
                        return result$3;
                    }
                    {
                        Function1 & Serializable & scala.Serializable intersect;
                        this.schema$2 = schema$2;
                        if (schema$2 instanceof Schema.Primitive) {
                            StandardType standardType = ((Schema.Primitive)schema$2).standardType();
                            if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                                intersect = arg_0 -> anon.3.$anonfun$decode0$1(package$.MODULE$.Right().apply((Object)""), arg_0);
                            } else if (StandardType.StringType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> package$.MODULE$.Right().apply(s);
                            } else if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).toBoolean()));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(s)).toByte()));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.ShortType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(s)).toShort()));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.IntType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s)).toInt()));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.LongType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(s)).toLong()));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.FloatType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(s)).toFloat()));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(s)).toDouble()));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                                intersect = arg_0 -> anon.3.$anonfun$decode0$10(package$.MODULE$.Left().apply((Object)new DecodeError.UnsupportedSchema(schema$2, "TextCodec")), arg_0);
                            } else if (StandardType.CharType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToCharacter((char)s.charAt(0)));
                            } else if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)UUID.fromString(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)package$.MODULE$.BigDecimal().apply(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)package$.MODULE$.BigInt().apply(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)DayOfWeek.valueOf(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.MonthType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)Month.valueOf(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)MonthDay.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)Period.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.YearType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)Year.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)YearMonth.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)ZoneId.of(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)ZoneOffset.of(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.DurationType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)Duration.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.InstantType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)Instant.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.LocalDateType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)LocalDate.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.LocalTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)LocalTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)LocalDateTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.OffsetTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)OffsetTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)OffsetDateTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else {
                                if (!StandardType.ZonedDateTimeType$.MODULE$.equals(standardType)) throw new MatchError((Object)standardType);
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    try {
                                        return package$.MODULE$.Right().apply((Object)ZonedDateTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            }
                        } else {
                            intersect = arg_0 -> anon.3.$anonfun$decode0$31(package$.MODULE$.Left().apply((Object)new DecodeError.UnsupportedSchema(schema$2, "Only primitive types are supported for text decoding.")), arg_0);
                        }
                        this.decode0 = intersect;
                        this.bitmap$init$0 = true;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$3(java.lang.Object ), $anonfun$streamEncoder$3(java.lang.Object ), $anonfun$streamDecoder$2(), $anonfun$streamDecoder$3(zio.http.codec.internal.TextBinaryCodec$$anon$3 java.lang.String ), $anonfun$streamDecoder$6(zio.Cause ), $anonfun$streamDecoder$4(zio.schema.codec.DecodeError ), $anonfun$streamDecoder$5(java.lang.Object ), $anonfun$decode0$1(scala.util.Right java.lang.String ), $anonfun$decode0$2(java.lang.String ), $anonfun$decode0$3(java.lang.String ), $anonfun$decode0$4(java.lang.String ), $anonfun$decode0$5(java.lang.String ), $anonfun$decode0$6(java.lang.String ), $anonfun$decode0$7(java.lang.String ), $anonfun$decode0$8(java.lang.String ), $anonfun$decode0$9(java.lang.String ), $anonfun$decode0$10(scala.util.Left java.lang.String ), $anonfun$decode0$11(java.lang.String ), $anonfun$decode0$12(java.lang.String ), $anonfun$decode0$13(java.lang.String ), $anonfun$decode0$14(java.lang.String ), $anonfun$decode0$15(java.lang.String ), $anonfun$decode0$16(java.lang.String ), $anonfun$decode0$17(java.lang.String ), $anonfun$decode0$18(java.lang.String ), $anonfun$decode0$19(java.lang.String ), $anonfun$decode0$20(java.lang.String ), $anonfun$decode0$21(java.lang.String ), $anonfun$decode0$22(java.lang.String ), $anonfun$decode0$23(java.lang.String ), $anonfun$decode0$24(java.lang.String ), $anonfun$decode0$25(java.lang.String ), $anonfun$decode0$26(java.lang.String ), $anonfun$decode0$27(java.lang.String ), $anonfun$decode0$28(java.lang.String ), $anonfun$decode0$29(java.lang.String ), $anonfun$decode0$30(java.lang.String ), $anonfun$decode0$31(scala.util.Left java.lang.String )}, serializedLambda);
                    }
                };
            }
            if (!(schema instanceof Schema.Lazy)) break;
            schema = (Schema)((Schema.Lazy)schema).schema0$access$0().apply();
        }
        return this.errorCodec(schema);
    }

    private TextBinaryCodec$() {
        MODULE$ = this;
    }
}

