/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Right;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.IsSubtypeOfError$;
import zio.http.codec.internal.TextCodec$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.codec.BinaryCodec;
import zio.schema.codec.DecodeError;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public final class TextCodec$ {
    public static TextCodec$ MODULE$;

    static {
        new TextCodec$();
    }

    public <A> BinaryCodec<A> fromSchema(Schema<A> schema) {
        if (!(schema instanceof Schema.Primitive)) {
            return new BinaryCodec<A>(schema){
                private final Schema schema$1;

                public Either<DecodeError, A> decode(Chunk<Object> whole) {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
                }

                public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
                }

                public Chunk<Object> encode(A value) {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
                }

                public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
                }
                {
                    this.schema$1 = schema$1;
                }
            };
        }
        return new BinaryCodec<A>(schema){
            private final Schema schema$1;

            public Chunk<Object> encode(A a) {
                if (this.schema$1 instanceof Schema.Primitive) {
                    return Chunk$.MODULE$.fromArray((Object)a.toString().getBytes());
                }
                throw new IllegalArgumentException(new StringBuilder(36).append("Cannot encode ").append(a).append(" of type ").append(a.getClass()).append(" with schema ").append(this.schema$1).toString());
            }

            public Either<DecodeError, A> decode(Chunk<Object> c) {
                String s = c.asString(Chunk.IsText$.MODULE$.byteIsText());
                Schema schema = this.schema$1;
                if (schema instanceof Schema.Primitive) {
                    Right right;
                    StandardType standardType = ((Schema.Primitive)schema).standardType();
                    if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                        right = package$.MODULE$.Right().apply((Object)"");
                    } else if (StandardType.StringType$.MODULE$.equals(standardType)) {
                        right = package$.MODULE$.Right().apply((Object)s);
                    } else if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree1$1(s);
                    } else if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree2$1(s);
                    } else if (StandardType.ShortType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree3$1(s);
                    } else if (StandardType.IntType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree4$1(s);
                    } else if (StandardType.LongType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree5$1(s);
                    } else if (StandardType.FloatType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree6$1(s);
                    } else if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree7$1(s);
                    } else if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                        right = package$.MODULE$.Left().apply((Object)new DecodeError.UnsupportedSchema(this.schema$1, "TextCodec"));
                    } else if (StandardType.CharType$.MODULE$.equals(standardType)) {
                        right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToCharacter((char)s.charAt(0)));
                    } else if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree8$1(s);
                    } else if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree9$1(s);
                    } else if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree10$1(s);
                    } else if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree11$1(s);
                    } else if (StandardType.MonthType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree12$1(s);
                    } else if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree13$1(s);
                    } else if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree14$1(s);
                    } else if (StandardType.YearType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree15$1(s);
                    } else if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree16$1(s);
                    } else if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree17$1(s);
                    } else if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree18$1(s);
                    } else if (StandardType.DurationType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree19$1(s);
                    } else if (StandardType.InstantType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree20$1(s);
                    } else if (StandardType.LocalDateType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree21$1(s);
                    } else if (StandardType.LocalTimeType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree22$1(s);
                    } else if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree23$1(s);
                    } else if (StandardType.OffsetTimeType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree24$1(s);
                    } else if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree25$1(s);
                    } else if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType)) {
                        right = anon.2.liftedTree26$1(s);
                    } else {
                        throw new MatchError((Object)standardType);
                    }
                    return right.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1);
                }
                return package$.MODULE$.Left().apply((Object)new DecodeError.UnsupportedSchema(schema, "Only primitive types are supported for text decoding."));
            }

            public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                return ZPipeline$.MODULE$.map((Function1 & Serializable & scala.Serializable)a -> Chunk$.MODULE$.fromArray((Object)a.toString().getBytes()), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamEncoder(TextCodec.scala:222)").flattenChunks(Predef$.MODULE$.$conforms(), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamEncoder(TextCodec.scala:222)");
            }

            public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                return ZPipeline$.MODULE$.apply((Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(TextCodec.scala:225)").$greater$greater$greater((Function0 & Serializable & scala.Serializable)() -> ZPipeline$.MODULE$.utf8Decode((Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(TextCodec.scala:225)"), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(TextCodec.scala:225)").map((Function1 & Serializable & scala.Serializable)s -> this.decode((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)s.getBytes())).fold((Function1 & Serializable & scala.Serializable)x$2 -> {
                    throw (Throwable)x$2;
                }, (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(TextCodec.scala:226)").mapErrorCause((Function1 & Serializable & scala.Serializable)e -> Cause$.MODULE$.fail((Object)new DecodeError.ReadError(e, e.squash(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms())).getMessage()), Cause$.MODULE$.fail$default$2()), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(TextCodec.scala:227)");
            }

            private static final /* synthetic */ Either liftedTree1$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(s$1)).toBoolean()));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree2$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(s$1)).toByte()));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree3$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(s$1)).toShort()));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree4$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s$1)).toInt()));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree5$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(s$1)).toLong()));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree6$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(s$1)).toFloat()));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree7$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(s$1)).toDouble()));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree8$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)UUID.fromString(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree9$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)package$.MODULE$.BigDecimal().apply(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree10$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)package$.MODULE$.BigInt().apply(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree11$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)DayOfWeek.valueOf(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree12$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)Month.valueOf(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree13$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)MonthDay.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree14$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)Period.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree15$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)Year.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree16$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)YearMonth.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree17$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)ZoneId.of(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree18$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)ZoneOffset.of(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree19$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)Duration.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree20$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)Instant.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree21$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)LocalDate.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree22$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)LocalTime.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree23$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)LocalDateTime.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree24$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)OffsetTime.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree25$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)OffsetDateTime.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }

            private static final /* synthetic */ Either liftedTree26$1(String s$1) {
                try {
                    return package$.MODULE$.Right().apply((Object)ZonedDateTime.parse(s$1));
                }
                catch (Exception e) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
            }
            {
                this.schema$1 = schema$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$1(java.lang.Object ), $anonfun$streamEncoder$1(java.lang.Object ), $anonfun$streamDecoder$1(), $anonfun$streamDecoder$2(zio.http.codec.internal.TextCodec$$anon$2 java.lang.String ), $anonfun$streamDecoder$5(zio.Cause ), $anonfun$streamDecoder$3(zio.schema.codec.DecodeError ), $anonfun$streamDecoder$4(java.lang.Object )}, serializedLambda);
            }
        };
    }

    private TextCodec$() {
        MODULE$ = this;
    }
}

