/*
 * Decompiled with CFR 0.152.
 */
package zio.http.shaded.netty.incubator.channel.uring;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import zio.http.shaded.netty.channel.EventLoop;
import zio.http.shaded.netty.channel.EventLoopTaskQueueFactory;
import zio.http.shaded.netty.channel.MultithreadEventLoopGroup;
import zio.http.shaded.netty.incubator.channel.uring.IOUring;
import zio.http.shaded.netty.incubator.channel.uring.IOUringEventLoop;
import zio.http.shaded.netty.incubator.channel.uring.Native;
import zio.http.shaded.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import zio.http.shaded.netty.util.concurrent.EventExecutorChooserFactory;
import zio.http.shaded.netty.util.concurrent.RejectedExecutionHandler;
import zio.http.shaded.netty.util.concurrent.RejectedExecutionHandlers;
import zio.http.shaded.netty.util.concurrent.ThreadPerTaskExecutor;
import zio.http.shaded.netty.util.internal.ObjectUtil;

public final class IOUringEventLoopGroup
extends MultithreadEventLoopGroup {
    public IOUringEventLoopGroup() {
        this(0);
    }

    public IOUringEventLoopGroup(int nThreads) {
        this(nThreads, (ThreadFactory)null);
    }

    public IOUringEventLoopGroup(ThreadFactory threadFactory) {
        this(0, threadFactory, 0, Native.DEFAULT_IOSEQ_ASYNC_THRESHOLD);
    }

    public IOUringEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        this(nThreads, threadFactory, 0, Native.DEFAULT_IOSEQ_ASYNC_THRESHOLD);
    }

    public IOUringEventLoopGroup(int nThreads, Executor executor) {
        this(nThreads, executor, 0, Native.DEFAULT_IOSEQ_ASYNC_THRESHOLD);
    }

    public IOUringEventLoopGroup(int nThreads, ThreadFactory threadFactory, int ringSize, int iosqeAsyncThreshold) {
        this(nThreads, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor(threadFactory)), ringSize, iosqeAsyncThreshold);
    }

    public IOUringEventLoopGroup(int nThreads, Executor executor, int ringsize, int iosqeAsyncThreshold) {
        this(nThreads, executor, (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, ringsize, iosqeAsyncThreshold, RejectedExecutionHandlers.reject());
    }

    private IOUringEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, int ringSize, int iosqeAsyncThreshold, RejectedExecutionHandler rejectedExecutionHandler) {
        this(nThreads, executor, chooserFactory, ringSize, iosqeAsyncThreshold, rejectedExecutionHandler, null);
    }

    private IOUringEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, int ringSize, int iosqeAsyncThreshold, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory queueFactory) {
        super(nThreads, executor, chooserFactory, ringSize, iosqeAsyncThreshold, rejectedExecutionHandler, queueFactory);
    }

    @Override
    protected EventLoop newChild(Executor executor, Object ... args) {
        if (args.length != 4) {
            throw new IllegalArgumentException("Illegal amount of extra arguments");
        }
        int ringSize = ObjectUtil.checkPositiveOrZero((Integer)args[0], "ringSize");
        if (ringSize == 0) {
            ringSize = Native.DEFAULT_RING_SIZE;
        }
        int iosqeAsyncThreshold = ObjectUtil.checkPositiveOrZero((Integer)args[1], "iosqeAsyncThreshold");
        RejectedExecutionHandler rejectedExecutionHandler = (RejectedExecutionHandler)args[2];
        EventLoopTaskQueueFactory taskQueueFactory = (EventLoopTaskQueueFactory)args[3];
        return new IOUringEventLoop(this, executor, ringSize, iosqeAsyncThreshold, rejectedExecutionHandler, taskQueueFactory);
    }

    static {
        IOUring.ensureAvailability();
    }
}

