/*
 * Decompiled with CFR 0.152.
 */
package zio.http.shaded.netty.handler.timeout;

import java.util.concurrent.TimeUnit;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.handler.timeout.IdleState;
import zio.http.shaded.netty.handler.timeout.IdleStateEvent;
import zio.http.shaded.netty.handler.timeout.IdleStateHandler;
import zio.http.shaded.netty.handler.timeout.ReadTimeoutException;

public class ReadTimeoutHandler
extends IdleStateHandler {
    private boolean closed;

    public ReadTimeoutHandler(int timeoutSeconds) {
        this(timeoutSeconds, TimeUnit.SECONDS);
    }

    public ReadTimeoutHandler(long timeout, TimeUnit unit) {
        super(timeout, 0L, 0L, unit);
    }

    @Override
    protected final void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        assert (evt.state() == IdleState.READER_IDLE);
        this.readTimedOut(ctx);
    }

    protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
        if (!this.closed) {
            ctx.fireExceptionCaught(ReadTimeoutException.INSTANCE);
            ctx.close();
            this.closed = true;
        }
    }
}

