/*
 * Decompiled with CFR 0.152.
 */
package zio.http.shaded.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import zio.http.shaded.netty.channel.ChannelFuture;
import zio.http.shaded.netty.channel.ChannelFutureListener;
import zio.http.shaded.netty.channel.ChannelHandler;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import zio.http.shaded.netty.util.internal.ConcurrentSet;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = new ConcurrentSet<InetAddress>();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (!this.connected.add(remoteIp)) {
            return false;
        }
        ctx.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

