/*
 * Decompiled with CFR 0.152.
 */
package zio.http.shaded.netty.handler.codec.string;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import zio.http.shaded.netty.buffer.ByteBufUtil;
import zio.http.shaded.netty.channel.ChannelHandler;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.handler.codec.MessageToMessageEncoder;
import zio.http.shaded.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        out.add(ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg), this.charset));
    }
}

