/*
 * Decompiled with CFR 0.152.
 */
package zio.http.shaded.netty.handler.address;

import java.net.SocketAddress;
import zio.http.shaded.netty.channel.ChannelHandler;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.channel.ChannelOutboundHandlerAdapter;
import zio.http.shaded.netty.channel.ChannelPromise;
import zio.http.shaded.netty.resolver.AddressResolver;
import zio.http.shaded.netty.resolver.AddressResolverGroup;
import zio.http.shaded.netty.util.concurrent.Future;
import zio.http.shaded.netty.util.concurrent.FutureListener;
import zio.http.shaded.netty.util.concurrent.GenericFutureListener;
import zio.http.shaded.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(resolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver<? extends SocketAddress> resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect(future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove(this);
        }
    }
}

