/*
 * Decompiled with CFR 0.152.
 */
package zio.http.shaded.netty.handler.address;

import java.net.SocketAddress;
import zio.http.shaded.netty.channel.ChannelFuture;
import zio.http.shaded.netty.channel.ChannelFutureListener;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.channel.ChannelOutboundHandlerAdapter;
import zio.http.shaded.netty.channel.ChannelPromise;

public abstract class DynamicAddressConnectHandler
extends ChannelOutboundHandlerAdapter {
    @Override
    public final void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        SocketAddress local;
        SocketAddress remote;
        try {
            remote = this.remoteAddress(remoteAddress, localAddress);
            local = this.localAddress(remoteAddress, localAddress);
        }
        catch (Exception e) {
            promise.setFailure(e);
            return;
        }
        ctx.connect(remote, local, promise).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    future.channel().pipeline().remove(DynamicAddressConnectHandler.this);
                }
            }
        });
    }

    protected SocketAddress localAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return localAddress;
    }

    protected SocketAddress remoteAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return remoteAddress;
    }
}

