/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.socket;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.MatchError;
import scala.runtime.ModuleSerializationProxy;
import zio.http.SocketDecoder;
import zio.http.WebSocketConfig;
import zio.http.WebSocketConfig$CloseStatus$AbnormalClosure$;
import zio.http.WebSocketConfig$CloseStatus$BadGateway$;
import zio.http.WebSocketConfig$CloseStatus$Custom$;
import zio.http.WebSocketConfig$CloseStatus$Empty$;
import zio.http.WebSocketConfig$CloseStatus$EndpointUnavailable$;
import zio.http.WebSocketConfig$CloseStatus$InternalServerError$;
import zio.http.WebSocketConfig$CloseStatus$InvalidMessageType$;
import zio.http.WebSocketConfig$CloseStatus$InvalidPayloadData$;
import zio.http.WebSocketConfig$CloseStatus$MandatoryExtension$;
import zio.http.WebSocketConfig$CloseStatus$MessageTooBig$;
import zio.http.WebSocketConfig$CloseStatus$NormalClosure$;
import zio.http.WebSocketConfig$CloseStatus$PolicyViolation$;
import zio.http.WebSocketConfig$CloseStatus$ProtocolError$;
import zio.http.WebSocketConfig$CloseStatus$ServiceRestart$;
import zio.http.WebSocketConfig$CloseStatus$TlsHandshakeFailed$;
import zio.http.WebSocketConfig$CloseStatus$TryAgainLater$;
import zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;

public final class NettySocketProtocol$
implements Serializable {
    public static final NettySocketProtocol$ MODULE$ = new NettySocketProtocol$();

    private NettySocketProtocol$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettySocketProtocol$.class);
    }

    public WebSocketClientProtocolConfig.Builder clientBuilder(WebSocketConfig webSocketConfig) {
        return WebSocketClientProtocolConfig.newBuilder().subprotocol((String)webSocketConfig.subprotocols().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).handshakeTimeoutMillis(webSocketConfig.handshakeTimeoutMillis()).forceCloseTimeoutMillis(webSocketConfig.forceCloseTimeoutMillis()).handleCloseFrames(webSocketConfig.handleCloseFrames()).sendCloseFrame(this.closeStatusToNetty(webSocketConfig.sendCloseFrame())).dropPongFrames(webSocketConfig.dropPongFrames()).maxFramePayloadLength(webSocketConfig.decoderConfig().maxFramePayloadLength()).allowMaskMismatch(webSocketConfig.decoderConfig().allowMaskMismatch()).allowExtensions(webSocketConfig.decoderConfig().allowExtensions()).withUTF8Validator(webSocketConfig.decoderConfig().withUTF8Validator());
    }

    public WebSocketServerProtocolConfig.Builder serverBuilder(WebSocketConfig webSocketConfig) {
        return WebSocketServerProtocolConfig.newBuilder().checkStartsWith(true).websocketPath("").subprotocols((String)webSocketConfig.subprotocols().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).handshakeTimeoutMillis(webSocketConfig.handshakeTimeoutMillis()).forceCloseTimeoutMillis(webSocketConfig.forceCloseTimeoutMillis()).handleCloseFrames(webSocketConfig.handleCloseFrames()).sendCloseFrame(this.closeStatusToNetty(webSocketConfig.sendCloseFrame())).dropPongFrames(webSocketConfig.dropPongFrames()).decoderConfig(this.socketDecoderToNetty(webSocketConfig.decoderConfig()));
    }

    private WebSocketCloseStatus closeStatusToNetty(WebSocketConfig.CloseStatus closeStatus) {
        WebSocketConfig.CloseStatus closeStatus2 = closeStatus;
        if (WebSocketConfig$CloseStatus$NormalClosure$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.NORMAL_CLOSURE;
        }
        if (WebSocketConfig$CloseStatus$EndpointUnavailable$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.ENDPOINT_UNAVAILABLE;
        }
        if (WebSocketConfig$CloseStatus$ProtocolError$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.PROTOCOL_ERROR;
        }
        if (WebSocketConfig$CloseStatus$InvalidMessageType$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.INVALID_MESSAGE_TYPE;
        }
        if (WebSocketConfig$CloseStatus$InvalidPayloadData$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.INVALID_PAYLOAD_DATA;
        }
        if (WebSocketConfig$CloseStatus$PolicyViolation$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.POLICY_VIOLATION;
        }
        if (WebSocketConfig$CloseStatus$MessageTooBig$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.MESSAGE_TOO_BIG;
        }
        if (WebSocketConfig$CloseStatus$MandatoryExtension$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.MANDATORY_EXTENSION;
        }
        if (WebSocketConfig$CloseStatus$InternalServerError$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.INTERNAL_SERVER_ERROR;
        }
        if (WebSocketConfig$CloseStatus$ServiceRestart$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.SERVICE_RESTART;
        }
        if (WebSocketConfig$CloseStatus$TryAgainLater$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.TRY_AGAIN_LATER;
        }
        if (WebSocketConfig$CloseStatus$BadGateway$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.BAD_GATEWAY;
        }
        if (WebSocketConfig$CloseStatus$Empty$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.EMPTY;
        }
        if (WebSocketConfig$CloseStatus$AbnormalClosure$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.ABNORMAL_CLOSURE;
        }
        if (WebSocketConfig$CloseStatus$TlsHandshakeFailed$.MODULE$.equals(closeStatus2)) {
            return WebSocketCloseStatus.TLS_HANDSHAKE_FAILED;
        }
        if (closeStatus2 instanceof WebSocketConfig.CloseStatus.Custom) {
            WebSocketConfig.CloseStatus.Custom custom = WebSocketConfig$CloseStatus$Custom$.MODULE$.unapply((WebSocketConfig.CloseStatus.Custom)closeStatus2);
            int n = custom._1();
            String string = custom._2();
            int code = n;
            String message = string;
            return new WebSocketCloseStatus(code, message);
        }
        throw new MatchError((Object)closeStatus2);
    }

    private WebSocketDecoderConfig socketDecoderToNetty(SocketDecoder socketDecoder) {
        return WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(socketDecoder.maxFramePayloadLength()).expectMaskedFrames(socketDecoder.expectMaskedFrames()).allowMaskMismatch(socketDecoder.allowMaskMismatch()).allowExtensions(socketDecoder.allowExtensions()).closeOnProtocolViolation(socketDecoder.closeOnProtocolViolation()).withUTF8Validator(socketDecoder.withUTF8Validator()).build();
    }
}

