/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import java.util.List;
import zio.http.SSLConfig;
import zio.http.SSLConfig$HttpBehaviour$Accept$;
import zio.http.Server;
import zio.http.netty.package$Names$;
import zio.http.netty.server.SSLUtil$;
import zio.http.netty.server.ServerHttpsHandler;
import zio.http.shaded.netty.buffer.ByteBuf;
import zio.http.shaded.netty.channel.ChannelHandler;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.channel.ChannelPipeline;
import zio.http.shaded.netty.handler.codec.ByteToMessageDecoder;
import zio.http.shaded.netty.handler.ssl.SslContext;
import zio.http.shaded.netty.handler.ssl.SslHandler;

public class ServerSSLDecoder
extends ByteToMessageDecoder {
    private final SSLConfig sslConfig;
    private final Server.Config cfg;

    public ServerSSLDecoder(SSLConfig sslConfig, Server.Config cfg) {
        this.sslConfig = sslConfig;
        this.cfg = cfg;
    }

    @Override
    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        ChannelPipeline pipeline = context.channel().pipeline();
        SslContext sslContext = SSLUtil$.MODULE$.sslConfigToSslContext(this.sslConfig);
        SSLConfig.HttpBehaviour httpBehaviour = this.sslConfig.behaviour();
        if (in.readableBytes() < 5) {
            return;
        }
        if (SslHandler.isEncrypted(in)) {
            pipeline.replace(this, package$Names$.MODULE$.SSLHandler(), (ChannelHandler)sslContext.newHandler(context.alloc()));
            return;
        }
        SSLConfig.HttpBehaviour httpBehaviour2 = httpBehaviour;
        if (SSLConfig$HttpBehaviour$Accept$.MODULE$.equals(httpBehaviour2)) {
            pipeline.remove(this);
            return;
        }
        pipeline.remove(package$Names$.MODULE$.HttpRequestHandler());
        if (this.cfg.keepAlive()) {
            pipeline.remove(package$Names$.MODULE$.HttpKeepAliveHandler());
        }
        pipeline.remove(this);
        pipeline.addLast(new ServerHttpsHandler(httpBehaviour));
    }
}

