/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.ZLayer;
import zio.http.SSLConfig;
import zio.http.Server;
import zio.http.Server$RequestStreaming$Disabled$;
import zio.http.Server$RequestStreaming$Enabled$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.ServerChannelInitializer$;
import zio.http.netty.server.ServerSSLDecoder;
import zio.http.shaded.netty.channel.Channel;
import zio.http.shaded.netty.channel.ChannelHandler;
import zio.http.shaded.netty.channel.ChannelInboundHandler;
import zio.http.shaded.netty.channel.ChannelInitializer;
import zio.http.shaded.netty.channel.ChannelPipeline;
import zio.http.shaded.netty.channel.SimpleChannelInboundHandler;
import zio.http.shaded.netty.handler.codec.compression.CompressionOptions;
import zio.http.shaded.netty.handler.codec.compression.DeflateOptions;
import zio.http.shaded.netty.handler.codec.http.HttpContentCompressor;
import zio.http.shaded.netty.handler.codec.http.HttpContentDecompressor;
import zio.http.shaded.netty.handler.codec.http.HttpObject;
import zio.http.shaded.netty.handler.codec.http.HttpObjectAggregator;
import zio.http.shaded.netty.handler.codec.http.HttpRequestDecoder;
import zio.http.shaded.netty.handler.codec.http.HttpResponseEncoder;
import zio.http.shaded.netty.handler.codec.http.HttpServerExpectContinueHandler;
import zio.http.shaded.netty.handler.codec.http.HttpServerKeepAliveHandler;
import zio.http.shaded.netty.handler.flush.FlushConsolidationHandler;
import zio.http.shaded.netty.handler.timeout.ReadTimeoutHandler;

@ChannelHandler.Sharable
public final class ServerChannelInitializer
extends ChannelInitializer<Channel>
implements Product,
Serializable {
    private final Server.Config cfg;
    private final ChannelInboundHandler reqHandler;

    public static ServerChannelInitializer apply(Server.Config config, ChannelInboundHandler channelInboundHandler) {
        return ServerChannelInitializer$.MODULE$.apply(config, channelInboundHandler);
    }

    public static ServerChannelInitializer fromProduct(Product product) {
        return ServerChannelInitializer$.MODULE$.fromProduct(product);
    }

    public static ZLayer<SimpleChannelInboundHandler<HttpObject>, Nothing$, ServerChannelInitializer> layer() {
        return ServerChannelInitializer$.MODULE$.layer();
    }

    public static Object trace() {
        return ServerChannelInitializer$.MODULE$.trace();
    }

    public static ServerChannelInitializer unapply(ServerChannelInitializer serverChannelInitializer) {
        return ServerChannelInitializer$.MODULE$.unapply(serverChannelInitializer);
    }

    public ServerChannelInitializer(Server.Config cfg, ChannelInboundHandler reqHandler) {
        this.cfg = cfg;
        this.reqHandler = reqHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ServerChannelInitializer)) return false;
        ServerChannelInitializer serverChannelInitializer = (ServerChannelInitializer)object;
        Server.Config config = this.cfg();
        Server.Config config2 = serverChannelInitializer.cfg();
        if (config == null) {
            if (config2 != null) {
                return false;
            }
        } else if (!((Object)config).equals(config2)) return false;
        ChannelInboundHandler channelInboundHandler = this.reqHandler();
        ChannelInboundHandler channelInboundHandler2 = serverChannelInitializer.reqHandler();
        if (channelInboundHandler == null) {
            if (channelInboundHandler2 == null) return true;
            return false;
        } else {
            if (!channelInboundHandler.equals(channelInboundHandler2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ServerChannelInitializer;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ServerChannelInitializer";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "cfg";
        }
        if (1 == n2) {
            return "reqHandler";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Server.Config cfg() {
        return this.cfg;
    }

    public ChannelInboundHandler reqHandler() {
        return this.reqHandler;
    }

    @Override
    public void initChannel(Channel channel) {
        Object object;
        ChannelPipeline pipeline = channel.pipeline();
        this.cfg().sslConfig().foreach((Function1 & Serializable)sslCfg -> pipeline.addFirst(package$Names$.MODULE$.SSLHandler(), (ChannelHandler)new ServerSSLDecoder((SSLConfig)sslCfg, this.cfg())));
        this.cfg().idleTimeout().foreach((Function1 & Serializable)timeout -> pipeline.addLast(package$Names$.MODULE$.ReadTimeoutHandler(), (ChannelHandler)new ReadTimeoutHandler(timeout.toMillis(), TimeUnit.MILLISECONDS)));
        pipeline.addLast(package$Names$.MODULE$.HttpRequestDecoder(), (ChannelHandler)new HttpRequestDecoder(this.cfg().maxInitialLineLength(), this.cfg().maxHeaderSize(), 8192, false));
        pipeline.addLast(package$Names$.MODULE$.HttpResponseEncoder(), (ChannelHandler)new HttpResponseEncoder());
        if (this.cfg().requestDecompression().enabled()) {
            pipeline.addLast(package$Names$.MODULE$.HttpRequestDecompression(), (ChannelHandler)new HttpContentDecompressor(this.cfg().requestDecompression().strict()));
        }
        this.cfg().responseCompression().foreach((Function1 & Serializable)ops -> pipeline.addLast(package$Names$.MODULE$.HttpResponseCompression(), (ChannelHandler)new HttpContentCompressor(ops.contentThreshold(), (CompressionOptions[])((DeflateOptions[])Arrays$.MODULE$.seqToArray((Seq)ops.options().map((Function1 & Serializable)compressionOptions -> Conversions$.MODULE$.compressionOptionsToNetty((Server.Config.CompressionOptions)compressionOptions)), DeflateOptions.class)))));
        Server.RequestStreaming requestStreaming = this.cfg().requestStreaming();
        if (Server$RequestStreaming$Enabled$.MODULE$.equals(requestStreaming)) {
            object = BoxedUnit.UNIT;
        } else if (requestStreaming instanceof Server.RequestStreaming.Disabled) {
            int n;
            Server.RequestStreaming.Disabled disabled = Server$RequestStreaming$Disabled$.MODULE$.unapply((Server.RequestStreaming.Disabled)requestStreaming);
            int maximumContentLength = n = disabled._1();
            object = pipeline.addLast(package$Names$.MODULE$.HttpObjectAggregator(), (ChannelHandler)new HttpObjectAggregator(maximumContentLength));
        } else {
            throw new MatchError((Object)requestStreaming);
        }
        if (this.cfg().acceptContinue()) {
            pipeline.addLast(package$Names$.MODULE$.HttpServerExpectContinue(), (ChannelHandler)new HttpServerExpectContinueHandler());
        }
        if (this.cfg().keepAlive()) {
            pipeline.addLast(package$Names$.MODULE$.HttpKeepAliveHandler(), (ChannelHandler)new HttpServerKeepAliveHandler());
        }
        pipeline.addLast(package$Names$.MODULE$.HttpServerFlushConsolidation(), (ChannelHandler)new FlushConsolidationHandler());
        pipeline.addLast(package$Names$.MODULE$.HttpRequestHandler(), (ChannelHandler)this.reqHandler());
    }

    public ServerChannelInitializer copy(Server.Config cfg, ChannelInboundHandler reqHandler) {
        return new ServerChannelInitializer(cfg, reqHandler);
    }

    public Server.Config copy$default$1() {
        return this.cfg();
    }

    public ChannelInboundHandler copy$default$2() {
        return this.reqHandler();
    }

    public Server.Config _1() {
        return this.cfg();
    }

    public ChannelInboundHandler _2() {
        return this.reqHandler();
    }
}

