/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import zio.Chunk;
import zio.Random$;
import zio.Scope;
import zio.Scope$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZKeyedPool;
import zio.ZKeyedPool$;
import zio.http.ClientSSLConfig;
import zio.http.ConnectionPoolConfig;
import zio.http.ConnectionPoolConfig$Disabled$;
import zio.http.ConnectionPoolConfig$Dynamic$;
import zio.http.ConnectionPoolConfig$DynamicPerHost$;
import zio.http.ConnectionPoolConfig$Fixed$;
import zio.http.ConnectionPoolConfig$FixedPerHost$;
import zio.http.Decompression;
import zio.http.DnsResolver;
import zio.http.Proxy;
import zio.http.URL;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyProxy$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.client.ClientSSLConverter$;
import zio.http.netty.client.NettyClientDriver;
import zio.http.netty.client.NettyConnectionPool;
import zio.http.netty.client.NettyConnectionPool$BootstrapSyntax$;
import zio.http.netty.client.NettyConnectionPool$PoolKey$;
import zio.http.netty.package$Names$;
import zio.http.shaded.netty.bootstrap.AbstractBootstrap;
import zio.http.shaded.netty.bootstrap.Bootstrap;
import zio.http.shaded.netty.channel.Channel;
import zio.http.shaded.netty.channel.ChannelFactory;
import zio.http.shaded.netty.channel.ChannelFuture;
import zio.http.shaded.netty.channel.ChannelHandler;
import zio.http.shaded.netty.channel.ChannelInitializer;
import zio.http.shaded.netty.channel.ChannelOption;
import zio.http.shaded.netty.channel.ChannelPipeline;
import zio.http.shaded.netty.channel.EventLoopGroup;
import zio.http.shaded.netty.handler.codec.http.HttpClientCodec;
import zio.http.shaded.netty.handler.codec.http.HttpContentDecompressor;
import zio.http.shaded.netty.handler.proxy.HttpProxyHandler;
import zio.http.shaded.netty.handler.timeout.ReadTimeoutHandler;
import zio.http.shaded.netty.util.concurrent.Future;
import zio.package;

public final class NettyConnectionPool$
implements Serializable {
    public static final NettyConnectionPool$PoolKey$ PoolKey;
    public static final NettyConnectionPool$BootstrapSyntax$ BootstrapSyntax;
    public static final NettyConnectionPool$ MODULE$;

    private NettyConnectionPool$() {
    }

    static {
        MODULE$ = new NettyConnectionPool$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettyConnectionPool$.class);
    }

    public ZIO<Scope, Throwable, Channel> createChannel(ChannelFactory<Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime, URL.Location.Absolute location, Option<Proxy> proxy, ClientSSLConfig sslOptions, int maxInitialLineLength, int maxHeaderSize, Decompression decompression, Option<Duration> idleTimeout, Option<Duration> connectionTimeout, Option<InetSocketAddress> localAddress, DnsResolver dnsResolver, Object trace) {
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(nettyRuntime, location, proxy, sslOptions, maxInitialLineLength, maxHeaderSize, decompression, idleTimeout, trace){
            private final NettyRuntime nettyRuntime$1;
            private final URL.Location.Absolute location$1;
            private final Option proxy$1;
            private final ClientSSLConfig sslOptions$1;
            private final int maxInitialLineLength$1;
            private final int maxHeaderSize$1;
            private final Decompression decompression$1;
            private final Option idleTimeout$1;
            private final Object trace$1;
            {
                this.nettyRuntime$1 = nettyRuntime$2;
                this.location$1 = location$6;
                this.proxy$1 = proxy$3;
                this.sslOptions$1 = sslOptions$3;
                this.maxInitialLineLength$1 = maxInitialLineLength$3;
                this.maxHeaderSize$1 = maxHeaderSize$3;
                this.decompression$1 = decompression$3;
                this.idleTimeout$1 = idleTimeout$3;
                this.trace$1 = trace$26;
            }

            public void initChannel(Channel ch) {
                Object object;
                ChannelPipeline pipeline = ch.pipeline();
                Option option = this.proxy$1;
                if (option instanceof Some) {
                    Proxy proxy = (Proxy)((Some)option).value();
                    object = pipeline.addLast(package$Names$.MODULE$.ProxyHandler(), (ChannelHandler)NettyProxy$.MODULE$.fromProxy(proxy).encode().getOrElse(this::initChannel$$anonfun$1));
                } else if (None$.MODULE$.equals(option)) {
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.location$1.scheme().isSecure().getOrElse(NettyConnectionPool$::zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$2))) {
                    pipeline.addLast(package$Names$.MODULE$.SSLHandler(), (ChannelHandler)ClientSSLConverter$.MODULE$.toNettySSLContext(this.sslOptions$1).newHandler(ch.alloc(), this.location$1.host(), this.location$1.port()));
                }
                this.idleTimeout$1.foreach(arg_0 -> NettyConnectionPool$.zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$3(pipeline, arg_0));
                pipeline.addLast(package$Names$.MODULE$.ClientReadTimeoutErrorHandler(), (ChannelHandler)new NettyConnectionPool.ReadTimeoutErrorHandler(this.nettyRuntime$1, this.trace$1));
                pipeline.addLast(package$Names$.MODULE$.HttpClientCodec(), (ChannelHandler)new HttpClientCodec(this.maxInitialLineLength$1, this.maxHeaderSize$1, 8192, true));
                if (this.decompression$1.enabled()) {
                    pipeline.addLast(package$Names$.MODULE$.HttpRequestDecompression(), (ChannelHandler)new HttpContentDecompressor(this.decompression$1.strict()));
                }
            }

            private final HttpProxyHandler initChannel$$anonfun$1() {
                return new HttpProxyHandler(new InetSocketAddress(this.location$1.host(), this.location$1.port()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{initChannel$$anonfun$1(), zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$2(), zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$3(zio.http.shaded.netty.channel.ChannelPipeline java.time.Duration )}, serializedLambda);
            }
        };
        return dnsResolver.resolve(location.host(), trace).flatMap((Function1 & Serializable)resolvedHosts -> Random$.MODULE$.nextIntBounded(() -> this.createChannel$$anonfun$1$$anonfun$1(resolvedHosts), trace).map((Function1 & Serializable)pickedHost -> this.createChannel$$anonfun$1$$anonfun$2((Chunk)resolvedHosts, BoxesRunTime.unboxToInt((Object)pickedHost)), trace).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int pickedHost = BoxesRunTime.unboxToInt((Object)tuple2._1());
                InetAddress host = (InetAddress)tuple2._2();
                return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> {
                    Bootstrap bootstrap;
                    Bootstrap bootstrap2 = (Bootstrap)NettyConnectionPool$BootstrapSyntax$.MODULE$.withOption$extension(this.BootstrapSyntax(((Bootstrap)((AbstractBootstrap)new Bootstrap().channelFactory(channelFactory)).group(eventLoopGroup)).remoteAddress(new InetSocketAddress(host, location.port()))), ChannelOption.CONNECT_TIMEOUT_MILLIS, connectionTimeout.map((Function1 & Serializable)_$1 -> Predef$.MODULE$.int2Integer((int)_$1.toMillis()))).handler(initializer);
                    Option option = localAddress;
                    if (option instanceof Some) {
                        InetSocketAddress addr = (InetSocketAddress)((Some)option).value();
                        bootstrap = (Bootstrap)bootstrap2.localAddress(addr);
                    } else {
                        bootstrap = bootstrap2;
                    }
                    return bootstrap.connect();
                }, trace).flatMap((Function1 & Serializable)channelFuture -> NettyFutureExecutor$.MODULE$.executed(() -> this.createChannel$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1(channelFuture), trace).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$2 -> channelFuture.channel(), trace).flatMap((Function1 & Serializable)ch -> Scope$.MODULE$.addFinalizer(() -> this.createChannel$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(trace, ch), trace).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return ch;
                    }, trace), trace);
                }, trace), trace);
            }
            throw new MatchError((Object)tuple2);
        }, trace), trace);
    }

    public ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> fromConfig(ConnectionPoolConfig config, Object trace) {
        ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> zIO;
        ConnectionPoolConfig connectionPoolConfig = config;
        if (ConnectionPoolConfig$Disabled$.MODULE$.equals(connectionPoolConfig)) {
            zIO = this.createDisabled(trace);
        } else if (connectionPoolConfig instanceof ConnectionPoolConfig.Fixed) {
            int n;
            ConnectionPoolConfig.Fixed fixed = ConnectionPoolConfig$Fixed$.MODULE$.unapply((ConnectionPoolConfig.Fixed)connectionPoolConfig);
            int size = n = fixed._1();
            zIO = this.createFixed(size, trace);
        } else if (connectionPoolConfig instanceof ConnectionPoolConfig.FixedPerHost) {
            ConnectionPoolConfig.FixedPerHost fixedPerHost = ConnectionPoolConfig$FixedPerHost$.MODULE$.unapply((ConnectionPoolConfig.FixedPerHost)connectionPoolConfig);
            Map<URL.Location.Absolute, ConnectionPoolConfig.Fixed> map = fixedPerHost._1();
            ConnectionPoolConfig.Fixed fixed = fixedPerHost._2();
            Map<URL.Location.Absolute, ConnectionPoolConfig.Fixed> sizes = map;
            ConnectionPoolConfig.Fixed fixed2 = fixed;
            zIO = this.createFixedPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)location -> ((ConnectionPoolConfig.Fixed)sizes.getOrElse(location, () -> this.fromConfig$$anonfun$1$$anonfun$1(fixed2))).size(), trace);
        } else if (connectionPoolConfig instanceof ConnectionPoolConfig.Dynamic) {
            ConnectionPoolConfig.Dynamic dynamic = ConnectionPoolConfig$Dynamic$.MODULE$.unapply((ConnectionPoolConfig.Dynamic)connectionPoolConfig);
            int n = dynamic._1();
            int n2 = dynamic._2();
            Duration duration = dynamic._3();
            int minimum = n;
            int maximum = n2;
            Duration ttl = duration;
            zIO = this.createDynamic(minimum, maximum, ttl, trace);
        } else if (connectionPoolConfig instanceof ConnectionPoolConfig.DynamicPerHost) {
            ConnectionPoolConfig.DynamicPerHost dynamicPerHost = ConnectionPoolConfig$DynamicPerHost$.MODULE$.unapply((ConnectionPoolConfig.DynamicPerHost)connectionPoolConfig);
            Map<URL.Location.Absolute, ConnectionPoolConfig.Dynamic> map = dynamicPerHost._1();
            ConnectionPoolConfig.Dynamic dynamic = dynamicPerHost._2();
            Map<URL.Location.Absolute, ConnectionPoolConfig.Dynamic> configs = map;
            ConnectionPoolConfig.Dynamic dynamic2 = dynamic;
            zIO = this.createDynamicPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)location -> ((ConnectionPoolConfig.Dynamic)configs.getOrElse(location, () -> this.fromConfig$$anonfun$2$$anonfun$1(dynamic2))).minimum(), (Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)location -> ((ConnectionPoolConfig.Dynamic)configs.getOrElse(location, () -> this.fromConfig$$anonfun$3$$anonfun$1(dynamic2))).maximum(), (Function1<URL.Location.Absolute, Duration>)(Function1 & Serializable)location -> ((ConnectionPoolConfig.Dynamic)configs.getOrElse(location, () -> this.fromConfig$$anonfun$4$$anonfun$1(dynamic2))).ttl(), trace);
        } else {
            throw new MatchError((Object)connectionPoolConfig);
        }
        return zIO.map((Function1 & Serializable)pool -> pool, trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDisabled(Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(940870809, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(499331248, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable)dnsResolver -> new NettyConnectionPool.NoNettyConnectionPool(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), (DnsResolver)dnsResolver), trace), trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createFixed(int size, Object trace) {
        return this.createFixedPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)_$2 -> size, trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createFixedPerHost(Function1<URL.Location.Absolute, Object> size, Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(940870809, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(499331248, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable)dnsResolver -> {
            Function1 & Serializable poolFn = (Function1 & Serializable)key -> this.createChannel(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), key.location(), key.proxy(), key.sslOptions(), key.maxInitialLineLength(), key.maxHeaderSize(), key.decompression(), key.idleTimeout(), key.connectionTimeout(), (Option<InetSocketAddress>)None$.MODULE$, (DnsResolver)dnsResolver, trace).uninterruptible(trace);
            Function1 & Serializable _size = (Function1 & Serializable)key -> BoxesRunTime.unboxToInt((Object)size.apply((Object)key.location()));
            return Tuple3$.MODULE$.apply(dnsResolver, (Object)poolFn, (Object)_size);
        }, trace).flatMap((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                DnsResolver dnsResolver = (DnsResolver)tuple3._1();
                Function1 poolFn = (Function1)tuple3._2();
                Function1 _size = (Function1)tuple3._3();
                return ZKeyedPool$.MODULE$.make(poolFn, _size, Tag$.MODULE$.apply(Scope.class, LightTypeTag$.MODULE$.parse(1294249275, "\u0004\u0000\u0001\tzio.Scope\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\tzio.Scope\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)), trace).map((Function1 & Serializable)keyedPool -> new NettyConnectionPool.ZioNettyConnectionPool((ZKeyedPool<Throwable, NettyConnectionPool.PoolKey, Channel>)keyedPool, (Function1<NettyConnectionPool.PoolKey, Object>)_size), trace);
            }
            throw new MatchError((Object)tuple3);
        }, trace), trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDynamic(int min, int max, Duration ttl, Object trace) {
        return this.createDynamicPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)_$3 -> min, (Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)_$4 -> max, (Function1<URL.Location.Absolute, Duration>)(Function1 & Serializable)_$5 -> ttl, trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDynamicPerHost(Function1<URL.Location.Absolute, Object> min, Function1<URL.Location.Absolute, Object> max, Function1<URL.Location.Absolute, Duration> ttl, Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(940870809, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(499331248, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable)dnsResolver -> {
            Function1 & Serializable poolFn = (Function1 & Serializable)key -> this.createChannel(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), key.location(), key.proxy(), key.sslOptions(), key.maxInitialLineLength(), key.maxHeaderSize(), key.decompression(), key.idleTimeout(), key.connectionTimeout(), (Option<InetSocketAddress>)None$.MODULE$, (DnsResolver)dnsResolver, trace).uninterruptible(trace);
            return Tuple2$.MODULE$.apply(dnsResolver, (Object)poolFn);
        }, trace).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                DnsResolver dnsResolver = (DnsResolver)tuple2._1();
                Function1 poolFn = (Function1)tuple2._2();
                return ZKeyedPool$.MODULE$.make(poolFn, (Function1 & Serializable)key -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)min.apply((Object)key.location()))), BoxesRunTime.unboxToInt((Object)max.apply((Object)key.location()))), (Function1 & Serializable)key -> (Duration)ttl.apply((Object)key.location()), Tag$.MODULE$.apply(Scope.class, LightTypeTag$.MODULE$.parse(1294249275, "\u0004\u0000\u0001\tzio.Scope\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\tzio.Scope\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)), trace).map((Function1 & Serializable)keyedPool -> new NettyConnectionPool.ZioNettyConnectionPool((ZKeyedPool<Throwable, NettyConnectionPool.PoolKey, Channel>)keyedPool, (Function1<NettyConnectionPool.PoolKey, Object>)(Function1 & Serializable)key -> BoxesRunTime.unboxToInt((Object)max.apply((Object)key.location()))), trace);
            }
            throw new MatchError((Object)tuple2);
        }, trace), trace);
    }

    public final Bootstrap BootstrapSyntax(Bootstrap bootstrap) {
        return bootstrap;
    }

    public static final boolean zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$2() {
        return false;
    }

    public static final /* synthetic */ ChannelPipeline zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$3(ChannelPipeline pipeline$1, Duration timeout) {
        return pipeline$1.addLast(package$Names$.MODULE$.ReadTimeoutHandler(), (ChannelHandler)new ReadTimeoutHandler(timeout.toMillis(), TimeUnit.MILLISECONDS));
    }

    private final int createChannel$$anonfun$1$$anonfun$1(Chunk resolvedHosts$1) {
        return resolvedHosts$1.size();
    }

    private final /* synthetic */ Tuple2 createChannel$$anonfun$1$$anonfun$2(Chunk resolvedHosts$2, int pickedHost) {
        InetAddress host = (InetAddress)resolvedHosts$2.apply(pickedHost);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)pickedHost), (Object)host);
    }

    private final Future createChannel$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1(ChannelFuture channelFuture$1) {
        return channelFuture$1;
    }

    private final Future createChannel$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(Channel ch$2) {
        return ch$2.close();
    }

    private final boolean createChannel$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2(Channel ch$3) {
        return ch$3.isOpen();
    }

    private final ZIO createChannel$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Object trace$6, Channel ch$1) {
        return NettyFutureExecutor$.MODULE$.executed(() -> this.createChannel$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(ch$1), trace$6).when(() -> this.createChannel$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2(ch$1), trace$6).ignoreLogged(trace$6);
    }

    private final ConnectionPoolConfig.Fixed fromConfig$$anonfun$1$$anonfun$1(ConnectionPoolConfig.Fixed default$2) {
        return default$2;
    }

    private final ConnectionPoolConfig.Dynamic fromConfig$$anonfun$2$$anonfun$1(ConnectionPoolConfig.Dynamic default$4) {
        return default$4;
    }

    private final ConnectionPoolConfig.Dynamic fromConfig$$anonfun$3$$anonfun$1(ConnectionPoolConfig.Dynamic default$6) {
        return default$6;
    }

    private final ConnectionPoolConfig.Dynamic fromConfig$$anonfun$4$$anonfun$1(ConnectionPoolConfig.Dynamic default$8) {
        return default$8;
    }
}

