/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import zio.Chunk;
import zio.Chunk$;
import zio.Promise;
import zio.Queue;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.ChannelEvent;
import zio.http.ChannelEvent$;
import zio.http.ChannelEvent$UserEvent$HandshakeComplete$;
import zio.http.ChannelEvent$UserEvent$HandshakeTimeout$;
import zio.http.WebSocketFrame;
import zio.http.WebSocketFrame$Binary$;
import zio.http.WebSocketFrame$Close$;
import zio.http.WebSocketFrame$Continuation$;
import zio.http.WebSocketFrame$Ping$;
import zio.http.WebSocketFrame$Pong$;
import zio.http.WebSocketFrame$Text$;
import zio.http.internal.ChannelState;
import zio.http.internal.ChannelState$Invalid$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.NettyRuntime$;
import zio.http.shaded.netty.buffer.ByteBufUtil;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.channel.SimpleChannelInboundHandler;
import zio.http.shaded.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import zio.http.shaded.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import zio.http.shaded.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import zio.http.shaded.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import zio.http.shaded.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import zio.http.shaded.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;

public final class WebSocketAppHandler
extends SimpleChannelInboundHandler<zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketFrame> {
    private final NettyRuntime zExec;
    private final Queue<ChannelEvent<WebSocketFrame>> queue;
    private final Option<Promise<Throwable, ChannelState>> onComplete;
    private final Object trace;
    private final Unsafe unsafeClass;

    public WebSocketAppHandler(NettyRuntime zExec, Queue<ChannelEvent<WebSocketFrame>> queue, Option<Promise<Throwable, ChannelState>> onComplete, Object trace) {
        this.zExec = zExec;
        this.queue = queue;
        this.onComplete = onComplete;
        this.trace = trace;
        this.unsafeClass = Unsafe$.MODULE$.unsafe();
    }

    private void dispatch(ChannelHandlerContext ctx, ChannelEvent<zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketFrame> event, boolean close) {
        this.zExec.runUninterruptible(ctx, NettyRuntime$.MODULE$.noopEnsuring(), (ZIO<Object, Throwable, Object>)this.queue.offer(event.map((Function1 & Serializable)jFrame -> this.frameFromNetty((zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketFrame)jFrame)), this.trace).$times$greater(() -> this.dispatch$$anonfun$2(close), this.trace), this.unsafeClass, this.trace);
    }

    private boolean dispatch$default$3() {
        return false;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketFrame msg) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.read(msg), this.dispatch$default$3());
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.registered(), this.dispatch$default$3());
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.unregistered(), true);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.exceptionCaught(cause), this.dispatch$default$3());
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            Promise promise = (Promise)((Some)option).value();
            promise.fail((Object)cause, this.trace);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) {
        block11: {
            block8: {
                Object object;
                WebSocketClientProtocolHandler.ClientHandshakeStateEvent clientHandshakeStateEvent;
                block10: {
                    Object object2;
                    block9: {
                        Object object3;
                        WebSocketServerProtocolHandler.ServerHandshakeStateEvent serverHandshakeStateEvent;
                        block7: {
                            block6: {
                                block4: {
                                    Object object4;
                                    WebSocketClientProtocolHandler.ClientHandshakeStateEvent clientHandshakeStateEvent2;
                                    block5: {
                                        object2 = msg;
                                        if (object2 instanceof WebSocketServerProtocolHandler.HandshakeComplete) break block4;
                                        clientHandshakeStateEvent2 = WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE;
                                        object4 = object2;
                                        if (clientHandshakeStateEvent2 != null) break block5;
                                        if (object4 == null) break block4;
                                        break block6;
                                    }
                                    if (!((Object)((Object)clientHandshakeStateEvent2)).equals(object4)) break block6;
                                }
                                this.dispatch(ctx, ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeComplete$.MODULE$), this.dispatch$default$3());
                                return;
                            }
                            serverHandshakeStateEvent = WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT;
                            object3 = object2;
                            if (serverHandshakeStateEvent != null) break block7;
                            if (object3 == null) break block8;
                            break block9;
                        }
                        if (((Object)((Object)serverHandshakeStateEvent)).equals(object3)) break block8;
                    }
                    clientHandshakeStateEvent = WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT;
                    object = object2;
                    if (clientHandshakeStateEvent != null) break block10;
                    if (object == null) break block8;
                    break block11;
                }
                if (!((Object)((Object)clientHandshakeStateEvent)).equals(object)) break block11;
            }
            this.dispatch(ctx, ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeTimeout$.MODULE$), this.dispatch$default$3());
            return;
        }
        super.userEventTriggered(ctx, msg);
    }

    private WebSocketFrame frameFromNetty(zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketFrame jFrame) {
        WebSocketFrame webSocketFrame;
        zio.http.shaded.netty.handler.codec.http.websocketx.WebSocketFrame webSocketFrame2 = jFrame;
        if (webSocketFrame2 instanceof PingWebSocketFrame) {
            webSocketFrame = WebSocketFrame$Ping$.MODULE$;
        } else if (webSocketFrame2 instanceof PongWebSocketFrame) {
            webSocketFrame = WebSocketFrame$Pong$.MODULE$;
        } else if (webSocketFrame2 instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame m = (BinaryWebSocketFrame)webSocketFrame2;
            webSocketFrame = WebSocketFrame$Binary$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes(m.content())), m.isFinalFragment());
        } else if (webSocketFrame2 instanceof TextWebSocketFrame) {
            TextWebSocketFrame m = (TextWebSocketFrame)webSocketFrame2;
            webSocketFrame = WebSocketFrame$Text$.MODULE$.apply(m.text(), m.isFinalFragment());
        } else if (webSocketFrame2 instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame m = (CloseWebSocketFrame)webSocketFrame2;
            webSocketFrame = WebSocketFrame$Close$.MODULE$.apply(m.statusCode(), (Option<String>)Option$.MODULE$.apply((Object)m.reasonText()));
        } else if (webSocketFrame2 instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame m = (ContinuationWebSocketFrame)webSocketFrame2;
            webSocketFrame = WebSocketFrame$Continuation$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes(m.content())), m.isFinalFragment());
        } else {
            webSocketFrame = null;
        }
        return webSocketFrame;
    }

    private final ZIO dispatch$$anonfun$2(boolean close$1) {
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            Promise promise = (Promise)((Some)option).value();
            if (close$1) {
                return promise.succeed((Object)ChannelState$Invalid$.MODULE$, this.trace);
            }
        }
        return ZIO$.MODULE$.unit();
    }
}

