/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import zio.Cause;
import zio.Exit;
import zio.Fiber;
import zio.Runtime;
import zio.Unsafe;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.netty.NettyRuntime$;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.util.concurrent.Future;
import zio.http.shaded.netty.util.concurrent.GenericFutureListener;

public final class NettyRuntime {
    private final Runtime.UnsafeAPI rtm;

    public static ZLayer<Object, Nothing$, NettyRuntime> live() {
        return NettyRuntime$.MODULE$.live();
    }

    public static Function0<BoxedUnit> noopEnsuring() {
        return NettyRuntime$.MODULE$.noopEnsuring();
    }

    public NettyRuntime(Runtime<Object> zioRuntime) {
        this.rtm = zioRuntime.unsafe();
    }

    public void run(ChannelHandlerContext ctx, Function0<BoxedUnit> ensured, boolean interruptOnClose, ZIO<Object, Throwable, Object> program, Unsafe unsafe, Object trace) {
        GenericFutureListener<Future<? super Void>> genericFutureListener;
        Fiber.Runtime fiber = this.rtm.fork(program, trace, unsafe);
        if (interruptOnClose) {
            GenericFutureListener<Future<? super Void>> close0 = this.closeListener(fiber, unsafe, trace);
            ctx.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)close0);
            genericFutureListener = close0;
        } else {
            genericFutureListener = null;
        }
        GenericFutureListener<Future<? super Void>> close = genericFutureListener;
        fiber.unsafe().addObserver((Function1)(JProcedure1 & Serializable)x$1 -> {
            Exit exit = x$1;
            if (exit instanceof Exit.Success) {
                Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit);
                Object object = success._1();
                NettyRuntime.removeListener$1(ctx, close);
                ensured.apply$mcV$sp();
                return;
            }
            if (exit instanceof Exit.Failure) {
                Cause cause;
                Exit.Failure failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit);
                Cause cause2 = cause = failure._1();
                NettyRuntime.removeListener$1(ctx, close);
                NettyRuntime.onFailure$1(cause2, ctx);
                ensured.apply$mcV$sp();
                return;
            }
            throw new MatchError((Object)exit);
        }, unsafe);
    }

    public boolean run$default$3() {
        return true;
    }

    public void runUninterruptible(ChannelHandlerContext ctx, Function0<BoxedUnit> ensured, ZIO<Object, Throwable, Object> program, Unsafe unsafe, Object trace) {
        this.run(ctx, ensured, false, program, unsafe, trace);
    }

    public <A> A unsafeRunSync(ZIO<Object, Throwable, A> program, Unsafe unsafe, Object trace) throws Throwable {
        return (A)this.rtm.run(program, trace, unsafe).getOrThrowFiberFailure(unsafe);
    }

    private GenericFutureListener<Future<? super Void>> closeListener(Fiber.Runtime<?, ?> fiber, Unsafe unsafe, Object trace) {
        return _$1 -> this.unsafeRunSync(ZIO$.MODULE$.fiberIdWith((Function1 & Serializable)fiberId -> fiber.interruptAsFork(fiberId, trace), trace), unsafe, trace);
    }

    private static final Option onFailure$1$$anonfun$1(Cause cause$1) {
        return cause$1.dieOption();
    }

    private static final void onFailure$1(Cause cause, ChannelHandlerContext ctx) {
        Object object;
        Option option = cause.failureOption().orElse(() -> NettyRuntime.onFailure$1$$anonfun$1(cause));
        if (None$.MODULE$.equals(option)) {
            object = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Throwable error = (Throwable)((Some)option).value();
            object = ctx.fireExceptionCaught(error);
        } else {
            throw new MatchError((Object)option);
        }
        if (ctx.channel().isOpen()) {
            ctx.close();
            return;
        }
    }

    private static final void removeListener$1(ChannelHandlerContext ctx$1, GenericFutureListener close) {
        if (close != null) {
            ctx$1.channel().closeFuture().removeListener(close);
            return;
        }
    }
}

