/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import java.io.Serializable;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import zio.Unsafe;
import zio.http.Body;
import zio.http.Response;
import zio.http.Status;
import zio.http.netty.CachedDateHeader;
import zio.http.netty.CachedDateHeader$;
import zio.http.netty.model.Conversions$;
import zio.http.shaded.netty.buffer.ByteBuf;
import zio.http.shaded.netty.buffer.Unpooled;
import zio.http.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import zio.http.shaded.netty.handler.codec.http.DefaultHttpResponse;
import zio.http.shaded.netty.handler.codec.http.EmptyHttpHeaders;
import zio.http.shaded.netty.handler.codec.http.FullHttpResponse;
import zio.http.shaded.netty.handler.codec.http.HttpHeaderNames;
import zio.http.shaded.netty.handler.codec.http.HttpHeaderValues;
import zio.http.shaded.netty.handler.codec.http.HttpHeaders;
import zio.http.shaded.netty.handler.codec.http.HttpResponse;
import zio.http.shaded.netty.handler.codec.http.HttpResponseStatus;
import zio.http.shaded.netty.handler.codec.http.HttpVersion;

public final class NettyResponseEncoder$
implements Serializable {
    private static final CachedDateHeader dateHeaderCache;
    public static final NettyResponseEncoder$ MODULE$;

    private NettyResponseEncoder$() {
    }

    static {
        MODULE$ = new NettyResponseEncoder$();
        dateHeaderCache = CachedDateHeader$.MODULE$.default();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettyResponseEncoder$.class);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public HttpResponse encode(Response response, Unsafe unsafe) {
        body = response.body();
        if (body.isComplete()) {
            if (!(body instanceof Body.UnsafeBytes)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"expected completed body to implement UnsafeBytes");
            }
            return this.fastEncode(response, ((Body.UnsafeBytes)body).unsafeAsArray(unsafe), unsafe);
        }
        status = response.status();
        jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        jStatus = Conversions$.MODULE$.statusToNetty(status);
        this.maybeAddDateHeader(jHeaders, status);
        var7_7 = response.body().knownContentLength();
        if (!(var7_7 instanceof Some)) ** GOTO lbl-1000
        contentLength = BoxesRunTime.unboxToLong((Object)((Some)var7_7).value());
        if (!jHeaders.contains(HttpHeaderNames.CONTENT_LENGTH)) {
            v0 /* !! */  = jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToLong((long)contentLength));
        } else lbl-1000:
        // 2 sources

        {
            v0 /* !! */  = BoxedUnit.UNIT;
        }
        hasContentLength = jHeaders.contains(HttpHeaderNames.CONTENT_LENGTH);
        if (!hasContentLength) {
            jHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        return new DefaultHttpResponse(HttpVersion.HTTP_1_1, jStatus, jHeaders);
    }

    public FullHttpResponse fastEncode(Response response, byte[] bytes, Unsafe unsafe) {
        if (response.encoded() == null) {
            response.encoded_$eq(this.doEncode(response, bytes));
        }
        return (FullHttpResponse)response.encoded();
    }

    private FullHttpResponse doEncode(Response response, byte[] bytes) {
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        boolean hasContentLength = jHeaders.contains(HttpHeaderNames.CONTENT_LENGTH);
        Status status = response.status();
        this.maybeAddDateHeader(jHeaders, status);
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(response.status());
        ByteBuf jContent = Unpooled.wrappedBuffer(bytes);
        if (!hasContentLength) {
            jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)jContent.readableBytes()));
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, jStatus, jContent, jHeaders, EmptyHttpHeaders.INSTANCE);
    }

    private void maybeAddDateHeader(HttpHeaders headers, Status status) {
        if (status.isInformational() || status.isServerError() || headers.contains(HttpHeaderNames.DATE)) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.DATE, (Object)dateHeaderCache.get());
    }
}

