/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$ArrayBody$;
import zio.http.Body$ChunkBody$;
import zio.http.Body$EmptyBody$;
import zio.http.Body$StreamBody$;
import zio.http.Boundary;
import zio.http.MediaType;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$AsciiStringBody$;
import zio.http.netty.NettyBody$AsyncBody$;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.shaded.netty.buffer.Unpooled;
import zio.http.shaded.netty.channel.ChannelFuture;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.channel.DefaultFileRegion;
import zio.http.shaded.netty.handler.codec.http.DefaultHttpContent;
import zio.http.shaded.netty.handler.codec.http.LastHttpContent;
import zio.http.shaded.netty.util.AsciiString;
import zio.http.shaded.netty.util.concurrent.Future;
import zio.stream.ZStream;

public final class NettyBodyWriter$
implements Serializable {
    public static final NettyBodyWriter$ MODULE$ = new NettyBodyWriter$();

    private NettyBodyWriter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettyBodyWriter$.class);
    }

    public Option<ZIO<Object, Throwable, BoxedUnit>> writeAndFlush(Body body, Option<Object> contentLength, ChannelHandlerContext ctx, Object trace) {
        Body body2 = body;
        if (body2 instanceof NettyBody.ByteBufBody) {
            NettyBody.ByteBufBody body3 = (NettyBody.ByteBufBody)body2;
            ctx.write(new DefaultHttpContent(body3.byteBuf()));
            ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            return None$.MODULE$;
        }
        if (body2 instanceof Body.FileBody) {
            Body.FileBody body4 = (Body.FileBody)body2;
            File file = body4.file();
            ctx.write(new DefaultFileRegion(file, 0L, body4.fileSize()));
            ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            return None$.MODULE$;
        }
        if (body2 instanceof NettyBody.AsyncBody) {
            NettyBody.AsyncBody asyncBody = NettyBody$AsyncBody$.MODULE$.unapply((NettyBody.AsyncBody)body2);
            Function1<NettyBody.UnsafeAsync, BoxedUnit> function1 = asyncBody._1();
            Option<Object> option = asyncBody._2();
            Option<MediaType> option2 = asyncBody._3();
            Option<Boundary> option3 = asyncBody._4();
            Function1<NettyBody.UnsafeAsync, BoxedUnit> async = function1;
            async.apply((Object)new NettyBody.UnsafeAsync(ctx, this){
                private final ChannelHandlerContext ctx$2;
                {
                    this.ctx$2 = ctx$13;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                }

                public void apply(Chunk message, boolean isLast) {
                    byte[] byArray;
                    Chunk chunk = message;
                    if (chunk instanceof Chunk.ByteArray) {
                        Chunk.ByteArray b = (Chunk.ByteArray)chunk;
                        byArray = b.array();
                    } else {
                        Chunk other = chunk;
                        byArray = (byte[])other.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
                    }
                    byte[] arr = byArray;
                    NettyBodyWriter$.MODULE$.zio$http$netty$NettyBodyWriter$$$_$writeArray$1(this.ctx$2, arr, isLast);
                }

                public void fail(Throwable cause) {
                    this.ctx$2.fireExceptionCaught(cause);
                }
            });
            return None$.MODULE$;
        }
        if (body2 instanceof NettyBody.AsciiStringBody) {
            NettyBody.AsciiStringBody asciiStringBody = NettyBody$AsciiStringBody$.MODULE$.unapply((NettyBody.AsciiStringBody)body2);
            AsciiString asciiString = asciiStringBody._1();
            Option<MediaType> option = asciiStringBody._2();
            Option<Boundary> option4 = asciiStringBody._3();
            AsciiString asciiString2 = asciiString;
            this.zio$http$netty$NettyBodyWriter$$$_$writeArray$1(ctx, asciiString2.array(), true);
            return None$.MODULE$;
        }
        if (body2 instanceof Body.StreamBody) {
            ZIO zIO;
            Body.StreamBody streamBody = Body$StreamBody$.MODULE$.unapply((Body.StreamBody)body2);
            ZStream<Object, Throwable, Object> zStream = streamBody._1();
            Option<Object> option = streamBody._2();
            Option<MediaType> option5 = streamBody._3();
            Option<Boundary> option6 = streamBody._4();
            ZStream<Object, Throwable, Object> stream = zStream;
            Option option7 = contentLength.orElse(() -> this.writeAndFlush$$anonfun$1(body));
            if (option7 instanceof Some) {
                long length = BoxesRunTime.unboxToLong((Object)((Some)option7).value());
                zIO = stream.chunks(trace).runFoldZIO(() -> this.writeAndFlush$$anonfun$2(length), (Function2 & Serializable)(remaining, bytes) -> this.writeAndFlush$$anonfun$3(ctx, trace, BoxesRunTime.unboxToLong((Object)remaining), (Chunk)bytes), trace).flatMap((Function1 & Serializable)x$1 -> this.writeAndFlush$$anonfun$4(ctx, trace, length, BoxesRunTime.unboxToLong((Object)x$1)), trace);
            } else if (None$.MODULE$.equals(option7)) {
                zIO = stream.chunks(trace).mapZIO((Function1 & Serializable)bytes -> NettyFutureExecutor$.MODULE$.executed(() -> this.writeAndFlush$$anonfun$5$$anonfun$1(ctx, bytes), trace), trace).runDrain(trace).zipRight(() -> this.writeAndFlush$$anonfun$6(ctx, trace), trace);
            } else {
                throw new MatchError((Object)option7);
            }
            return Some$.MODULE$.apply((Object)zIO);
        }
        if (body2 instanceof Body.ArrayBody) {
            Body.ArrayBody arrayBody = Body$ArrayBody$.MODULE$.unapply((Body.ArrayBody)body2);
            byte[] byArray = arrayBody._1();
            Option<MediaType> option = arrayBody._2();
            Option<Boundary> option8 = arrayBody._3();
            byte[] data = byArray;
            this.zio$http$netty$NettyBodyWriter$$$_$writeArray$1(ctx, data, true);
            return None$.MODULE$;
        }
        if (body2 instanceof Body.ChunkBody) {
            Body.ChunkBody chunkBody = Body$ChunkBody$.MODULE$.unapply((Body.ChunkBody)body2);
            Chunk<Object> chunk = chunkBody._1();
            Option<MediaType> option = chunkBody._2();
            Option<Boundary> option9 = chunkBody._3();
            Chunk<Object> data = chunk;
            this.zio$http$netty$NettyBodyWriter$$$_$writeArray$1(ctx, (byte[])data.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), true);
            return None$.MODULE$;
        }
        if (Body$EmptyBody$.MODULE$.equals(body2)) {
            ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            return None$.MODULE$;
        }
        throw new MatchError((Object)body2);
    }

    public final ChannelFuture zio$http$netty$NettyBodyWriter$$$_$writeArray$1(ChannelHandlerContext ctx$1, byte[] body, boolean isLast) {
        DefaultHttpContent content = new DefaultHttpContent(Unpooled.wrappedBuffer(body));
        if (isLast) {
            ctx$1.write(content);
            return ctx$1.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
        }
        return ctx$1.writeAndFlush(content);
    }

    private final Option writeAndFlush$$anonfun$1(Body body$1) {
        return body$1.knownContentLength();
    }

    private final long writeAndFlush$$anonfun$2(long length$1) {
        return length$1;
    }

    private final Future writeAndFlush$$anonfun$3$$anonfun$1(ChannelHandlerContext ctx$3, Chunk bytes$1) {
        return this.zio$http$netty$NettyBodyWriter$$$_$writeArray$1(ctx$3, (byte[])bytes$1.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), true);
    }

    private final long writeAndFlush$$anonfun$3$$anonfun$2() {
        return 0L;
    }

    private final Future writeAndFlush$$anonfun$3$$anonfun$3(ChannelHandlerContext ctx$5, Chunk bytes$2) {
        return this.zio$http$netty$NettyBodyWriter$$$_$writeArray$1(ctx$5, (byte[])bytes$2.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), false);
    }

    private final long writeAndFlush$$anonfun$3$$anonfun$4(long n$1) {
        return n$1;
    }

    private final /* synthetic */ ZIO writeAndFlush$$anonfun$3(ChannelHandlerContext ctx$4, Object trace$1, long remaining, Chunk bytes) {
        long l = remaining - (long)bytes.size();
        if (0L == l) {
            return NettyFutureExecutor$.MODULE$.executed(() -> this.writeAndFlush$$anonfun$3$$anonfun$1(ctx$4, bytes), trace$1).as(this::writeAndFlush$$anonfun$3$$anonfun$2, trace$1);
        }
        long n = l;
        return NettyFutureExecutor$.MODULE$.executed(() -> this.writeAndFlush$$anonfun$3$$anonfun$3(ctx$4, bytes), trace$1).as(() -> this.writeAndFlush$$anonfun$3$$anonfun$4(n), trace$1);
    }

    private final String writeAndFlush$$anonfun$4$$anonfun$1(long length$3, long actualLength$1) {
        return new StringBuilder(44).append("Expected Content-Length of ").append(length$3).append(", but sent ").append(actualLength$1).append(" bytes").toString();
    }

    private final Future writeAndFlush$$anonfun$4$$anonfun$2$$anonfun$1(ChannelHandlerContext ctx$8) {
        return ctx$8.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
    }

    private final ZIO writeAndFlush$$anonfun$4$$anonfun$2(ChannelHandlerContext ctx$7, Object trace$3) {
        return NettyFutureExecutor$.MODULE$.executed(() -> this.writeAndFlush$$anonfun$4$$anonfun$2$$anonfun$1(ctx$7), trace$3);
    }

    private final /* synthetic */ ZIO writeAndFlush$$anonfun$4(ChannelHandlerContext ctx$6, Object trace$2, long length$2, long x$1) {
        long l = x$1;
        if (0L == l) {
            return ZIO$.MODULE$.unit();
        }
        long remaining = l;
        long actualLength = length$2 - remaining;
        return ZIO$.MODULE$.logWarning(() -> this.writeAndFlush$$anonfun$4$$anonfun$1(length$2, actualLength), trace$2).$times$greater(() -> this.writeAndFlush$$anonfun$4$$anonfun$2(ctx$6, trace$2), trace$2);
    }

    private final Future writeAndFlush$$anonfun$5$$anonfun$1(ChannelHandlerContext ctx$9, Chunk bytes$3) {
        return this.zio$http$netty$NettyBodyWriter$$$_$writeArray$1(ctx$9, (byte[])bytes$3.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), false);
    }

    private final Future writeAndFlush$$anonfun$6$$anonfun$1(ChannelHandlerContext ctx$12) {
        return ctx$12.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
    }

    private final ZIO writeAndFlush$$anonfun$6(ChannelHandlerContext ctx$11, Object trace$5) {
        return NettyFutureExecutor$.MODULE$.executed(() -> this.writeAndFlush$$anonfun$6$$anonfun$1(ctx$11), trace$5);
    }
}

