/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import java.io.IOException;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.AsyncBodyReader$State$;
import zio.http.netty.AsyncBodyReader$State$Buffering$;
import zio.http.netty.AsyncBodyReader$State$Direct$;
import zio.http.netty.NettyBody;
import zio.http.shaded.netty.buffer.ByteBufUtil;
import zio.http.shaded.netty.channel.ChannelHandlerContext;
import zio.http.shaded.netty.channel.SimpleChannelInboundHandler;
import zio.http.shaded.netty.handler.codec.http.HttpContent;
import zio.http.shaded.netty.handler.codec.http.LastHttpContent;

public abstract class AsyncBodyReader
extends SimpleChannelInboundHandler<HttpContent> {
    private final Unsafe unsafeClass = Unsafe$.MODULE$.unsafe();
    private State state = AsyncBodyReader$State$Buffering$.MODULE$;
    private final ChunkBuilder<Tuple2<Chunk<Object>, Object>> buffer = ChunkBuilder$.MODULE$.make();
    private boolean previousAutoRead = false;
    private ChannelHandlerContext ctx;

    public AsyncBodyReader(Object trace) {
        super(true);
    }

    public Unsafe unsafeClass() {
        return this.unsafeClass;
    }

    public void connect(NettyBody.UnsafeAsync callback) {
        AsyncBodyReader asyncBodyReader = this;
        synchronized (asyncBodyReader) {
            Chunk result;
            State state = this.state;
            if (AsyncBodyReader$State$Buffering$.MODULE$.equals(state)) {
                Tuple2 tuple2;
                boolean bl;
                result = (Chunk)this.buffer.result();
                Option option = result.lastOption();
                if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    boolean isLast;
                    bl = isLast = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                } else {
                    throw new MatchError((Object)option);
                }
                boolean readingDone = bl;
                if (!this.ctx.channel().isOpen() && !readingDone) {
                    throw new IllegalStateException("Attempting to read from a closed channel, which will never finish");
                }
            } else {
                if (state instanceof State.Direct) {
                    State.Direct direct = AsyncBodyReader$State$Direct$.MODULE$.unapply((State.Direct)state);
                    NettyBody.UnsafeAsync unsafeAsync = direct._1();
                    throw new IllegalStateException("Cannot connect twice");
                }
                throw new MatchError((Object)state);
            }
            this.state = AsyncBodyReader$State$Direct$.MODULE$.apply(callback);
            result.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Chunk chunk = (Chunk)tuple2._1();
                    boolean isLast = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                    callback.apply((Chunk<Object>)chunk, isLast);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            this.ctx.read();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.previousAutoRead = ctx.channel().config().isAutoRead();
        ctx.channel().config().setAutoRead(false);
        this.ctx = ctx;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        ctx.channel().config().setAutoRead(this.previousAutoRead);
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, HttpContent msg) {
        boolean isLast = msg instanceof LastHttpContent;
        Chunk chunk = Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes(msg.content()));
        AsyncBodyReader asyncBodyReader = this;
        synchronized (asyncBodyReader) {
            Object object;
            State state = this.state;
            if (AsyncBodyReader$State$Buffering$.MODULE$.equals(state)) {
                object = this.buffer.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)chunk, (Object)BoxesRunTime.boxToBoolean((boolean)isLast)));
            } else if (state instanceof State.Direct) {
                NettyBody.UnsafeAsync unsafeAsync;
                State.Direct direct = AsyncBodyReader$State$Direct$.MODULE$.unapply((State.Direct)state);
                NettyBody.UnsafeAsync callback = unsafeAsync = direct._1();
                callback.apply((Chunk<Object>)chunk, isLast);
                object = ctx.read();
            } else {
                throw new MatchError((Object)state);
            }
        }
        if (isLast) {
            ctx.channel().pipeline().remove(this);
            return;
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        AsyncBodyReader asyncBodyReader = this;
        synchronized (asyncBodyReader) {
            State state = this.state;
            if (!AsyncBodyReader$State$Buffering$.MODULE$.equals(state)) {
                if (state instanceof State.Direct) {
                    NettyBody.UnsafeAsync unsafeAsync;
                    State.Direct direct = AsyncBodyReader$State$Direct$.MODULE$.unapply((State.Direct)state);
                    NettyBody.UnsafeAsync callback = unsafeAsync = direct._1();
                    callback.fail(cause);
                } else {
                    throw new MatchError((Object)state);
                }
            }
        }
        super.exceptionCaught(ctx, cause);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        AsyncBodyReader asyncBodyReader = this;
        synchronized (asyncBodyReader) {
            State state = this.state;
            if (!AsyncBodyReader$State$Buffering$.MODULE$.equals(state)) {
                if (state instanceof State.Direct) {
                    NettyBody.UnsafeAsync unsafeAsync;
                    State.Direct direct = AsyncBodyReader$State$Direct$.MODULE$.unapply((State.Direct)state);
                    NettyBody.UnsafeAsync callback = unsafeAsync = direct._1();
                    callback.fail(new IOException("Channel closed unexpectedly"));
                } else {
                    throw new MatchError((Object)state);
                }
            }
        }
        ctx.fireChannelInactive();
    }

    public static interface State {
        public static int ordinal(State state) {
            return AsyncBodyReader$State$.MODULE$.ordinal(state);
        }
    }
}

