/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import java.time.Duration;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.control.NonFatal$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit;
import zio.Exit$;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.StackTrace;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.Charsets$;
import zio.http.Handler;
import zio.http.Handler$ContraFlatMap$;
import zio.http.Handler$FromFunction$;
import zio.http.Handler$FromFunctionExit$;
import zio.http.Handler$FromFunctionHandler$;
import zio.http.Handler$FromFunctionZIO$;
import zio.http.Handler$IsRequest$;
import zio.http.Handler$ParamExtractorBuilder$;
import zio.http.Handler$ResponseOutputSyntax$;
import zio.http.HandlerPlatformSpecific;
import zio.http.HandlerVersionSpecific;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Status;
import zio.http.Status$BadRequest$;
import zio.http.Status$Forbidden$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$MethodNotAllowed$;
import zio.http.Status$NotFound$;
import zio.http.Status$Ok$;
import zio.http.Status$RequestEntityTooLarge$;
import zio.http.Status$RequestTimeout$;
import zio.http.ToHandler;
import zio.http.WebSocketApp;
import zio.http.WebSocketApp$;
import zio.http.WebSocketFrame;
import zio.http.template.Html;
import zio.http.template.Template$;
import zio.stream.ZStream;

public final class Handler$
implements HandlerPlatformSpecific,
HandlerVersionSpecific,
Serializable {
    public static final Handler$IsRequest$ IsRequest;
    private static final Handler unit;
    public static final Handler$ResponseOutputSyntax$ ResponseOutputSyntax;
    public static final Handler$ContraFlatMap$ ContraFlatMap;
    public static final Handler$FromFunction$ FromFunction;
    public static final Handler$FromFunctionHandler$ FromFunctionHandler;
    public static final Handler$FromFunctionExit$ FromFunctionExit;
    public static final Handler$FromFunctionZIO$ FromFunctionZIO;
    public static final Handler$ParamExtractorBuilder$ ParamExtractorBuilder;
    public static final Handler$ MODULE$;

    private Handler$() {
    }

    static {
        MODULE$ = new Handler$();
        unit = MODULE$.fromExit(MODULE$::$init$$$anonfun$1);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Handler$.class);
    }

    public Handler<Object, Throwable, Object, Chunk<Object>> asChunkBounded(Request request, int limit, Object trace) {
        return this.fromZIO(() -> this.asChunkBounded$$anonfun$1(request, limit, trace));
    }

    public <Out> Handler<Object, Throwable, Object, Out> attempt(Function0<Out> out) {
        return this.fromExit(() -> this.attempt$$anonfun$1(out));
    }

    public Handler<Object, Nothing$, Object, Response> badRequest() {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::badRequest$$anonfun$1));
    }

    public Handler<Object, Nothing$, Object, Response> badRequest(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::badRequest$$anonfun$2), message);
    }

    public Handler<Object, Nothing$, Object, Nothing$> die(Function0<Throwable> failure) {
        return this.fromExit(() -> this.die$$anonfun$1(failure));
    }

    public Handler<Object, Nothing$, Object, Nothing$> dieMessage(Function0<String> message) {
        return this.die((Function0<Throwable>)((Function0 & Serializable)() -> this.dieMessage$$anonfun$1(message)));
    }

    public Handler<Object, Nothing$, Object, Response> error(Function0<Status.Error> status) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> this.error$$anonfun$1(status)));
    }

    public Handler<Object, Nothing$, Object, Response> error(Function0<Status.Error> status, Function0<String> message) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> this.error$$anonfun$2(status, message)));
    }

    public <Err> Handler<Object, Err, Object, Nothing$> fail(Function0<Err> err) {
        return this.fromExit(() -> this.fail$$anonfun$1(err));
    }

    public <Err> Handler<Object, Err, Object, Nothing$> failCause(Function0<Cause<Err>> cause) {
        return this.fromExit(() -> this.failCause$$anonfun$1(cause));
    }

    public <R, Err, In, Out> Handler<R, Err, In, Out> firstSuccessOf(NonEmptyChunk<Handler<R, Err, In, Out>> handlers, Function1<Cause<Err>, Object> isRecoverable, Object trace) {
        return (Handler)((Chunk)NonEmptyChunk$.MODULE$.toChunk(handlers).tail()).foldLeft(NonEmptyChunk$.MODULE$.toChunk(handlers).head(), (Function2 & Serializable)(acc, handler) -> acc.catchAllCause((Function1 & Serializable)cause -> {
            if (BoxesRunTime.unboxToBoolean((Object)isRecoverable.apply(cause))) {
                return handler;
            }
            return this.failCause(() -> this.firstSuccessOf$$anonfun$1$$anonfun$1$$anonfun$1(cause));
        }, trace));
    }

    public <R, Err, In, Out> Function1<Cause<Err>, Object> firstSuccessOf$default$2() {
        return (Function1 & Serializable)cause -> !cause.isDie();
    }

    public Handler<Object, Nothing$, Object, Response> forbidden() {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::forbidden$$anonfun$1));
    }

    public Handler<Object, Nothing$, Object, Response> forbidden(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::forbidden$$anonfun$2), message);
    }

    public <H> Handler<Object, Object, Object, Object> from(Function0<H> handler, ToHandler<H> h) {
        return h.toHandler(handler);
    }

    public Handler<Object, Nothing$, Object, Response> fromBody(Function0<Body> body) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> this.fromBody$$anonfun$1(body)));
    }

    public <Err, Out> Handler<Object, Err, Object, Out> fromEither(Function0<Either<Err, Out>> either) {
        return (Handler)((Either)either.apply()).fold((Function1 & Serializable)_$36 -> this.fail(() -> this.fromEither$$anonfun$1$$anonfun$1(_$36)), (Function1 & Serializable)_$37 -> this.succeed(() -> this.fromEither$$anonfun$2$$anonfun$1(_$37)));
    }

    public <Err, Out> Handler<Object, Err, Object, Out> fromExit(Function0<Exit<Err, Out>> exit) {
        return new Handler<Object, Err, Object, Out>(exit, this){
            private final Function0 exit$1;
            {
                this.exit$1 = exit$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public ZIO apply(Object in) {
                return (ZIO)this.exit$1.apply();
            }
        };
    }

    public <In> BoxedUnit fromFunction() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionHandler() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionExit() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionZIO() {
        return BoxedUnit.UNIT;
    }

    public Option<MediaType> determineMediaType(String filePath) {
        int n = filePath.lastIndexOf(".");
        if (-1 == n) {
            return None$.MODULE$;
        }
        int i = n;
        String ext = filePath.substring(i + 1);
        return MediaType$.MODULE$.forFileExtension(ext);
    }

    public <R> Handler<R, Throwable, Object, Response> fromFile(Function0<File> makeFile, Object trace) {
        return this.fromFileZIO(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$6 -> (File)makeFile.apply(), trace), trace);
    }

    public <R> Handler<R, Throwable, Object, Response> fromFileZIO(ZIO<R, Throwable, File> getFile, Object trace) {
        return this.fromZIO(() -> this.fromFileZIO$$anonfun$1(getFile, trace));
    }

    public <R> Handler<R, Throwable, Object, Response> fromStream(ZStream<R, Throwable, String> stream, long contentLength, Charset charset, Object trace) {
        return this.fromZIO(() -> this.fromStream$$anonfun$1(stream, contentLength, charset, trace)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R> Charset fromStream$default$3() {
        return Charsets$.MODULE$.Http();
    }

    public <R> Handler<R, Throwable, Object, Response> fromStream(ZStream<R, Throwable, Object> stream, long contentLength, Object trace) {
        return this.fromZIO(() -> this.fromStream$$anonfun$2(stream, contentLength, trace)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R> Handler<R, Throwable, Object, Response> fromStreamChunked(ZStream<R, Throwable, String> stream, Charset charset, Object trace) {
        return this.fromZIO(() -> this.fromStreamChunked$$anonfun$1(stream, charset, trace)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R> Charset fromStreamChunked$default$2() {
        return Charsets$.MODULE$.Http();
    }

    public <R> Handler<R, Throwable, Object, Response> fromStreamChunked(ZStream<R, Throwable, Object> stream, Object trace) {
        return this.fromZIO(() -> this.fromStreamChunked$$anonfun$2(stream, trace)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R, Err, Out> Handler<R, Err, Object, Out> fromZIO(Function0<ZIO<R, Err, Out>> zio) {
        return new Handler<R, Err, Object, Out>(zio, this){
            private final Function0 zio$1;
            {
                this.zio$1 = zio$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public ZIO apply(Object in) {
                return (ZIO)this.zio$1.apply();
            }
        };
    }

    public Handler<Object, Nothing$, Object, Response> html(Function0<Html> view) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> this.html$$anonfun$1(view)));
    }

    public <A> Handler<Object, Nothing$, A, A> identity() {
        return new Handler<Object, Nothing$, A, A>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public ZIO apply(Object in) {
                return Exit$.MODULE$.succeed(in);
            }
        };
    }

    public Handler<Object, Nothing$, Object, Response> internalServerError() {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::internalServerError$$anonfun$1));
    }

    public Handler<Object, Nothing$, Object, Response> internalServerError(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::internalServerError$$anonfun$2), message);
    }

    public Handler<Object, Nothing$, Object, Response> methodNotAllowed() {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::methodNotAllowed$$anonfun$1));
    }

    public Handler<Object, Nothing$, Object, Response> methodNotAllowed(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::methodNotAllowed$$anonfun$2), message);
    }

    public Handler<Object, Nothing$, Request, Response> notFound() {
        BoxedUnit boxedUnit = this.fromFunctionHandler();
        return Handler$FromFunctionHandler$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)request -> this.error((Function0<Status.Error>)((Function0 & Serializable)this::notFound$$anonfun$1$$anonfun$1), (Function0<String>)((Function0 & Serializable)() -> this.notFound$$anonfun$1$$anonfun$2(request))));
    }

    public Handler<Object, Nothing$, Object, Response> notFound(Function0<String> message) {
        return this.error((Function0<Status.Error>)((Function0 & Serializable)this::notFound$$anonfun$2), message);
    }

    public Handler<Object, Nothing$, Object, Response> ok() {
        return this.status((Function0<Status>)((Function0 & Serializable)this::ok$$anonfun$1));
    }

    public <A> BoxedUnit param() {
        return BoxedUnit.UNIT;
    }

    public Handler<Object, Nothing$, Object, Response> fromResponse(Function0<Response> response) {
        return this.succeed(response);
    }

    public <R, Err> Handler<R, Err, Object, Response> fromResponseZIO(ZIO<R, Err, Response> getResponse) {
        return this.fromZIO(() -> this.fromResponseZIO$$anonfun$1(getResponse));
    }

    public Handler<Object, Nothing$, Object, StackTrace> stackTrace(Object trace) {
        return this.fromZIO(() -> this.stackTrace$$anonfun$1(trace));
    }

    public Handler<Object, Nothing$, Object, Response> status(Function0<Status> code) {
        return this.succeed(() -> this.status$$anonfun$2(code));
    }

    public <Out> Handler<Object, Nothing$, Object, Out> succeed(Function0<Out> out) {
        return this.fromExit(() -> this.succeed$$anonfun$1(out));
    }

    public Handler<Object, Nothing$, Object, Response> template(Function0<CharSequence> heading, Html view) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> this.template$$anonfun$1(heading, view)));
    }

    public Handler<Object, Nothing$, Object, Response> text(Function0<CharSequence> text) {
        return this.fromResponse((Function0<Response>)((Function0 & Serializable)() -> this.text$$anonfun$1(text)));
    }

    public Handler<Object, Nothing$, Object, Response> timeout(Duration duration, Object trace) {
        return this.status((Function0<Status>)((Function0 & Serializable)this::timeout$$anonfun$2)).delay(duration, trace);
    }

    public Handler<Object, Nothing$, Object, Response> tooLarge() {
        return this.status((Function0<Status>)((Function0 & Serializable)this::tooLarge$$anonfun$1));
    }

    public Handler<Object, Nothing$, Object, BoxedUnit> unit() {
        return unit;
    }

    public final <Env> WebSocketApp<Env> webSocket(Function1<Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>>, ZIO<Env, Throwable, Object>> f) {
        BoxedUnit boxedUnit = this.fromFunctionZIO();
        return WebSocketApp$.MODULE$.apply(Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, f));
    }

    public final <R, Err> Handler.RequestHandlerSyntax<R, Err> RequestHandlerSyntax(Handler<R, Err, Request, Response> self) {
        return new Handler.RequestHandlerSyntax<R, Err>(self);
    }

    public final <R, Err, In> Handler ResponseOutputSyntax(Handler<R, Err, In, Response> self) {
        return self;
    }

    private final Exit $init$$$anonfun$1() {
        return Exit$.MODULE$.unit();
    }

    private final Chunk asChunkBounded$$anonfun$1$$anonfun$1() {
        return Chunk$.MODULE$.empty();
    }

    private final Exception asChunkBounded$$anonfun$1$$anonfun$2$$anonfun$3() {
        return new Exception("Too large input");
    }

    private final ZIO asChunkBounded$$anonfun$1(Request request$1, int limit$1, Object trace$19) {
        return request$1.body().asStream(trace$19).chunks(trace$19).runFoldZIO(this::asChunkBounded$$anonfun$1$$anonfun$1, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Chunk acc = (Chunk)tuple2._1();
                Chunk bytes = (Chunk)tuple2._2();
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> acc.$plus$plus(bytes), trace$19).filterOrFail((Function1 & Serializable)_$35 -> _$35.size() < limit$1, this::asChunkBounded$$anonfun$1$$anonfun$2$$anonfun$3, trace$19);
            }
            throw new MatchError((Object)tuple2);
        }, trace$19);
    }

    private final Exit attempt$$anonfun$1(Function0 out$11) {
        Exit exit;
        try {
            exit = Exit$.MODULE$.succeed(out$11.apply());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable cause = throwable3 = (Throwable)option.get();
                exit = Exit$.MODULE$.fail((Object)cause);
            }
            throw throwable;
        }
        return exit;
    }

    private final Status.Error badRequest$$anonfun$1() {
        return Status$BadRequest$.MODULE$;
    }

    private final Status.Error badRequest$$anonfun$2() {
        return Status$BadRequest$.MODULE$;
    }

    private final Exit die$$anonfun$1(Function0 failure$1) {
        return Exit$.MODULE$.die((Throwable)failure$1.apply());
    }

    private final Throwable dieMessage$$anonfun$1(Function0 message$1) {
        return new RuntimeException((String)message$1.apply());
    }

    private final Response error$$anonfun$1(Function0 status$2) {
        return Response$.MODULE$.error((Status.Error)status$2.apply());
    }

    private final Response error$$anonfun$2(Function0 status$3, Function0 message$2) {
        return Response$.MODULE$.error((Status.Error)status$3.apply(), (String)message$2.apply());
    }

    private final Exit fail$$anonfun$1(Function0 err$11) {
        return Exit$.MODULE$.fail(err$11.apply());
    }

    private final Exit failCause$$anonfun$1(Function0 cause$8) {
        return Exit$.MODULE$.failCause((Cause)cause$8.apply());
    }

    private final Cause firstSuccessOf$$anonfun$1$$anonfun$1$$anonfun$1(Cause cause$9) {
        return cause$9;
    }

    private final Status.Error forbidden$$anonfun$1() {
        return Status$Forbidden$.MODULE$;
    }

    private final Status.Error forbidden$$anonfun$2() {
        return Status$Forbidden$.MODULE$;
    }

    private final Response fromBody$$anonfun$1(Function0 body$2) {
        Body body = (Body)body$2.apply();
        Status status = Response$.MODULE$.$lessinit$greater$default$1();
        Headers headers = Response$.MODULE$.$lessinit$greater$default$2();
        return Response$.MODULE$.apply(status, headers, body);
    }

    private final Object fromEither$$anonfun$1$$anonfun$1(Object _$36$1) {
        return _$36$1;
    }

    private final Object fromEither$$anonfun$2$$anonfun$1(Object _$37$1) {
        return _$37$1;
    }

    private final FileNotFoundException fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new FileNotFoundException();
    }

    private final AccessDeniedException fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(File file$1) {
        return new AccessDeniedException(file$1.getAbsolutePath());
    }

    private final NotDirectoryException fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$4() {
        return new NotDirectoryException("Found directory instead of a file.");
    }

    private final ZIO fromFileZIO$$anonfun$1$$anonfun$1(ZIO getFile$2, Object trace$23) {
        return getFile$2.flatMap((Function1 & Serializable)file -> {
            if (!file.exists()) {
                return ZIO$.MODULE$.fail(this::fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, trace$23);
            }
            if (file.isFile() && !file.canRead()) {
                return ZIO$.MODULE$.fail(() -> this.fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(file), trace$23);
            }
            if (file.isFile()) {
                return Body$.MODULE$.fromFile((File)file, Body$.MODULE$.fromFile$default$2(), trace$23).flatMap((Function1 & Serializable)body -> {
                    Response response = Response$.MODULE$.apply(Response$.MODULE$.$lessinit$greater$default$1(), Response$.MODULE$.$lessinit$greater$default$2(), (Body)body);
                    String pathName = file.toPath().toString();
                    Option<MediaType> option = this.determineMediaType(pathName);
                    if (option instanceof Some) {
                        MediaType mediaType = (MediaType)((Some)option).value();
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$7 -> (Response)response.addHeader(Header$ContentType$.MODULE$.apply(mediaType, Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())), trace$23);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> response, trace$23);
                    }
                    throw new MatchError(option);
                }, trace$23);
            }
            return ZIO$.MODULE$.fail(this::fromFileZIO$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$4, trace$23);
        }, trace$23);
    }

    private final ZIO fromFileZIO$$anonfun$1(ZIO getFile$1, Object trace$22) {
        return ZIO$.MODULE$.blocking(() -> this.fromFileZIO$$anonfun$1$$anonfun$1(getFile$1, trace$22), trace$22);
    }

    private final ZEnvironment fromStream$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(ZEnvironment env$2) {
        return env$2;
    }

    private final Body fromStream$$anonfun$1$$anonfun$1$$anonfun$1(ZStream stream$3, long contentLength$3, Charset charset$3, Object trace$28, ZEnvironment env$1) {
        return Body$.MODULE$.fromCharSequenceStream((ZStream<Object, Throwable, CharSequence>)stream$3.provideEnvironment(() -> this.fromStream$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(env$1), trace$28), contentLength$3, charset$3, trace$28);
    }

    private final ZIO fromStream$$anonfun$1(ZStream stream$1, long contentLength$1, Charset charset$1, Object trace$26) {
        return ZIO$.MODULE$.environment(trace$26).map((Function1 & Serializable)env -> this.fromBody((Function0<Body>)((Function0 & Serializable)() -> this.fromStream$$anonfun$1$$anonfun$1$$anonfun$1(stream$1, contentLength$1, charset$1, trace$26, env))), trace$26);
    }

    private final ZEnvironment fromStream$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(ZEnvironment env$4) {
        return env$4;
    }

    private final Body fromStream$$anonfun$2$$anonfun$1$$anonfun$1(ZStream stream$6, long contentLength$6, Object trace$31, ZEnvironment env$3) {
        return Body$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)stream$6.provideEnvironment(() -> this.fromStream$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(env$3), trace$31), contentLength$6);
    }

    private final ZIO fromStream$$anonfun$2(ZStream stream$4, long contentLength$4, Object trace$29) {
        return ZIO$.MODULE$.environment(trace$29).map((Function1 & Serializable)env -> this.fromBody((Function0<Body>)((Function0 & Serializable)() -> this.fromStream$$anonfun$2$$anonfun$1$$anonfun$1(stream$4, contentLength$4, trace$29, env))), trace$29);
    }

    private final ZEnvironment fromStreamChunked$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(ZEnvironment env$6) {
        return env$6;
    }

    private final Body fromStreamChunked$$anonfun$1$$anonfun$1$$anonfun$1(ZStream stream$9, Charset charset$6, Object trace$34, ZEnvironment env$5) {
        return Body$.MODULE$.fromCharSequenceStreamChunked((ZStream<Object, Throwable, CharSequence>)stream$9.provideEnvironment(() -> this.fromStreamChunked$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(env$5), trace$34), charset$6, trace$34);
    }

    private final ZIO fromStreamChunked$$anonfun$1(ZStream stream$7, Charset charset$4, Object trace$32) {
        return ZIO$.MODULE$.environment(trace$32).map((Function1 & Serializable)env -> this.fromBody((Function0<Body>)((Function0 & Serializable)() -> this.fromStreamChunked$$anonfun$1$$anonfun$1$$anonfun$1(stream$7, charset$4, trace$32, env))), trace$32);
    }

    private final ZEnvironment fromStreamChunked$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(ZEnvironment env$8) {
        return env$8;
    }

    private final Body fromStreamChunked$$anonfun$2$$anonfun$1$$anonfun$1(ZStream stream$12, Object trace$37, ZEnvironment env$7) {
        return Body$.MODULE$.fromStreamChunked((ZStream<Object, Throwable, Object>)stream$12.provideEnvironment(() -> this.fromStreamChunked$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(env$7), trace$37));
    }

    private final ZIO fromStreamChunked$$anonfun$2(ZStream stream$10, Object trace$35) {
        return ZIO$.MODULE$.environment(trace$35).map((Function1 & Serializable)env -> this.fromBody((Function0<Body>)((Function0 & Serializable)() -> this.fromStreamChunked$$anonfun$2$$anonfun$1$$anonfun$1(stream$10, trace$35, env))), trace$35);
    }

    private final Response html$$anonfun$1(Function0 view$1) {
        return Response$.MODULE$.html((Html)view$1.apply(), Response$.MODULE$.html$default$2());
    }

    private final Status.Error internalServerError$$anonfun$1() {
        return Status$InternalServerError$.MODULE$;
    }

    private final Status.Error internalServerError$$anonfun$2() {
        return Status$InternalServerError$.MODULE$;
    }

    private final Status.Error methodNotAllowed$$anonfun$1() {
        return Status$MethodNotAllowed$.MODULE$;
    }

    private final Status.Error methodNotAllowed$$anonfun$2() {
        return Status$MethodNotAllowed$.MODULE$;
    }

    private final Status.Error notFound$$anonfun$1$$anonfun$1() {
        return Status$NotFound$.MODULE$;
    }

    private final String notFound$$anonfun$1$$anonfun$2(Request request$2) {
        return request$2.url().path().encode();
    }

    private final Status.Error notFound$$anonfun$2() {
        return Status$NotFound$.MODULE$;
    }

    private final Status ok$$anonfun$1() {
        return Status$Ok$.MODULE$;
    }

    private final ZIO fromResponseZIO$$anonfun$1(ZIO getResponse$1) {
        return getResponse$1;
    }

    private final ZIO stackTrace$$anonfun$1(Object trace$38) {
        return ZIO$.MODULE$.stackTrace(trace$38);
    }

    private final Response status$$anonfun$2(Function0 code$1) {
        return Response$.MODULE$.apply((Status)code$1.apply(), Response$.MODULE$.$lessinit$greater$default$2(), Response$.MODULE$.$lessinit$greater$default$3());
    }

    private final Exit succeed$$anonfun$1(Function0 out$12) {
        return Exit$.MODULE$.succeed(out$12.apply());
    }

    private final Response template$$anonfun$1(Function0 heading$1, Html view$2) {
        return Response$.MODULE$.html(Template$.MODULE$.container((CharSequence)heading$1.apply(), view$2), Response$.MODULE$.html$default$2());
    }

    private final Response text$$anonfun$1(Function0 text$1) {
        return Response$.MODULE$.text((CharSequence)text$1.apply());
    }

    private final Status timeout$$anonfun$2() {
        return Status$RequestTimeout$.MODULE$;
    }

    private final Status tooLarge$$anonfun$1() {
        return Status$RequestEntityTooLarge$.MODULE$;
    }
}

