/*
 * Decompiled with CFR 0.152.
 */
package zio.http.logging;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Path;
import java.time.LocalDateTime;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import zio.Cause;
import zio.Cause$;
import zio.FiberId;
import zio.FiberRefs$;
import zio.LogLevel;
import zio.LogLevel$;
import zio.Trace$;
import zio.ZIO;
import zio.ZLogger;
import zio.http.logging.LogFormat;
import zio.http.logging.LogFormat$;
import zio.http.logging.LogLevel$Debug$;
import zio.http.logging.LogLevel$Error$;
import zio.http.logging.LogLevel$Info$;
import zio.http.logging.LogLevel$Trace$;
import zio.http.logging.LogLevel$Warn$;
import zio.http.logging.LogLine;
import zio.http.logging.LogLine$;
import zio.http.logging.Logger;
import zio.http.logging.Logger$;
import zio.http.logging.LoggerTransport$;
import zio.http.logging.LoggerTransport$DefaultLoggerTransport$;
import zio.http.logging.LoggerTransport$ZioLoggerTransport$;

public interface LoggerTransport {
    public static DefaultLoggerTransport console() {
        return LoggerTransport$.MODULE$.console();
    }

    public static DefaultLoggerTransport empty() {
        return LoggerTransport$.MODULE$.empty();
    }

    public static DefaultLoggerTransport file(Path path) {
        return LoggerTransport$.MODULE$.file(path);
    }

    public static ZIO<Object, Nothing$, LoggerTransport> zio() {
        return LoggerTransport$.MODULE$.zio();
    }

    public static void $init$(LoggerTransport $this) {
        $this.zio$http$logging$LoggerTransport$_setter_$isDebugEnabled_$eq($this.level().$less$eq(LogLevel$Debug$.MODULE$));
        $this.zio$http$logging$LoggerTransport$_setter_$isErrorEnabled_$eq($this.level().$less$eq(LogLevel$Error$.MODULE$));
        $this.zio$http$logging$LoggerTransport$_setter_$isInfoEnabled_$eq($this.level().$less$eq(LogLevel$Info$.MODULE$));
        $this.zio$http$logging$LoggerTransport$_setter_$isTraceEnabled_$eq($this.level().$less$eq(LogLevel$Trace$.MODULE$));
        $this.zio$http$logging$LoggerTransport$_setter_$isWarnEnabled_$eq($this.level().$less$eq(LogLevel$Warn$.MODULE$));
    }

    public void dispatch(String var1, Option<Throwable> var2, zio.http.logging.LogLevel var3, Option<Logger.SourcePos> var4);

    public static Logger toLogger$(LoggerTransport $this) {
        return $this.toLogger();
    }

    default public Logger toLogger() {
        return Logger$.MODULE$.apply((List<LoggerTransport>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggerTransport[]{this}))));
    }

    public LoggerTransport copy(LogFormat var1, zio.http.logging.LogLevel var2, Function1<String, Object> var3, List<String> var4);

    public static LogFormat copy$default$1$(LoggerTransport $this) {
        return $this.copy$default$1();
    }

    default public LogFormat copy$default$1() {
        return LogFormat$.MODULE$.inlineMinimal();
    }

    public static zio.http.logging.LogLevel copy$default$2$(LoggerTransport $this) {
        return $this.copy$default$2();
    }

    default public zio.http.logging.LogLevel copy$default$2() {
        return LogLevel$Error$.MODULE$;
    }

    public static Function1 copy$default$3$(LoggerTransport $this) {
        return $this.copy$default$3();
    }

    default public Function1<String, Object> copy$default$3() {
        return (Function1 & Serializable)_$1 -> true;
    }

    public static List copy$default$4$(LoggerTransport $this) {
        return $this.copy$default$4();
    }

    default public List<String> copy$default$4() {
        return package$.MODULE$.Nil();
    }

    public List<String> tags();

    public static LoggerTransport addTags$(LoggerTransport $this, Iterable tags) {
        return $this.addTags((Iterable<String>)tags);
    }

    default public LoggerTransport addTags(Iterable<String> tags) {
        List list = (List)this.tags().$plus$plus(tags);
        LogFormat logFormat = this.copy$default$1();
        zio.http.logging.LogLevel logLevel = this.copy$default$2();
        Function1<String, Object> function1 = this.copy$default$3();
        return this.copy(logFormat, logLevel, function1, (List<String>)list);
    }

    public static LoggerTransport withFilter$(LoggerTransport $this, Function1 filter) {
        return $this.withFilter((Function1<String, Object>)filter);
    }

    default public LoggerTransport withFilter(Function1<String, Object> filter) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), filter, this.copy$default$4());
    }

    public static LoggerTransport withFormat$(LoggerTransport $this, LogFormat format) {
        return $this.withFormat(format);
    }

    default public LoggerTransport withFormat(LogFormat format) {
        return this.copy(format, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public static LoggerTransport withLevel$(LoggerTransport $this, zio.http.logging.LogLevel level) {
        return $this.withLevel(level);
    }

    default public LoggerTransport withLevel(zio.http.logging.LogLevel level) {
        return this.copy(this.copy$default$1(), level, this.copy$default$3(), this.copy$default$4());
    }

    public static LoggerTransport withTags$(LoggerTransport $this, List tags) {
        return $this.withTags((List<String>)tags);
    }

    default public LoggerTransport withTags(List<String> tags) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), tags);
    }

    public zio.http.logging.LogLevel level();

    public boolean isDebugEnabled();

    public void zio$http$logging$LoggerTransport$_setter_$isDebugEnabled_$eq(boolean var1);

    public boolean isErrorEnabled();

    public void zio$http$logging$LoggerTransport$_setter_$isErrorEnabled_$eq(boolean var1);

    public boolean isInfoEnabled();

    public void zio$http$logging$LoggerTransport$_setter_$isInfoEnabled_$eq(boolean var1);

    public boolean isTraceEnabled();

    public void zio$http$logging$LoggerTransport$_setter_$isTraceEnabled_$eq(boolean var1);

    public boolean isWarnEnabled();

    public void zio$http$logging$LoggerTransport$_setter_$isWarnEnabled_$eq(boolean var1);

    public static abstract class DefaultLoggerTransport
    implements LoggerTransport {
        private boolean isDebugEnabled;
        private boolean isErrorEnabled;
        private boolean isInfoEnabled;
        private boolean isTraceEnabled;
        private boolean isWarnEnabled;
        private final LogFormat format;
        private final zio.http.logging.LogLevel level;
        private final Function1<String, Object> filter;
        private final List tags;

        public static LogFormat $lessinit$greater$default$1() {
            return LoggerTransport$DefaultLoggerTransport$.MODULE$.$lessinit$greater$default$1();
        }

        public static zio.http.logging.LogLevel $lessinit$greater$default$2() {
            return LoggerTransport$DefaultLoggerTransport$.MODULE$.$lessinit$greater$default$2();
        }

        public static Function1<String, Object> $lessinit$greater$default$3() {
            return LoggerTransport$DefaultLoggerTransport$.MODULE$.$lessinit$greater$default$3();
        }

        public static List<String> $lessinit$greater$default$4() {
            return LoggerTransport$DefaultLoggerTransport$.MODULE$.$lessinit$greater$default$4();
        }

        public DefaultLoggerTransport(LogFormat format, zio.http.logging.LogLevel level, Function1<String, Object> filter, List<String> tags) {
            this.format = format;
            this.level = level;
            this.filter = filter;
            this.tags = tags;
            LoggerTransport.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isDebugEnabled;
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isErrorEnabled;
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isInfoEnabled;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isTraceEnabled;
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isWarnEnabled;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isDebugEnabled_$eq(boolean x$0) {
            this.isDebugEnabled = x$0;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isErrorEnabled_$eq(boolean x$0) {
            this.isErrorEnabled = x$0;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isInfoEnabled_$eq(boolean x$0) {
            this.isInfoEnabled = x$0;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isTraceEnabled_$eq(boolean x$0) {
            this.isTraceEnabled = x$0;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isWarnEnabled_$eq(boolean x$0) {
            this.isWarnEnabled = x$0;
        }

        @Override
        public zio.http.logging.LogLevel level() {
            return this.level;
        }

        @Override
        public List<String> tags() {
            return this.tags;
        }

        private final List<LogLine> buildLines(String msg, Option<Throwable> throwable, zio.http.logging.LogLevel logLevel, List<String> tags, Option<Logger.SourcePos> sourceLocation) {
            return (List)throwable.fold(() -> this.buildLines$$anonfun$1(msg, throwable, logLevel, tags, sourceLocation), (Function1 & Serializable)t -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine[]{LogLine$.MODULE$.apply(LocalDateTime.now(), this.thread(), logLevel, msg, tags, throwable, sourceLocation), LogLine$.MODULE$.apply(LocalDateTime.now(), this.thread(), logLevel, this.stackTraceAsString((Throwable)t), tags, throwable, sourceLocation)})));
        }

        private final String stackTraceAsString(Throwable throwable) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }

        private final Thread thread() {
            return Thread.currentThread();
        }

        public abstract void run(CharSequence var1);

        @Override
        public final LoggerTransport copy(LogFormat format, zio.http.logging.LogLevel level, Function1<String, Object> filter, List<String> tags) {
            return new DefaultLoggerTransport(format, level, filter, tags, this){
                private final /* synthetic */ DefaultLoggerTransport $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(format$2, level$2, (Function1<String, Object>)filter$2, (List<String>)tags$4);
                }

                public void run(CharSequence charSequence) {
                    this.$outer.run(charSequence);
                }
            };
        }

        @Override
        public LogFormat copy$default$1() {
            return this.format;
        }

        @Override
        public zio.http.logging.LogLevel copy$default$2() {
            return this.level();
        }

        @Override
        public Function1<String, Object> copy$default$3() {
            return this.filter;
        }

        @Override
        public List<String> copy$default$4() {
            return this.tags();
        }

        @Override
        public final void dispatch(String msg, Option<Throwable> cause, zio.http.logging.LogLevel level, Option<Logger.SourcePos> sourceLocation) {
            if (this.level().$less$eq(level)) {
                this.buildLines(msg, cause, level, this.tags(), sourceLocation).foreach((Function1)(JProcedure1 & Serializable)line -> {
                    String formatted = this.format.apply((LogLine)line);
                    if (BoxesRunTime.unboxToBoolean((Object)this.filter.apply((Object)formatted))) {
                        this.run(formatted);
                        return;
                    }
                });
                return;
            }
        }

        private final List buildLines$$anonfun$1(String msg$1, Option throwable$1, zio.http.logging.LogLevel logLevel$1, List tags$2, Option sourceLocation$1) {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine[]{LogLine$.MODULE$.apply(LocalDateTime.now(), this.thread(), logLevel$1, msg$1, (List<String>)tags$2, (Option<Throwable>)throwable$1, (Option<Logger.SourcePos>)sourceLocation$1)}));
        }
    }

    public static class ZioLoggerTransport
    implements LoggerTransport {
        private boolean isDebugEnabled;
        private boolean isErrorEnabled;
        private boolean isInfoEnabled;
        private boolean isTraceEnabled;
        private boolean isWarnEnabled;
        public final Set<ZLogger<String, Object>> zio$http$logging$LoggerTransport$ZioLoggerTransport$$loggers;
        private final LogFormat format;
        private final zio.http.logging.LogLevel level;
        private final Function1<String, Object> filter;
        private final List tags;

        public static LogFormat $lessinit$greater$default$2() {
            return LoggerTransport$ZioLoggerTransport$.MODULE$.$lessinit$greater$default$2();
        }

        public static zio.http.logging.LogLevel $lessinit$greater$default$3() {
            return LoggerTransport$ZioLoggerTransport$.MODULE$.$lessinit$greater$default$3();
        }

        public static Function1<String, Object> $lessinit$greater$default$4() {
            return LoggerTransport$ZioLoggerTransport$.MODULE$.$lessinit$greater$default$4();
        }

        public static List<String> $lessinit$greater$default$5() {
            return LoggerTransport$ZioLoggerTransport$.MODULE$.$lessinit$greater$default$5();
        }

        public ZioLoggerTransport(Set<ZLogger<String, Object>> loggers, LogFormat format, zio.http.logging.LogLevel level, Function1<String, Object> filter, List<String> tags) {
            this.zio$http$logging$LoggerTransport$ZioLoggerTransport$$loggers = loggers;
            this.format = format;
            this.level = level;
            this.filter = filter;
            this.tags = tags;
            LoggerTransport.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isDebugEnabled;
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isErrorEnabled;
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isInfoEnabled;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isTraceEnabled;
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isWarnEnabled;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isDebugEnabled_$eq(boolean x$0) {
            this.isDebugEnabled = x$0;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isErrorEnabled_$eq(boolean x$0) {
            this.isErrorEnabled = x$0;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isInfoEnabled_$eq(boolean x$0) {
            this.isInfoEnabled = x$0;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isTraceEnabled_$eq(boolean x$0) {
            this.isTraceEnabled = x$0;
        }

        @Override
        public void zio$http$logging$LoggerTransport$_setter_$isWarnEnabled_$eq(boolean x$0) {
            this.isWarnEnabled = x$0;
        }

        @Override
        public zio.http.logging.LogLevel level() {
            return this.level;
        }

        @Override
        public List<String> tags() {
            return this.tags;
        }

        @Override
        public final LoggerTransport copy(LogFormat format, zio.http.logging.LogLevel level, Function1<String, Object> filter, List<String> tags) {
            return new ZioLoggerTransport(format, level, filter, tags, this){
                private final /* synthetic */ ZioLoggerTransport $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.zio$http$logging$LoggerTransport$ZioLoggerTransport$$loggers, format$3, level$3, (Function1<String, Object>)filter$3, (List<String>)tags$5);
                }

                public void dispatch(String msg, Option cause, zio.http.logging.LogLevel level, Option sourceLocation) {
                    this.$outer.dispatch(msg, (Option<Throwable>)cause, level, (Option<Logger.SourcePos>)sourceLocation);
                }
            };
        }

        @Override
        public LogFormat copy$default$1() {
            return this.format;
        }

        @Override
        public zio.http.logging.LogLevel copy$default$2() {
            return this.level();
        }

        @Override
        public Function1<String, Object> copy$default$3() {
            return this.filter;
        }

        @Override
        public List<String> copy$default$4() {
            return this.tags();
        }

        @Override
        public void dispatch(String msg, Option<Throwable> cause, zio.http.logging.LogLevel level, Option<Logger.SourcePos> sourceLocation) {
            if (this.level().$less$eq(level)) {
                if (BoxesRunTime.unboxToBoolean((Object)this.filter.apply((Object)msg))) {
                    this.zio$http$logging$LoggerTransport$ZioLoggerTransport$$loggers.foreach((Function1 & Serializable)logger -> logger.apply(sourceLocation.map((Function1 & Serializable)pos -> Trace$.MODULE$.apply("zio-http", pos.file(), pos.line())).getOrElse(this::dispatch$$anonfun$2$$anonfun$2), (FiberId)FiberId.None$.MODULE$, this.toZioLogLevel(level), (Function0 & Serializable)() -> msg, (Cause)cause.map((Function1 & Serializable)_$4 -> Cause$.MODULE$.die(_$4, Cause$.MODULE$.die$default$2())).getOrElse(this::dispatch$$anonfun$2$$anonfun$5), FiberRefs$.MODULE$.empty(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), this.tags().map((Function1 & Serializable)_$5 -> {
                        String string = (String)Predef$.MODULE$.ArrowAssoc(_$5);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"");
                    }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                    return;
                }
                return;
            }
        }

        private LogLevel toZioLogLevel(zio.http.logging.LogLevel level) {
            zio.http.logging.LogLevel logLevel = level;
            if (LogLevel$Trace$.MODULE$.equals(logLevel)) {
                return LogLevel$.MODULE$.Trace();
            }
            if (LogLevel$Debug$.MODULE$.equals(logLevel)) {
                return LogLevel$.MODULE$.Debug();
            }
            if (LogLevel$Info$.MODULE$.equals(logLevel)) {
                return LogLevel$.MODULE$.Info();
            }
            if (LogLevel$Warn$.MODULE$.equals(logLevel)) {
                return LogLevel$.MODULE$.Warning();
            }
            if (LogLevel$Error$.MODULE$.equals(logLevel)) {
                return LogLevel$.MODULE$.Error();
            }
            throw new MatchError((Object)logLevel);
        }

        private final Object dispatch$$anonfun$2$$anonfun$2() {
            return Trace$.MODULE$.empty();
        }

        private final Cause dispatch$$anonfun$2$$anonfun$5() {
            return Cause$.MODULE$.empty();
        }
    }
}

