/*
 * Decompiled with CFR 0.152.
 */
package zio.http.logging;

import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import zio.http.logging.LogFormat;
import zio.http.logging.LogLevel;
import zio.http.logging.LogLevel$;
import zio.http.logging.LogLevel$Error$;
import zio.http.logging.Logger$;
import zio.http.logging.Logger$SourcePos$;
import zio.http.logging.LoggerTransport;
import zio.http.logging.macros.LoggerMacroExtensions;

public final class Logger
implements LoggerMacroExtensions,
Product,
Serializable {
    private final List transports;
    private final boolean isDebugEnabled;
    private final boolean isErrorEnabled;
    private final boolean isInfoEnabled;
    private final boolean isTraceEnabled;
    private final boolean isWarnEnabled;

    public static Logger apply(List<LoggerTransport> list) {
        return Logger$.MODULE$.apply(list);
    }

    public static Logger console() {
        return Logger$.MODULE$.console();
    }

    public static LogLevel detectedLevel() {
        return Logger$.MODULE$.detectedLevel();
    }

    public static Logger file(Path path) {
        return Logger$.MODULE$.file(path);
    }

    public static Logger fromProduct(Product product) {
        return Logger$.MODULE$.fromProduct(product);
    }

    public static Logger make() {
        return Logger$.MODULE$.make();
    }

    public static Logger make(LoggerTransport loggerTransport) {
        return Logger$.MODULE$.make(loggerTransport);
    }

    public static Logger unapply(Logger logger) {
        return Logger$.MODULE$.unapply(logger);
    }

    public Logger(List<LoggerTransport> transports) {
        this.transports = transports;
        this.isDebugEnabled = transports.exists((Function1 & Serializable)_$1 -> _$1.isDebugEnabled());
        this.isErrorEnabled = transports.exists((Function1 & Serializable)_$2 -> _$2.isErrorEnabled());
        this.isInfoEnabled = transports.exists((Function1 & Serializable)_$3 -> _$3.isInfoEnabled());
        this.isTraceEnabled = transports.exists((Function1 & Serializable)_$4 -> _$4.isTraceEnabled());
        this.isWarnEnabled = transports.exists((Function1 & Serializable)_$5 -> _$5.isWarnEnabled());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Logger)) return false;
        Logger logger = (Logger)object;
        List<LoggerTransport> list = this.transports();
        List<LoggerTransport> list2 = logger.transports();
        if (list != null) {
            if (!list.equals(list2)) return false;
            return true;
        }
        if (list2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Logger;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Logger";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "transports";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public List<LoggerTransport> transports() {
        return this.transports;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    private Logger foreach(Function1<LoggerTransport, LoggerTransport> f) {
        return Logger$.MODULE$.apply((List<LoggerTransport>)this.transports().map(f));
    }

    public Logger $plus$plus(Logger other) {
        return this.combine(other);
    }

    public Logger combine(Logger other) {
        return Logger$.MODULE$.apply((List<LoggerTransport>)((List)this.transports().$plus$plus(other.transports())));
    }

    public Logger detectLevelFromEnv(String env) {
        return this.withLevel((LogLevel)LogLevel$.MODULE$.detectFromEnv(env).getOrElse(Logger::detectLevelFromEnv$$anonfun$1));
    }

    public Logger detectLevelFromProps(String env) {
        return this.withLevel((LogLevel)LogLevel$.MODULE$.detectFromProps(env).getOrElse(Logger::detectLevelFromProps$$anonfun$1));
    }

    public void dispatch(String msg, LogLevel level, Option<Throwable> cause, Option<SourcePos> sourceLocation) {
        this.transports().foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.dispatch(msg, cause, level, sourceLocation));
    }

    public void dispatch(String msg, LogLevel level) {
        this.dispatch(msg, level, (Option<Throwable>)None$.MODULE$, (Option<SourcePos>)None$.MODULE$);
    }

    public Logger startsWith(String prefix) {
        return this.withFilter((Function1<String, Object>)(Function1 & Serializable)_$8 -> _$8.startsWith(prefix));
    }

    public Logger withFilter(Function1<String, Object> filter) {
        return this.foreach((Function1<LoggerTransport, LoggerTransport>)(Function1 & Serializable)_$9 -> _$9.withFilter(filter));
    }

    public Logger withFormat(LogFormat format) {
        return this.foreach((Function1<LoggerTransport, LoggerTransport>)(Function1 & Serializable)_$10 -> _$10.withFormat(format));
    }

    public Logger withLevel(LogLevel level) {
        return this.foreach((Function1<LoggerTransport, LoggerTransport>)(Function1 & Serializable)_$11 -> _$11.withLevel(level));
    }

    public Logger withTags(Iterable<String> tags) {
        return this.foreach((Function1<LoggerTransport, LoggerTransport>)(Function1 & Serializable)_$12 -> _$12.addTags(tags));
    }

    public Logger withTags(Seq<String> tags) {
        return this.foreach((Function1<LoggerTransport, LoggerTransport>)(Function1 & Serializable)_$13 -> _$13.addTags((Iterable<String>)tags));
    }

    public Logger withTransport(LoggerTransport transport) {
        return this.copy((List<LoggerTransport>)this.transports().$colon$colon((Object)transport));
    }

    public Logger copy(List<LoggerTransport> transports) {
        return new Logger(transports);
    }

    public List<LoggerTransport> copy$default$1() {
        return this.transports();
    }

    public List<LoggerTransport> _1() {
        return this.transports();
    }

    private static final LogLevel detectLevelFromEnv$$anonfun$1() {
        return LogLevel$Error$.MODULE$;
    }

    private static final LogLevel detectLevelFromProps$$anonfun$1() {
        return LogLevel$Error$.MODULE$;
    }

    public static final class SourcePos
    implements Product,
    Serializable {
        private final String file;
        private final int line;

        public static SourcePos apply(String string, int n) {
            return Logger$SourcePos$.MODULE$.apply(string, n);
        }

        public static SourcePos fromProduct(Product product) {
            return Logger$SourcePos$.MODULE$.fromProduct(product);
        }

        public static SourcePos unapply(SourcePos sourcePos) {
            return Logger$SourcePos$.MODULE$.unapply(sourcePos);
        }

        public SourcePos(String file, int line) {
            this.file = file;
            this.line = line;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.file()));
            n = Statics.mix((int)n, (int)this.line());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SourcePos)) return false;
            SourcePos sourcePos = (SourcePos)object;
            if (this.line() != sourcePos.line()) return false;
            String string = this.file();
            String string2 = sourcePos.file();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SourcePos;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SourcePos";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "file";
            }
            if (1 == n2) {
                return "line";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String file() {
            return this.file;
        }

        public int line() {
            return this.line;
        }

        public SourcePos copy(String file, int line) {
            return new SourcePos(file, line);
        }

        public String copy$default$1() {
            return this.file();
        }

        public int copy$default$2() {
            return this.line();
        }

        public String _1() {
            return this.file();
        }

        public int _2() {
            return this.line();
        }
    }
}

