/*
 * Decompiled with CFR 0.152.
 */
package zio.http.logging;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import zio.http.logging.Font;
import zio.http.logging.Font$BLACK$;
import zio.http.logging.Font$BLACK_B$;
import zio.http.logging.Font$BLINK$;
import zio.http.logging.Font$BLUE$;
import zio.http.logging.Font$BLUE_B$;
import zio.http.logging.Font$BOLD$;
import zio.http.logging.Font$CYAN$;
import zio.http.logging.Font$CYAN_B$;
import zio.http.logging.Font$GREEN$;
import zio.http.logging.Font$GREEN_B$;
import zio.http.logging.Font$INVISIBLE$;
import zio.http.logging.Font$MAGENTA$;
import zio.http.logging.Font$MAGENTA_B$;
import zio.http.logging.Font$RED$;
import zio.http.logging.Font$RED_B$;
import zio.http.logging.Font$RESET$;
import zio.http.logging.Font$REVERSED$;
import zio.http.logging.Font$UNDERLINED$;
import zio.http.logging.Font$WHITE$;
import zio.http.logging.Font$WHITE_B$;
import zio.http.logging.Font$YELLOW$;
import zio.http.logging.Font$YELLOW_B$;
import zio.http.logging.LogFormat$;
import zio.http.logging.LogFormat$Combine$;
import zio.http.logging.LogFormat$FontWrap$;
import zio.http.logging.LogFormat$Format$;
import zio.http.logging.LogFormat$Level$;
import zio.http.logging.LogFormat$Literal$;
import zio.http.logging.LogFormat$Location$;
import zio.http.logging.LogFormat$Msg$;
import zio.http.logging.LogFormat$Tags$;
import zio.http.logging.LogFormat$ThreadInfo$;
import zio.http.logging.LogFormat$Timestamp$;
import zio.http.logging.LogLine;

public interface LogFormat {
    public static LogFormat inlineColored() {
        return LogFormat$.MODULE$.inlineColored();
    }

    public static LogFormat inlineMaximus() {
        return LogFormat$.MODULE$.inlineMaximus();
    }

    public static LogFormat inlineMinimal() {
        return LogFormat$.MODULE$.inlineMinimal();
    }

    public static LogFormat level() {
        return LogFormat$.MODULE$.level();
    }

    public static LogFormat literal(String string) {
        return LogFormat$.MODULE$.literal(string);
    }

    public static LogFormat location() {
        return LogFormat$.MODULE$.location();
    }

    public static LogFormat message() {
        return LogFormat$.MODULE$.message();
    }

    public static int ordinal(LogFormat logFormat) {
        return LogFormat$.MODULE$.ordinal(logFormat);
    }

    public static LogFormat tags() {
        return LogFormat$.MODULE$.tags();
    }

    public static LogFormat threadId() {
        return LogFormat$.MODULE$.threadId();
    }

    public static LogFormat threadName() {
        return LogFormat$.MODULE$.threadName();
    }

    public static LogFormat timestamp(DateTimeFormatter dateTimeFormatter) {
        return LogFormat$.MODULE$.timestamp(dateTimeFormatter);
    }

    public static LogFormat $bar$minus$bar$(LogFormat $this, LogFormat other) {
        return $this.$bar$minus$bar(other);
    }

    default public LogFormat $bar$minus$bar(LogFormat other) {
        return LogFormat$Combine$.MODULE$.apply(this, " ", other);
    }

    public static LogFormat $bslash$bslash$(LogFormat $this, LogFormat other) {
        return $this.$bslash$bslash(other);
    }

    default public LogFormat $bslash$bslash(LogFormat other) {
        return LogFormat$Combine$.MODULE$.apply(this, "\n", other);
    }

    public static LogFormat $less$plus$greater$(LogFormat $this, LogFormat that) {
        return $this.$less$plus$greater(that);
    }

    default public LogFormat $less$plus$greater(LogFormat that) {
        return LogFormat$Combine$.MODULE$.apply(this, "", that);
    }

    public static LogFormat $minus$(LogFormat $this, LogFormat other) {
        return $this.$minus(other);
    }

    default public LogFormat $minus(LogFormat other) {
        return LogFormat$Combine$.MODULE$.apply(this, "-", other);
    }

    public static String apply$(LogFormat $this, LogLine line) {
        return $this.apply(line);
    }

    default public String apply(LogLine line) {
        Stack colorStack = Stack$.MODULE$.empty();
        return LogFormat.loop$1(colorStack, this, line);
    }

    public static LogFormat autoColor$(LogFormat $this) {
        return $this.autoColor();
    }

    default public LogFormat autoColor() {
        return this.format((Function1<String, LogFormat>)(Function1 & Serializable)str -> this.font(LogFormat$.zio$http$logging$LogFormat$$$AutoColorSeq[RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(str.hashCode())) % LogFormat$.zio$http$logging$LogFormat$$$AutoColorSeq.length]));
    }

    public static LogFormat black$(LogFormat $this) {
        return $this.black();
    }

    default public LogFormat black() {
        return this.font(Font$BLACK$.MODULE$);
    }

    public static LogFormat blackB$(LogFormat $this) {
        return $this.blackB();
    }

    default public LogFormat blackB() {
        return this.font(Font$BLACK_B$.MODULE$);
    }

    public static LogFormat blink$(LogFormat $this) {
        return $this.blink();
    }

    default public LogFormat blink() {
        return this.font(Font$BLINK$.MODULE$);
    }

    public static LogFormat blue$(LogFormat $this) {
        return $this.blue();
    }

    default public LogFormat blue() {
        return this.font(Font$BLUE$.MODULE$);
    }

    public static LogFormat blueB$(LogFormat $this) {
        return $this.blueB();
    }

    default public LogFormat blueB() {
        return this.font(Font$BLUE_B$.MODULE$);
    }

    public static LogFormat bold$(LogFormat $this) {
        return $this.bold();
    }

    default public LogFormat bold() {
        return this.font(Font$BOLD$.MODULE$);
    }

    public static LogFormat bracket$(LogFormat $this) {
        return $this.bracket();
    }

    default public LogFormat bracket() {
        return this.transform((Function1<String, String>)(Function1 & Serializable)msg -> new StringBuilder(2).append("[").append((String)msg).append("]").toString());
    }

    public static LogFormat combine$(LogFormat $this, String str, LogFormat other) {
        return $this.combine(str, other);
    }

    default public LogFormat combine(String str, LogFormat other) {
        return LogFormat$Combine$.MODULE$.apply(this, str, other);
    }

    public static LogFormat cyan$(LogFormat $this) {
        return $this.cyan();
    }

    default public LogFormat cyan() {
        return this.font(Font$CYAN$.MODULE$);
    }

    public static LogFormat cyanB$(LogFormat $this) {
        return $this.cyanB();
    }

    default public LogFormat cyanB() {
        return this.font(Font$CYAN_B$.MODULE$);
    }

    public static LogFormat fixed$(LogFormat $this, int n) {
        return $this.fixed(n);
    }

    default public LogFormat fixed(int n) {
        return this.transform((Function1<String, String>)(Function1 & Serializable)_$1 -> StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(_$1), n, ' '));
    }

    public static LogFormat flipColor$(LogFormat $this) {
        return $this.flipColor();
    }

    default public LogFormat flipColor() {
        return this.font(Font$REVERSED$.MODULE$);
    }

    public static LogFormat font$(LogFormat $this, Font font) {
        return $this.font(font);
    }

    default public LogFormat font(Font font) {
        return LogFormat$FontWrap$.MODULE$.apply(font.toAnsiColor(), this);
    }

    public static LogFormat font$(LogFormat $this, String font) {
        return $this.font(font);
    }

    default public LogFormat font(String font) {
        return LogFormat$FontWrap$.MODULE$.apply(font, this);
    }

    public static LogFormat format$(LogFormat $this, Function1 f) {
        return $this.format((Function1<String, LogFormat>)f);
    }

    default public LogFormat format(Function1<String, LogFormat> f) {
        return LogFormat$Format$.MODULE$.apply(this, f);
    }

    public static LogFormat green$(LogFormat $this) {
        return $this.green();
    }

    default public LogFormat green() {
        return this.font(Font$GREEN$.MODULE$);
    }

    public static LogFormat greenB$(LogFormat $this) {
        return $this.greenB();
    }

    default public LogFormat greenB() {
        return this.font(Font$GREEN_B$.MODULE$);
    }

    public static LogFormat invisible$(LogFormat $this) {
        return $this.invisible();
    }

    default public LogFormat invisible() {
        return this.font(Font$INVISIBLE$.MODULE$);
    }

    public static LogFormat lowercase$(LogFormat $this) {
        return $this.lowercase();
    }

    default public LogFormat lowercase() {
        return this.transform((Function1<String, String>)(Function1 & Serializable)_$2 -> _$2.toLowerCase());
    }

    public static LogFormat magenta$(LogFormat $this) {
        return $this.magenta();
    }

    default public LogFormat magenta() {
        return this.font(Font$MAGENTA$.MODULE$);
    }

    public static LogFormat magentaB$(LogFormat $this) {
        return $this.magentaB();
    }

    default public LogFormat magentaB() {
        return this.font(Font$MAGENTA_B$.MODULE$);
    }

    public static LogFormat red$(LogFormat $this) {
        return $this.red();
    }

    default public LogFormat red() {
        return this.font(Font$RED$.MODULE$);
    }

    public static LogFormat redB$(LogFormat $this) {
        return $this.redB();
    }

    default public LogFormat redB() {
        return this.font(Font$RED_B$.MODULE$);
    }

    public static LogFormat reset$(LogFormat $this) {
        return $this.reset();
    }

    default public LogFormat reset() {
        return this.font(Font$RESET$.MODULE$);
    }

    public static LogFormat reversed$(LogFormat $this) {
        return $this.reversed();
    }

    default public LogFormat reversed() {
        return this.font(Font$REVERSED$.MODULE$);
    }

    public static LogFormat transform$(LogFormat $this, Function1 f) {
        return $this.transform((Function1<String, String>)f);
    }

    default public LogFormat transform(Function1<String, String> f) {
        return this.format((Function1<String, LogFormat>)(Function1 & Serializable)s -> LogFormat$Literal$.MODULE$.apply((String)f.apply(s)));
    }

    public static LogFormat trim$(LogFormat $this) {
        return $this.trim();
    }

    default public LogFormat trim() {
        return this.transform((Function1<String, String>)(Function1 & Serializable)_$3 -> _$3.trim());
    }

    public static LogFormat underline$(LogFormat $this) {
        return $this.underline();
    }

    default public LogFormat underline() {
        return this.font(Font$UNDERLINED$.MODULE$);
    }

    public static LogFormat uppercase$(LogFormat $this) {
        return $this.uppercase();
    }

    default public LogFormat uppercase() {
        return this.transform((Function1<String, String>)(Function1 & Serializable)_$4 -> _$4.toUpperCase());
    }

    public static LogFormat white$(LogFormat $this) {
        return $this.white();
    }

    default public LogFormat white() {
        return this.font(Font$WHITE$.MODULE$);
    }

    public static LogFormat whiteB$(LogFormat $this) {
        return $this.whiteB();
    }

    default public LogFormat whiteB() {
        return this.font(Font$WHITE_B$.MODULE$);
    }

    public static LogFormat yellow$(LogFormat $this) {
        return $this.yellow();
    }

    default public LogFormat yellow() {
        return this.font(Font$YELLOW$.MODULE$);
    }

    public static LogFormat yellowB$(LogFormat $this) {
        return $this.yellowB();
    }

    default public LogFormat yellowB() {
        return this.font(Font$YELLOW_B$.MODULE$);
    }

    private static String loop$1$$anonfun$2() {
        return "";
    }

    private static String loop$1(Stack colorStack$1, LogFormat self, LogLine line) {
        LogFormat logFormat;
        while (true) {
            if (LogFormat$Location$.MODULE$.equals(logFormat = self)) {
                return (String)line.sourceLocation().map((Function1 & Serializable)sp2 -> new StringBuilder(1).append(sp2.file()).append(" ").append(sp2.line()).toString()).getOrElse(LogFormat::loop$1$$anonfun$2);
            }
            if (logFormat instanceof Timestamp) {
                DateTimeFormatter dateTimeFormatter;
                Timestamp timestamp = LogFormat$Timestamp$.MODULE$.unapply((Timestamp)logFormat);
                DateTimeFormatter dateFormat = dateTimeFormatter = timestamp._1();
                return line.timestamp().format(dateFormat);
            }
            if (logFormat instanceof ThreadInfo) {
                Function1<Thread, String> function1;
                ThreadInfo threadInfo = LogFormat$ThreadInfo$.MODULE$.unapply((ThreadInfo)logFormat);
                Function1<Thread, String> f = function1 = threadInfo._1();
                return (String)f.apply((Object)line.thread());
            }
            if (LogFormat$Level$.MODULE$.equals(logFormat)) {
                return line.level().name();
            }
            if (logFormat instanceof Combine) {
                Combine combine = LogFormat$Combine$.MODULE$.unapply((Combine)logFormat);
                LogFormat logFormat2 = combine._1();
                String string = combine._2();
                LogFormat logFormat3 = combine._3();
                LogFormat left = logFormat2;
                String sep = string;
                LogFormat right = logFormat3;
                return new StringBuilder(0).append(LogFormat.loop$1(colorStack$1, left, line)).append(sep).append(LogFormat.loop$1(colorStack$1, right, line)).toString();
            }
            if (logFormat instanceof FontWrap) {
                FontWrap fontWrap = LogFormat$FontWrap$.MODULE$.unapply((FontWrap)logFormat);
                String string = fontWrap._1();
                LogFormat logFormat4 = fontWrap._2();
                String font = string;
                LogFormat fmt = logFormat4;
                colorStack$1.push((Object)font);
                String msg = LogFormat.loop$1(colorStack$1, fmt, line);
                String start = font;
                colorStack$1.pop();
                String end = colorStack$1.mkString("");
                return new StringBuilder(4).append(start).append(msg).append("\u001b[0m").append(end).toString();
            }
            if (LogFormat$Msg$.MODULE$.equals(logFormat)) {
                return line.message();
            }
            if (LogFormat$Tags$.MODULE$.equals(logFormat)) {
                return line.tags().mkString(":");
            }
            if (logFormat instanceof Literal) {
                String string;
                Literal literal = LogFormat$Literal$.MODULE$.unapply((Literal)logFormat);
                String msg = string = literal._1();
                return msg;
            }
            if (!(logFormat instanceof Format)) break;
            Format format = LogFormat$Format$.MODULE$.unapply((Format)logFormat);
            LogFormat logFormat5 = format._1();
            Function1<String, LogFormat> function1 = format._2();
            LogFormat fmt = logFormat5;
            Function1<String, LogFormat> f = function1;
            self = (LogFormat)f.apply((Object)LogFormat.loop$1(colorStack$1, fmt, line));
        }
        throw new MatchError((Object)logFormat);
    }

    public static final class Combine
    implements LogFormat,
    Product,
    Serializable {
        private final LogFormat left;
        private final String sep;
        private final LogFormat right;

        public static Combine fromProduct(Product product) {
            return LogFormat$Combine$.MODULE$.fromProduct(product);
        }

        public static Combine unapply(Combine combine) {
            return LogFormat$Combine$.MODULE$.unapply(combine);
        }

        public Combine(LogFormat left, String sep, LogFormat right) {
            this.left = left;
            this.sep = sep;
            this.right = right;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Combine)) return false;
            Combine combine = (Combine)object;
            LogFormat logFormat = this.left();
            LogFormat logFormat2 = combine.left();
            if (logFormat == null) {
                if (logFormat2 != null) {
                    return false;
                }
            } else if (!logFormat.equals(logFormat2)) return false;
            String string = this.sep();
            String string2 = combine.sep();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            LogFormat logFormat3 = this.right();
            LogFormat logFormat4 = combine.right();
            if (logFormat3 == null) {
                if (logFormat4 == null) return true;
                return false;
            } else {
                if (!logFormat3.equals(logFormat4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Combine;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Combine";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "left";
                }
                case 1: {
                    return "sep";
                }
                case 2: {
                    return "right";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogFormat left() {
            return this.left;
        }

        public String sep() {
            return this.sep;
        }

        public LogFormat right() {
            return this.right;
        }

        public Combine copy(LogFormat left, String sep, LogFormat right) {
            return new Combine(left, sep, right);
        }

        public LogFormat copy$default$1() {
            return this.left();
        }

        public String copy$default$2() {
            return this.sep();
        }

        public LogFormat copy$default$3() {
            return this.right();
        }

        public LogFormat _1() {
            return this.left();
        }

        public String _2() {
            return this.sep();
        }

        public LogFormat _3() {
            return this.right();
        }
    }

    public static final class FontWrap
    implements LogFormat,
    Product,
    Serializable {
        private final String font;
        private final LogFormat fmt;

        public static FontWrap fromProduct(Product product) {
            return LogFormat$FontWrap$.MODULE$.fromProduct(product);
        }

        public static FontWrap unapply(FontWrap fontWrap) {
            return LogFormat$FontWrap$.MODULE$.unapply(fontWrap);
        }

        public FontWrap(String font, LogFormat fmt) {
            this.font = font;
            this.fmt = fmt;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FontWrap)) return false;
            FontWrap fontWrap = (FontWrap)object;
            String string = this.font();
            String string2 = fontWrap.font();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            LogFormat logFormat = this.fmt();
            LogFormat logFormat2 = fontWrap.fmt();
            if (logFormat == null) {
                if (logFormat2 == null) return true;
                return false;
            } else {
                if (!logFormat.equals(logFormat2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FontWrap;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FontWrap";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "font";
            }
            if (1 == n2) {
                return "fmt";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String font() {
            return this.font;
        }

        public LogFormat fmt() {
            return this.fmt;
        }

        public FontWrap copy(String font, LogFormat fmt) {
            return new FontWrap(font, fmt);
        }

        public String copy$default$1() {
            return this.font();
        }

        public LogFormat copy$default$2() {
            return this.fmt();
        }

        public String _1() {
            return this.font();
        }

        public LogFormat _2() {
            return this.fmt();
        }
    }

    public static final class Format
    implements LogFormat,
    Product,
    Serializable {
        private final LogFormat fmt;
        private final Function1 f;

        public static Format fromProduct(Product product) {
            return LogFormat$Format$.MODULE$.fromProduct(product);
        }

        public static Format unapply(Format format) {
            return LogFormat$Format$.MODULE$.unapply(format);
        }

        public Format(LogFormat fmt, Function1<String, LogFormat> f) {
            this.fmt = fmt;
            this.f = f;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Format)) return false;
            Format format = (Format)object;
            LogFormat logFormat = this.fmt();
            LogFormat logFormat2 = format.fmt();
            if (logFormat == null) {
                if (logFormat2 != null) {
                    return false;
                }
            } else if (!logFormat.equals(logFormat2)) return false;
            Function1<String, LogFormat> function1 = this.f();
            Function1<String, LogFormat> function12 = format.f();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Format;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Format";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fmt";
            }
            if (1 == n2) {
                return "f";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogFormat fmt() {
            return this.fmt;
        }

        public Function1<String, LogFormat> f() {
            return this.f;
        }

        public Format copy(LogFormat fmt, Function1<String, LogFormat> f) {
            return new Format(fmt, f);
        }

        public LogFormat copy$default$1() {
            return this.fmt();
        }

        public Function1<String, LogFormat> copy$default$2() {
            return this.f();
        }

        public LogFormat _1() {
            return this.fmt();
        }

        public Function1<String, LogFormat> _2() {
            return this.f();
        }
    }

    public static final class Literal
    implements LogFormat,
    Product,
    Serializable {
        private final String lit;

        public static Literal fromProduct(Product product) {
            return LogFormat$Literal$.MODULE$.fromProduct(product);
        }

        public static Literal unapply(Literal literal) {
            return LogFormat$Literal$.MODULE$.unapply(literal);
        }

        public Literal(String lit) {
            this.lit = lit;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Literal)) return false;
            Literal literal = (Literal)object;
            String string = this.lit();
            String string2 = literal.lit();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Literal;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Literal";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "lit";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String lit() {
            return this.lit;
        }

        public Literal copy(String lit) {
            return new Literal(lit);
        }

        public String copy$default$1() {
            return this.lit();
        }

        public String _1() {
            return this.lit();
        }
    }

    public static final class ThreadInfo
    implements LogFormat,
    Product,
    Serializable {
        private final Function1 f;

        public static ThreadInfo fromProduct(Product product) {
            return LogFormat$ThreadInfo$.MODULE$.fromProduct(product);
        }

        public static ThreadInfo unapply(ThreadInfo threadInfo) {
            return LogFormat$ThreadInfo$.MODULE$.unapply(threadInfo);
        }

        public ThreadInfo(Function1<Thread, String> f) {
            this.f = f;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ThreadInfo)) return false;
            ThreadInfo threadInfo = (ThreadInfo)object;
            Function1<Thread, String> function1 = this.f();
            Function1<Thread, String> function12 = threadInfo.f();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ThreadInfo;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ThreadInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "f";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Thread, String> f() {
            return this.f;
        }

        public ThreadInfo copy(Function1<Thread, String> f) {
            return new ThreadInfo(f);
        }

        public Function1<Thread, String> copy$default$1() {
            return this.f();
        }

        public Function1<Thread, String> _1() {
            return this.f();
        }
    }

    public static final class Timestamp
    implements LogFormat,
    Product,
    Serializable {
        private final DateTimeFormatter fmt;

        public static Timestamp fromProduct(Product product) {
            return LogFormat$Timestamp$.MODULE$.fromProduct(product);
        }

        public static Timestamp unapply(Timestamp timestamp) {
            return LogFormat$Timestamp$.MODULE$.unapply(timestamp);
        }

        public Timestamp(DateTimeFormatter fmt) {
            this.fmt = fmt;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Timestamp)) return false;
            Timestamp timestamp = (Timestamp)object;
            DateTimeFormatter dateTimeFormatter = this.fmt();
            DateTimeFormatter dateTimeFormatter2 = timestamp.fmt();
            if (dateTimeFormatter != null) {
                if (!dateTimeFormatter.equals(dateTimeFormatter2)) return false;
                return true;
            }
            if (dateTimeFormatter2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Timestamp;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Timestamp";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fmt";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public DateTimeFormatter fmt() {
            return this.fmt;
        }

        public Timestamp copy(DateTimeFormatter fmt) {
            return new Timestamp(fmt);
        }

        public DateTimeFormatter copy$default$1() {
            return this.fmt();
        }

        public DateTimeFormatter _1() {
            return this.fmt();
        }
    }
}

