/*
 * Decompiled with CFR 0.152.
 */
package zio.flow.operation.http;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import zio.CanFail$;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.flow.operation.http.API;
import zio.flow.operation.http.Body;
import zio.flow.operation.http.ClientInterpreter;
import zio.flow.operation.http.ContentType;
import zio.flow.operation.http.ContentType$json$;
import zio.flow.operation.http.ContentType$x$minuswww$minusform$minusurlencoded$;
import zio.flow.operation.http.FormUrlEncodedEncoder$;
import zio.flow.operation.http.Header;
import zio.flow.operation.http.HttpFailure;
import zio.flow.operation.http.HttpFailure$FailedToSendRequest$;
import zio.flow.operation.http.Path;
import zio.flow.operation.http.Query;
import zio.flow.operation.http.RequestInput;
import zio.http.Body$;
import zio.http.Header;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$;
import zio.http.ZClient;
import zio.http.package$;
import zio.schema.codec.JsonCodec;

public final class ClientInterpreter$ {
    public static ClientInterpreter$ MODULE$;

    static {
        new ClientInterpreter$();
    }

    /*
     * WARNING - void declaration
     */
    public <Input, Output> ZIO<ZClient<Object, zio.http.Body, Throwable, Response>, HttpFailure, Response> interpret(String host, API<Input, Output> api, Input input) {
        void var9_9;
        void var8_8;
        void var7_7;
        Method method = api.method().toZioHttpMethod();
        ClientInterpreter.RequestState state = new ClientInterpreter.RequestState();
        this.parseUrl(api.requestInput(), state, input);
        Tuple3<String, Map<String, String>, Option<Chunk<Object>>> tuple3 = state.result();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        String url = (String)tuple3._1();
        Map headers = (Map)tuple3._2();
        Option body = (Option)tuple3._3();
        void url2 = var7_7;
        void headers2 = var8_8;
        zio.http.Body data2 = (zio.http.Body)var9_9.fold((Function0 & Serializable & scala.Serializable)() -> Body$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)data -> Body$.MODULE$.fromChunk(data));
        return ZIO$.MODULE$.fromEither(() -> ClientInterpreter$.$anonfun$interpret$3(host, (String)url2), (Object)"zio.flow.operation.http.ClientInterpreter.interpret(ClientInterpreter.scala:19)").flatMap(arg_0 -> ClientInterpreter$.$anonfun$interpret$4(method, (Map)headers2, data2, arg_0), (Object)"zio.flow.operation.http.ClientInterpreter.interpret(ClientInterpreter.scala:20)").mapError((Function1)HttpFailure$FailedToSendRequest$.MODULE$, CanFail$.MODULE$.canFail(), (Object)"zio.flow.operation.http.ClientInterpreter.interpret(ClientInterpreter.scala:34)");
    }

    public <Params> Object parseUrl(RequestInput<Params> requestInput, ClientInterpreter.RequestState state, Params params) {
        while (requestInput instanceof RequestInput.ZipWith) {
            RequestInput.ZipWith zipWith = (RequestInput.ZipWith)requestInput;
            RequestInput left = zipWith.left();
            RequestInput right = zipWith.right();
            Tuple2 tuple2 = zipWith.zipper().unzip(params);
            if (tuple2 != null) {
                Object a = tuple2._1();
                Object b = tuple2._2();
                this.parseUrl(left, state, a);
                params = b;
                requestInput = right;
                continue;
            }
            throw new MatchError(null);
        }
        if (requestInput instanceof Header) {
            Header header = (Header)requestInput;
            return this.parseHeaders(header, state, params);
        }
        if (requestInput instanceof Query) {
            Query query = (Query)requestInput;
            return this.parseQuery(query, state, params);
        }
        if (requestInput instanceof Path) {
            Path path = (Path)requestInput;
            this.parsePath(path, state, params);
            return BoxedUnit.UNIT;
        }
        if (requestInput instanceof Body) {
            Body body = (Body)requestInput;
            this.parseBody(body, state, params);
            return BoxedUnit.UNIT;
        }
        throw new MatchError(requestInput);
    }

    private <Params> void parsePath(Path<Params> route, ClientInterpreter.RequestState state, Params params) {
        while (route instanceof Path.ZipWith) {
            Path.ZipWith zipWith = (Path.ZipWith)route;
            Path left = zipWith.left();
            Path right = zipWith.right();
            Tuple2 tuple2 = zipWith.zipper().unzip(params);
            if (tuple2 != null) {
                Object a = tuple2._1();
                Object b = tuple2._2();
                this.parsePath(left, state, a);
                params = b;
                route = right;
                continue;
            }
            throw new MatchError(null);
        }
        if (route instanceof Path.Literal) {
            String literal = ((Path.Literal)route).string();
            state.addPath(literal);
            return;
        }
        if (route instanceof Path.Match) {
            state.addPath(new StringBuilder(1).append("/").append(params.toString()).toString());
            return;
        }
        throw new MatchError(route);
    }

    private <Params> Object parseQuery(Query<Params> query, ClientInterpreter.RequestState state, Params params) {
        block5: {
            while (true) {
                if (query instanceof Query.SingleParam) {
                    String name = ((Query.SingleParam)query).name();
                    return state.addQuery(name, params.toString());
                }
                if (query instanceof Query.Optional) {
                    Query p = ((Query.Optional)query).params();
                    Option option = (Option)params;
                    if (option instanceof Some) {
                        Object params2 = ((Some)option).value();
                        params = params2;
                        query = p;
                        continue;
                    }
                    if (None$.MODULE$.equals(option)) {
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)option);
                }
                if (!(query instanceof Query.ZipWith)) break block5;
                Query.ZipWith zipWith = (Query.ZipWith)query;
                Query left = zipWith.left();
                Query right = zipWith.right();
                Tuple2 tuple2 = zipWith.zipper().unzip(params);
                if (tuple2 == null) break;
                Object a = tuple2._1();
                Object b = tuple2._2();
                this.parseQuery(left, state, a);
                params = b;
                query = right;
            }
            throw new MatchError(null);
        }
        throw new MatchError(query);
    }

    private <Params> Object parseHeaders(Header<Params> headers, ClientInterpreter.RequestState state, Params params) {
        block5: {
            Option option;
            while (true) {
                if (headers instanceof Header.ZipWith) {
                    Header.ZipWith zipWith = (Header.ZipWith)headers;
                    Header left = zipWith.left();
                    Header right = zipWith.right();
                    Tuple2 tuple2 = zipWith.zipper().unzip(params);
                    if (tuple2 != null) {
                        Object a = tuple2._1();
                        Object b = tuple2._2();
                        this.parseHeaders(left, state, a);
                        params = b;
                        headers = right;
                        continue;
                    }
                    throw new MatchError(null);
                }
                if (!(headers instanceof Header.Optional)) break block5;
                Header headers2 = ((Header.Optional)headers).headers();
                option = (Option)params;
                if (!(option instanceof Some)) break;
                Object params2 = ((Some)option).value();
                params = params2;
                headers = headers2;
            }
            if (None$.MODULE$.equals(option)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        }
        if (headers instanceof Header.SingleHeader) {
            String name = ((Header.SingleHeader)headers).name();
            return state.addHeader(name, params.toString());
        }
        throw new MatchError(headers);
    }

    private <Params> void parseBody(Body<Params> body, ClientInterpreter.RequestState state, Params params) {
        ContentType contentType = body.contentType();
        if (ContentType$json$.MODULE$.equals(contentType)) {
            state.setBody((Chunk<Object>)JsonCodec.JsonEncoder$.MODULE$.encode(body.schema(), params), "application/json");
            return;
        }
        if (ContentType$x$minuswww$minusform$minusurlencoded$.MODULE$.equals(contentType)) {
            state.setBody((Chunk<Object>)((Chunk)FormUrlEncodedEncoder$.MODULE$.encode(body.schema()).apply(params)), "application/x-www-form-urlencoded");
            return;
        }
        throw new MatchError((Object)contentType);
    }

    public static final /* synthetic */ Either $anonfun$interpret$3(String host$1, String url$1) {
        return URL$.MODULE$.decode(new StringBuilder(0).append(host$1).append(url$1).toString());
    }

    public static final /* synthetic */ ZIO $anonfun$interpret$4(Method method$1, Map headers$1, zio.http.Body data$1, URL url) {
        Headers x$3 = Headers$.MODULE$.apply((Iterable)headers$1.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                String value = (String)x0$1._2();
                return new Header.Custom((CharSequence)name, (CharSequence)value);
            }
            throw new MatchError(null);
        }, List$.MODULE$.canBuildFrom()));
        Version x$5 = Version$.MODULE$.HTTP$div1$u002E1();
        None$ x$6 = None$.MODULE$;
        return package$.MODULE$.Client().request(new Request(data$1, x$3, method$1, url, x$5, (Option)x$6), (Object)"zio.flow.operation.http.ClientInterpreter.interpret(ClientInterpreter.scala:22)");
    }

    private ClientInterpreter$() {
        MODULE$ = this;
    }
}

