/*
 * Decompiled with CFR 0.152.
 */
package zio.flow.debug;

import java.time.Duration;
import java.time.Instant;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.flow.Activity;
import zio.flow.Remote;
import zio.flow.RemoteVariableReference;
import zio.flow.ZFlow;
import zio.flow.ZFlow$;
import zio.flow.ZFlow$Die$;
import zio.flow.ZFlow$Now$;
import zio.flow.ZFlow$Random$;
import zio.flow.ZFlow$RandomUUID$;
import zio.flow.ZFlow$RetryUntil$;
import zio.flow.package$BindingName$;
import zio.flow.package$ConfigKey$;
import zio.flow.package$RemoteVariableName$;
import zio.flow.remote.BinaryOperators;
import zio.flow.remote.UnaryOperators;

public final class PrettyPrint$ {
    public static PrettyPrint$ MODULE$;

    static {
        new PrettyPrint$();
    }

    public <A> String prettyPrintRemote(Remote<A> remote) {
        StringBuilder builder = new StringBuilder();
        this.prettyPrintRemote(remote, builder, 0);
        return builder.toString();
    }

    public <R, E, A> String prettyPrintFlow(ZFlow<R, E, A> flow) {
        StringBuilder builder = new StringBuilder();
        this.prettyPrintFlow(flow, builder, 0);
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public <A> void prettyPrintRemote(Remote<A> remote, StringBuilder builder, int indent) {
        if (remote instanceof Remote.Literal) {
            Either either = ((Remote.Literal)remote).value().toTypedValue(ZFlow$.MODULE$.schemaAny());
            if (either instanceof Left) {
                String value = (String)((Left)either).value();
                builder.append(value.toString());
                return;
            }
            if (either instanceof Right) {
                ZFlow flow = (ZFlow)((Right)either).value();
                this.prettyPrintFlow(flow, builder, indent);
                return;
            }
            throw new MatchError((Object)either);
        }
        if (remote instanceof Remote.Fail) {
            String message = ((Remote.Fail)remote).message();
            builder.append("fail ");
            builder.append(message);
            return;
        }
        if (remote instanceof Remote.Debug) {
            Remote.Debug debug = (Remote.Debug)remote;
            Remote inner = debug.inner();
            String message = debug.message();
            Remote.Debug.DebugMode debugMode = debug.debugMode();
            builder.append(new java.lang.StringBuilder(2).append(debugMode).append("(").append(message).append(")").toString());
            this.prettyPrintRemote(inner);
            return;
        }
        if (remote instanceof Remote.Flow) {
            ZFlow flow = ((Remote.Flow)remote).flow();
            builder.append("flow");
            this.prettyPrintFlow(flow, builder, indent + 2);
            return;
        }
        if (remote instanceof Remote.Nested) {
            Remote remote2 = ((Remote.Nested)remote).remote();
            builder.append("nested ");
            this.prettyPrintRemote(remote2, builder, indent);
            return;
        }
        if (remote instanceof Remote.VariableReference) {
            RemoteVariableReference ref = ((Remote.VariableReference)remote).ref();
            builder.append("[[ref ");
            builder.append((String)package$RemoteVariableName$.MODULE$.unwrap(ref.name()));
            builder.append("]]");
            return;
        }
        if (remote instanceof Remote.Ignore) {
            builder.append("ignore");
            return;
        }
        if (remote instanceof Remote.Variable) {
            Object identifier = ((Remote.Variable)remote).identifier();
            builder.append("[[");
            builder.append((String)package$RemoteVariableName$.MODULE$.unwrap(identifier));
            builder.append("]]");
            return;
        }
        if (remote instanceof Remote.Config) {
            Object key = ((Remote.Config)remote).key();
            builder.append("[[cfg:");
            builder.append((String)package$ConfigKey$.MODULE$.unwrap(key));
            builder.append("]]");
            return;
        }
        if (remote instanceof Remote.Unbound) {
            Object identifier = ((Remote.Unbound)remote).identifier();
            builder.append("<");
            builder.append(package$BindingName$.MODULE$.unwrap(identifier));
            builder.append(">");
            return;
        }
        if (remote instanceof Remote.UnboundRemoteFunction) {
            Remote.UnboundRemoteFunction unboundRemoteFunction = (Remote.UnboundRemoteFunction)remote;
            Remote.Unbound input = unboundRemoteFunction.input();
            Remote result = unboundRemoteFunction.result();
            this.prettyPrintRemote(input, builder, indent);
            builder.append(" => ");
            this.prettyPrintRemote(result, builder, indent);
            return;
        }
        if (remote instanceof Remote.Bind) {
            Remote.Bind bind = (Remote.Bind)remote;
            Remote.Unbound unbound = bind.unbound();
            Remote value = bind.value();
            Remote inner = bind.inner();
            this.prettyPrintRemote(unbound, builder, indent);
            builder.append(" bound to ");
            this.prettyPrintRemote(value, builder, indent);
            builder.append(" then ");
            this.prettyPrintRemote(inner, builder, indent);
            return;
        }
        if (remote instanceof Remote.Unary) {
            Remote.Unary unary = (Remote.Unary)remote;
            Remote value = unary.value();
            UnaryOperators operator = unary.operator();
            builder.append(operator);
            this.prettyPrintRemote(value, builder, indent);
            return;
        }
        if (remote instanceof Remote.Binary) {
            Remote.Binary binary = (Remote.Binary)remote;
            Remote left = binary.left();
            Remote right = binary.right();
            BinaryOperators operator = binary.operator();
            this.prettyPrintRemote(left, builder, indent);
            builder.append(operator);
            this.prettyPrintRemote(right, builder, indent);
            return;
        }
        if (remote instanceof Remote.RemoteEither) {
            Either either = ((Remote.RemoteEither)remote).either();
            if (either instanceof Left) {
                Remote value = (Remote)((Left)either).value();
                builder.append("left[");
                this.prettyPrintRemote(value, builder, indent);
                builder.append("]");
                return;
            }
            if (either instanceof Right) {
                Remote value = (Remote)((Right)either).value();
                builder.append("right[");
                this.prettyPrintRemote(value, builder, indent);
                builder.append("]");
                return;
            }
            throw new MatchError(either);
        }
        if (remote instanceof Remote.FoldEither) {
            Remote.FoldEither foldEither = (Remote.FoldEither)remote;
            Remote either = foldEither.either();
            Remote.UnboundRemoteFunction left = foldEither.left();
            Remote.UnboundRemoteFunction right = foldEither.right();
            builder.append("either ");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(either, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            builder.append("on left: ");
            this.prettyPrintRemote(left, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            builder.append("on right: ");
            this.prettyPrintRemote(right, builder, indent + 2);
            return;
        }
        if (remote instanceof Remote.Try) {
            Either either = ((Remote.Try)remote).either();
            if (either instanceof Left) {
                Remote value = (Remote)((Left)either).value();
                builder.append("failure[");
                this.prettyPrintRemote(value, builder, indent);
                builder.append("]");
                return;
            }
            if (either instanceof Right) {
                Remote value = (Remote)((Right)either).value();
                builder.append("success[");
                this.prettyPrintRemote(value, builder, indent);
                builder.append("]");
                return;
            }
            throw new MatchError(either);
        }
        if (remote instanceof Remote.Tuple2) {
            Remote.Tuple2 tuple2 = (Remote.Tuple2)remote;
            Remote t1 = tuple2.t1();
            Remote t2 = tuple2.t2();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple3) {
            Remote.Tuple3 tuple3 = (Remote.Tuple3)remote;
            Remote t1 = tuple3.t1();
            Remote t2 = tuple3.t2();
            Remote t3 = tuple3.t3();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple4) {
            Remote.Tuple4 tuple4 = (Remote.Tuple4)remote;
            Remote t1 = tuple4.t1();
            Remote t2 = tuple4.t2();
            Remote t3 = tuple4.t3();
            Remote t4 = tuple4.t4();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple5) {
            Remote.Tuple5 tuple5 = (Remote.Tuple5)remote;
            Remote t1 = tuple5.t1();
            Remote t2 = tuple5.t2();
            Remote t3 = tuple5.t3();
            Remote t4 = tuple5.t4();
            Remote t5 = tuple5.t5();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple6) {
            Remote.Tuple6 tuple6 = (Remote.Tuple6)remote;
            Remote t1 = tuple6.t1();
            Remote t2 = tuple6.t2();
            Remote t3 = tuple6.t3();
            Remote t4 = tuple6.t4();
            Remote t5 = tuple6.t5();
            Remote t6 = tuple6.t6();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple7) {
            Remote.Tuple7 tuple7 = (Remote.Tuple7)remote;
            Remote t1 = tuple7.t1();
            Remote t2 = tuple7.t2();
            Remote t3 = tuple7.t3();
            Remote t4 = tuple7.t4();
            Remote t5 = tuple7.t5();
            Remote t6 = tuple7.t6();
            Remote t7 = tuple7.t7();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple8) {
            Remote.Tuple8 tuple8 = (Remote.Tuple8)remote;
            Remote t1 = tuple8.t1();
            Remote t2 = tuple8.t2();
            Remote t3 = tuple8.t3();
            Remote t4 = tuple8.t4();
            Remote t5 = tuple8.t5();
            Remote t6 = tuple8.t6();
            Remote t7 = tuple8.t7();
            Remote t8 = tuple8.t8();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple9) {
            Remote.Tuple9 tuple9 = (Remote.Tuple9)remote;
            Remote t1 = tuple9.t1();
            Remote t2 = tuple9.t2();
            Remote t3 = tuple9.t3();
            Remote t4 = tuple9.t4();
            Remote t5 = tuple9.t5();
            Remote t6 = tuple9.t6();
            Remote t7 = tuple9.t7();
            Remote t8 = tuple9.t8();
            Remote t9 = tuple9.t9();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple10) {
            Remote.Tuple10 tuple10 = (Remote.Tuple10)remote;
            Remote t1 = tuple10.t1();
            Remote t2 = tuple10.t2();
            Remote t3 = tuple10.t3();
            Remote t4 = tuple10.t4();
            Remote t5 = tuple10.t5();
            Remote t6 = tuple10.t6();
            Remote t7 = tuple10.t7();
            Remote t8 = tuple10.t8();
            Remote t9 = tuple10.t9();
            Remote t10 = tuple10.t10();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple11) {
            Remote.Tuple11 tuple11 = (Remote.Tuple11)remote;
            Remote t1 = tuple11.t1();
            Remote t2 = tuple11.t2();
            Remote t3 = tuple11.t3();
            Remote t4 = tuple11.t4();
            Remote t5 = tuple11.t5();
            Remote t6 = tuple11.t6();
            Remote t7 = tuple11.t7();
            Remote t8 = tuple11.t8();
            Remote t9 = tuple11.t9();
            Remote t10 = tuple11.t10();
            Remote t11 = tuple11.t11();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple12) {
            Remote.Tuple12 tuple12 = (Remote.Tuple12)remote;
            Remote t1 = tuple12.t1();
            Remote t2 = tuple12.t2();
            Remote t3 = tuple12.t3();
            Remote t4 = tuple12.t4();
            Remote t5 = tuple12.t5();
            Remote t6 = tuple12.t6();
            Remote t7 = tuple12.t7();
            Remote t8 = tuple12.t8();
            Remote t9 = tuple12.t9();
            Remote t10 = tuple12.t10();
            Remote t11 = tuple12.t11();
            Remote t12 = tuple12.t12();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t12, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple13) {
            Remote.Tuple13 tuple13 = (Remote.Tuple13)remote;
            Remote t1 = tuple13.t1();
            Remote t2 = tuple13.t2();
            Remote t3 = tuple13.t3();
            Remote t4 = tuple13.t4();
            Remote t5 = tuple13.t5();
            Remote t6 = tuple13.t6();
            Remote t7 = tuple13.t7();
            Remote t8 = tuple13.t8();
            Remote t9 = tuple13.t9();
            Remote t10 = tuple13.t10();
            Remote t11 = tuple13.t11();
            Remote t12 = tuple13.t12();
            Remote t13 = tuple13.t13();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t13, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple14) {
            Remote.Tuple14 tuple14 = (Remote.Tuple14)remote;
            Remote t1 = tuple14.t1();
            Remote t2 = tuple14.t2();
            Remote t3 = tuple14.t3();
            Remote t4 = tuple14.t4();
            Remote t5 = tuple14.t5();
            Remote t6 = tuple14.t6();
            Remote t7 = tuple14.t7();
            Remote t8 = tuple14.t8();
            Remote t9 = tuple14.t9();
            Remote t10 = tuple14.t10();
            Remote t11 = tuple14.t11();
            Remote t12 = tuple14.t12();
            Remote t13 = tuple14.t13();
            Remote t14 = tuple14.t14();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t14, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple15) {
            Remote.Tuple15 tuple15 = (Remote.Tuple15)remote;
            Remote t1 = tuple15.t1();
            Remote t2 = tuple15.t2();
            Remote t3 = tuple15.t3();
            Remote t4 = tuple15.t4();
            Remote t5 = tuple15.t5();
            Remote t6 = tuple15.t6();
            Remote t7 = tuple15.t7();
            Remote t8 = tuple15.t8();
            Remote t9 = tuple15.t9();
            Remote t10 = tuple15.t10();
            Remote t11 = tuple15.t11();
            Remote t12 = tuple15.t12();
            Remote t13 = tuple15.t13();
            Remote t14 = tuple15.t14();
            Remote t15 = tuple15.t15();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t14, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t15, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple16) {
            Remote.Tuple16 tuple16 = (Remote.Tuple16)remote;
            Remote t1 = tuple16.t1();
            Remote t2 = tuple16.t2();
            Remote t3 = tuple16.t3();
            Remote t4 = tuple16.t4();
            Remote t5 = tuple16.t5();
            Remote t6 = tuple16.t6();
            Remote t7 = tuple16.t7();
            Remote t8 = tuple16.t8();
            Remote t9 = tuple16.t9();
            Remote t10 = tuple16.t10();
            Remote t11 = tuple16.t11();
            Remote t12 = tuple16.t12();
            Remote t13 = tuple16.t13();
            Remote t14 = tuple16.t14();
            Remote t15 = tuple16.t15();
            Remote t16 = tuple16.t16();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t14, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t15, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t16, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple17) {
            Remote.Tuple17 tuple17 = (Remote.Tuple17)remote;
            Remote t1 = tuple17.t1();
            Remote t2 = tuple17.t2();
            Remote t3 = tuple17.t3();
            Remote t4 = tuple17.t4();
            Remote t5 = tuple17.t5();
            Remote t6 = tuple17.t6();
            Remote t7 = tuple17.t7();
            Remote t8 = tuple17.t8();
            Remote t9 = tuple17.t9();
            Remote t10 = tuple17.t10();
            Remote t11 = tuple17.t11();
            Remote t12 = tuple17.t12();
            Remote t13 = tuple17.t13();
            Remote t14 = tuple17.t14();
            Remote t15 = tuple17.t15();
            Remote t16 = tuple17.t16();
            Remote t17 = tuple17.t17();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t14, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t15, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t16, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t17, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple18) {
            Remote.Tuple18 tuple18 = (Remote.Tuple18)remote;
            Remote t1 = tuple18.t1();
            Remote t2 = tuple18.t2();
            Remote t3 = tuple18.t3();
            Remote t4 = tuple18.t4();
            Remote t5 = tuple18.t5();
            Remote t6 = tuple18.t6();
            Remote t7 = tuple18.t7();
            Remote t8 = tuple18.t8();
            Remote t9 = tuple18.t9();
            Remote t10 = tuple18.t10();
            Remote t11 = tuple18.t11();
            Remote t12 = tuple18.t12();
            Remote t13 = tuple18.t13();
            Remote t14 = tuple18.t14();
            Remote t15 = tuple18.t15();
            Remote t16 = tuple18.t16();
            Remote t17 = tuple18.t17();
            Remote t18 = tuple18.t18();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t14, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t15, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t16, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t17, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t18, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple19) {
            Remote.Tuple19 tuple19 = (Remote.Tuple19)remote;
            Remote t1 = tuple19.t1();
            Remote t2 = tuple19.t2();
            Remote t3 = tuple19.t3();
            Remote t4 = tuple19.t4();
            Remote t5 = tuple19.t5();
            Remote t6 = tuple19.t6();
            Remote t7 = tuple19.t7();
            Remote t8 = tuple19.t8();
            Remote t9 = tuple19.t9();
            Remote t10 = tuple19.t10();
            Remote t11 = tuple19.t11();
            Remote t12 = tuple19.t12();
            Remote t13 = tuple19.t13();
            Remote t14 = tuple19.t14();
            Remote t15 = tuple19.t15();
            Remote t16 = tuple19.t16();
            Remote t17 = tuple19.t17();
            Remote t18 = tuple19.t18();
            Remote t19 = tuple19.t19();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t14, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t15, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t16, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t17, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t18, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t19, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple20) {
            void t20;
            void t19;
            void t18;
            void t17;
            void t16;
            void t15;
            void t14;
            void t13;
            void t12;
            void t11;
            void t10;
            void t9;
            void t8;
            void t7;
            Remote.Tuple20 tuple20 = (Remote.Tuple20)remote;
            Remote t1 = tuple20.t1();
            Remote t2 = tuple20.t2();
            Remote t3 = tuple20.t3();
            Remote t4 = tuple20.t4();
            Remote t5 = tuple20.t5();
            Remote t6 = tuple20.t6();
            Remote remote3 = tuple20.t7();
            Remote remote4 = tuple20.t8();
            Remote remote5 = tuple20.t9();
            Remote remote6 = tuple20.t10();
            Remote remote7 = tuple20.t11();
            Remote remote8 = tuple20.t12();
            Remote remote9 = tuple20.t13();
            Remote remote10 = tuple20.t14();
            Remote remote11 = tuple20.t15();
            Remote remote12 = tuple20.t16();
            Remote remote13 = tuple20.t17();
            Remote remote14 = tuple20.t18();
            Remote remote15 = tuple20.t19();
            Remote remote16 = tuple20.t20();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote(t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t14, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t15, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t16, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t17, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t18, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t19, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t20, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple21) {
            void t21;
            void t20;
            void t19;
            void t18;
            void t17;
            void t16;
            void t15;
            void t14;
            void t13;
            void t12;
            void t11;
            void t10;
            void t9;
            void t8;
            void t7;
            void t6;
            void t5;
            void t4;
            void t3;
            void t2;
            void t1;
            Remote.Tuple21 tuple21 = (Remote.Tuple21)remote;
            Remote remote17 = tuple21.t1();
            Remote remote18 = tuple21.t2();
            Remote remote19 = tuple21.t3();
            Remote remote20 = tuple21.t4();
            Remote remote21 = tuple21.t5();
            Remote remote22 = tuple21.t6();
            Remote remote23 = tuple21.t7();
            Remote remote24 = tuple21.t8();
            Remote remote25 = tuple21.t9();
            Remote remote26 = tuple21.t10();
            Remote remote27 = tuple21.t11();
            Remote remote28 = tuple21.t12();
            Remote remote29 = tuple21.t13();
            Remote remote30 = tuple21.t14();
            Remote remote31 = tuple21.t15();
            Remote remote32 = tuple21.t16();
            Remote remote33 = tuple21.t17();
            Remote remote34 = tuple21.t18();
            Remote remote35 = tuple21.t19();
            Remote remote36 = tuple21.t20();
            Remote remote37 = tuple21.t21();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t14, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t15, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t16, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t17, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t18, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t19, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t20, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t21, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Tuple22) {
            void t22;
            void t21;
            void t20;
            void t19;
            void t18;
            void t17;
            void t16;
            void t15;
            void t14;
            void t13;
            void t12;
            void t11;
            void t10;
            void t9;
            void t8;
            void t7;
            void t6;
            void t5;
            void t4;
            void t3;
            void t2;
            void t1;
            Remote.Tuple22 tuple22 = (Remote.Tuple22)remote;
            Remote remote38 = tuple22.t1();
            Remote remote39 = tuple22.t2();
            Remote remote40 = tuple22.t3();
            Remote remote41 = tuple22.t4();
            Remote remote42 = tuple22.t5();
            Remote remote43 = tuple22.t6();
            Remote remote44 = tuple22.t7();
            Remote remote45 = tuple22.t8();
            Remote remote46 = tuple22.t9();
            Remote remote47 = tuple22.t10();
            Remote remote48 = tuple22.t11();
            Remote remote49 = tuple22.t12();
            Remote remote50 = tuple22.t13();
            Remote remote51 = tuple22.t14();
            Remote remote52 = tuple22.t15();
            Remote remote53 = tuple22.t16();
            Remote remote54 = tuple22.t17();
            Remote remote55 = tuple22.t18();
            Remote remote56 = tuple22.t19();
            Remote remote57 = tuple22.t20();
            Remote remote58 = tuple22.t21();
            Remote remote59 = tuple22.t22();
            builder.append("(");
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t1, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t2, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t3, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t4, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t5, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t6, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t7, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t8, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t9, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t10, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t11, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t12, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t13, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t14, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t15, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t16, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t17, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t18, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t19, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t20, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t21, builder, indent + 2);
            PrettyPrint$.nl$1(indent + 2, builder);
            this.prettyPrintRemote((Remote<A>)t22, builder, indent + 2);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.TupleAccess) {
            void n;
            void tuple;
            Remote.TupleAccess tupleAccess = (Remote.TupleAccess)remote;
            Remote remote60 = tupleAccess.tuple();
            int n2 = tupleAccess.n();
            this.prettyPrintRemote((Remote<A>)tuple, builder, indent);
            builder.append("(");
            builder.append((int)n);
            builder.append(")");
            return;
        }
        if (remote instanceof Remote.Branch) {
            void f;
            void t;
            void p;
            Remote.Branch branch = (Remote.Branch)remote;
            Remote<Object> remote61 = branch.predicate();
            Remote remote62 = branch.ifTrue();
            Remote remote63 = branch.ifFalse();
            builder.append("if(");
            this.prettyPrintRemote((Remote<A>)p, builder, indent);
            builder.append(")");
            this.prettyPrintRemote((Remote<A>)t, builder, indent);
            builder.append(" else ");
            this.prettyPrintRemote((Remote<A>)f, builder, indent);
            return;
        }
        if (remote instanceof Remote.StringToCharList) {
            void x;
            Remote<String> remote64 = ((Remote.StringToCharList)remote).remoteString();
            this.prettyPrintRemote((Remote<A>)x, builder, indent);
            return;
        }
        if (remote instanceof Remote.CharListToString) {
            void x;
            Remote<List<Object>> remote65 = ((Remote.CharListToString)remote).remoteString();
            this.prettyPrintRemote((Remote<A>)x, builder, indent);
            return;
        }
        if (remote instanceof Remote.Equal) {
            void right;
            void left;
            Remote.Equal equal = (Remote.Equal)remote;
            Remote remote66 = equal.left();
            Remote remote67 = equal.right();
            this.prettyPrintRemote((Remote<A>)left, builder, indent);
            builder.append("==");
            this.prettyPrintRemote((Remote<A>)right, builder, indent);
            return;
        }
        if (remote instanceof Remote.Fold) {
            void body;
            void initial;
            void list;
            Remote.Fold fold = (Remote.Fold)remote;
            Remote remote68 = fold.list();
            Remote remote69 = fold.initial();
            Remote.UnboundRemoteFunction unboundRemoteFunction = fold.body();
            builder.append("RemoteFold[");
            this.prettyPrintRemote((Remote<A>)list, builder, indent + 2);
            this.prettyPrintRemote((Remote<A>)initial, builder, indent + 2);
            this.prettyPrintRemote((Remote<A>)body, builder, indent + 2);
            builder.append("]");
            return;
        }
        if (remote instanceof Remote.Cons) {
            void list;
            void head;
            Remote.Cons cons = (Remote.Cons)remote;
            Remote remote70 = cons.list();
            Remote remote71 = cons.head();
            this.prettyPrintRemote((Remote<A>)head, builder, indent);
            builder.append(" :: ");
            this.prettyPrintRemote((Remote<A>)list, builder, indent);
            return;
        }
        if (remote instanceof Remote.UnCons) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.DurationFromAmount) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.Lazy) {
            void value;
            Function0 function0 = ((Remote.Lazy)remote).value();
            this.prettyPrintRemote((Remote)value.apply(), builder, indent);
            return;
        }
        if (remote instanceof Remote.RemoteSome) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.FoldOption) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.Recurse) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.RecurseWith) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.SetToList) {
            void set;
            Remote remote72 = ((Remote.SetToList)remote).set();
            this.prettyPrintRemote((Remote<A>)set);
            builder.append(".toList");
            return;
        }
        if (remote instanceof Remote.ListToSet) {
            void list;
            Remote remote73 = ((Remote.ListToSet)remote).list();
            this.prettyPrintRemote((Remote<A>)list);
            builder.append(".toSet");
            return;
        }
        if (remote instanceof Remote.MapToList) {
            void map;
            Remote remote74 = ((Remote.MapToList)remote).set();
            this.prettyPrintRemote((Remote<A>)map);
            builder.append(".toList");
            return;
        }
        if (remote instanceof Remote.ListToMap) {
            void list;
            Remote remote75 = ((Remote.ListToMap)remote).list();
            this.prettyPrintRemote((Remote<A>)list);
            builder.append(".toMap");
            return;
        }
        if (remote instanceof Remote.ListToString) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.OpticGet) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.OpticSet) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (remote instanceof Remote.SortList) {
            void list;
            Remote remote76 = ((Remote.SortList)remote).list();
            this.prettyPrintRemote((Remote<A>)list);
            builder.append(".sort");
            return;
        }
        throw new MatchError(remote);
    }

    public <R, E, A> void prettyPrintFlow(ZFlow<R, E, A> flow, StringBuilder builder, int indent) {
        PrettyPrint$.nl$2(indent, builder);
        if (flow instanceof ZFlow.Return) {
            Remote value = ((ZFlow.Return)flow).value();
            builder.append("return (");
            this.prettyPrintRemote(value, builder, indent);
            builder.append(")");
            return;
        }
        if (ZFlow$Now$.MODULE$.equals(flow)) {
            builder.append("now");
            return;
        }
        if (flow instanceof ZFlow.WaitTill) {
            Remote<Instant> time = ((ZFlow.WaitTill)flow).time();
            builder.append("waitTill (");
            this.prettyPrintRemote(time, builder, indent);
            builder.append(")");
            return;
        }
        if (flow instanceof ZFlow.Read) {
            Remote svar = ((ZFlow.Read)flow).svar();
            builder.append("read (");
            this.prettyPrintRemote(svar, builder, indent);
            builder.append(")");
            return;
        }
        if (flow instanceof ZFlow.Modify) {
            ZFlow.Modify modify = (ZFlow.Modify)flow;
            Remote svar = modify.svar();
            Remote.UnboundRemoteFunction f = modify.f();
            builder.append("modify ");
            this.prettyPrintRemote(svar, builder, indent);
            builder.append(" with ");
            this.prettyPrintRemote(f, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.Fold) {
            ZFlow.Fold fold = (ZFlow.Fold)flow;
            ZFlow value = fold.value();
            builder.append("fold\n");
            this.prettyPrintFlow(value, builder, indent + 2);
            PrettyPrint$.nl$2(indent + 2, builder);
            builder.append("errorCase ");
            this.prettyPrintRemote(fold.onError(), builder, indent + 2);
            PrettyPrint$.nl$2(indent + 2, builder);
            builder.append("ifSuccess ");
            this.prettyPrintRemote(fold.onSuccess(), builder, indent + 2);
            return;
        }
        if (flow instanceof ZFlow.Log) {
            Remote<String> message = ((ZFlow.Log)flow).message();
            builder.append("log ");
            this.prettyPrintRemote(message, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.RunActivity) {
            ZFlow.RunActivity runActivity = (ZFlow.RunActivity)flow;
            Remote input = runActivity.input();
            Activity activity = runActivity.activity();
            builder.append("run ");
            builder.append(activity.toString());
            builder.append(" with ");
            this.prettyPrintRemote(input, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.Transaction) {
            ZFlow workflow = ((ZFlow.Transaction)flow).workflow();
            builder.append("transaction");
            this.prettyPrintFlow(workflow, builder, indent + 2);
            return;
        }
        if (flow instanceof ZFlow.Input) {
            builder.append("input");
            return;
        }
        if (flow instanceof ZFlow.Ensuring) {
            ZFlow.Ensuring ensuring = (ZFlow.Ensuring)flow;
            ZFlow flow2 = ensuring.flow();
            ZFlow<Object, Nothing$, BoxedUnit> finalizer = ensuring.finalizer();
            builder.append("ensuring");
            this.prettyPrintFlow(flow2, builder, indent + 2);
            builder.append("with finalizer");
            this.prettyPrintFlow(finalizer, builder, indent + 2);
            return;
        }
        if (flow instanceof ZFlow.Unwrap) {
            Remote remote = ((ZFlow.Unwrap)flow).remote();
            builder.append("unwrap ");
            this.prettyPrintRemote(remote, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.UnwrapRemote) {
            Remote remote = ((ZFlow.UnwrapRemote)flow).remote();
            builder.append("unwrap remote");
            this.prettyPrintRemote(remote, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.Fork) {
            ZFlow flow3 = ((ZFlow.Fork)flow).flow();
            builder.append("fork");
            this.prettyPrintFlow(flow3, builder, indent + 2);
            return;
        }
        if (flow instanceof ZFlow.Timeout) {
            ZFlow.Timeout timeout = (ZFlow.Timeout)flow;
            ZFlow flow4 = timeout.flow();
            Remote<Duration> duration = timeout.duration();
            builder.append("timeout ");
            this.prettyPrintRemote(duration, builder, indent);
            this.prettyPrintFlow(flow4, builder, indent + 2);
            return;
        }
        if (flow instanceof ZFlow.Provide) {
            ZFlow.Provide provide = (ZFlow.Provide)flow;
            Remote value = provide.value();
            ZFlow flow5 = provide.flow();
            builder.append("provide ");
            this.prettyPrintRemote(value, builder, indent);
            this.prettyPrintFlow(flow5, builder, indent + 2);
            return;
        }
        if (ZFlow$Die$.MODULE$.equals(flow)) {
            builder.append("die");
            return;
        }
        if (ZFlow$RetryUntil$.MODULE$.equals(flow)) {
            builder.append("retry");
            return;
        }
        if (flow instanceof ZFlow.OrTry) {
            ZFlow.OrTry orTry = (ZFlow.OrTry)flow;
            ZFlow left = orTry.left();
            ZFlow right = orTry.right();
            builder.append("try");
            this.prettyPrintFlow(left, builder, indent + 2);
            builder.append("or");
            this.prettyPrintFlow(right, builder, indent + 2);
            return;
        }
        if (flow instanceof ZFlow.Await) {
            Remote exFlow = ((ZFlow.Await)flow).exFlow();
            builder.append("await ");
            this.prettyPrintRemote(exFlow, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.Interrupt) {
            Remote exFlow = ((ZFlow.Interrupt)flow).exFlow();
            builder.append("interrupt ");
            this.prettyPrintRemote(exFlow, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.Fail) {
            Remote error = ((ZFlow.Fail)flow).error();
            builder.append("fail ");
            this.prettyPrintRemote(error, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.NewVar) {
            ZFlow.NewVar newVar = (ZFlow.NewVar)flow;
            String name = newVar.name();
            Remote initial = newVar.initial();
            boolean appendTempCounter = newVar.appendTempCounter();
            builder.append(appendTempCounter ? "newTempVar" : "newVar ");
            builder.append(name);
            builder.append(" with initial value ");
            this.prettyPrintRemote(initial, builder, indent);
            return;
        }
        if (flow instanceof ZFlow.Iterate) {
            ZFlow.Iterate iterate = (ZFlow.Iterate)flow;
            Remote initial = iterate.initial();
            Remote.UnboundRemoteFunction step = iterate.step();
            Remote.UnboundRemoteFunction predicate = iterate.predicate();
            builder.append("iterate from ");
            this.prettyPrintRemote(initial, builder, indent);
            builder.append(" by ");
            this.prettyPrintRemote(step, builder, indent);
            builder.append(" while ");
            this.prettyPrintRemote(predicate, builder, indent);
            return;
        }
        if (ZFlow$Random$.MODULE$.equals(flow)) {
            builder.append("random");
            return;
        }
        if (ZFlow$RandomUUID$.MODULE$.equals(flow)) {
            builder.append("randomUUID");
            return;
        }
        throw new MatchError(flow);
    }

    private static final void nl$1(int i, StringBuilder builder$1) {
        builder$1.append("\n").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(i));
    }

    private static final void nl$2(int i, StringBuilder builder$2) {
        builder$2.append("\n").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(i));
    }

    private PrettyPrint$() {
        MODULE$ = this;
    }
}

