/*
 * Copyright 2021-2023 John A. De Goes and the ZIO Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package zio.flow.remote

import zio.flow._
import zio.schema.Schema

final class RemoteRelationalSyntax[A](val self: Remote[A]) extends AnyVal {

  def <(that: Remote[A])(implicit schema: Schema[A]): Remote[Boolean] =
    (self <= that) && (self !== that)

  def <=(that: Remote[A])(implicit schema: Schema[A]): Remote[Boolean] =
    Remote.Binary(self, that, BinaryOperators.LessThanEqual(schema))

  def >(that: Remote[A])(implicit schema: Schema[A]): Remote[Boolean] =
    !(self <= that)

  def >=(that: Remote[A])(implicit schema: Schema[A]): Remote[Boolean] =
    (self > that) || (self === that)

  def !=(that: Remote[A]): Remote[Boolean] =
    !(self === that)

  def !==(that: Remote[A]): Remote[Boolean] =
    !(self === that)

  def ==(that: Remote[A]): Remote[Boolean] =
    Remote.Equal(self, that)

  def ===(that: Remote[A]): Remote[Boolean] =
    Remote.Equal(self, that)
}
