package zio.flow.operation.http

import zio.Chunk
import zio.schema.{Schema, StandardType}

import java.net.URLEncoder
import java.nio.charset.StandardCharsets
import java.time._
import java.time.format.DateTimeFormatter
import scala.collection.immutable.ListMap
import scala.collection.mutable

object FormUrlEncodedEncoder {
  def encode[A](schema: Schema[A]): A => Chunk[Byte] = { (value: A) =>
    val builder = new mutable.StringBuilder
    encode(builder, "", schema)(value)
    Chunk.fromArray(builder.toString().getBytes(StandardCharsets.UTF_8))
  }

  def encode[A](builder: mutable.StringBuilder, label: String, schema: Schema[A]): A => Unit = {
    def addField[A](fieldName: String, schema: Schema[A], fieldValue: Any): Unit = {
      encode(builder, fieldName, schema.asInstanceOf[Schema[Any]])(fieldValue)
      ()
    }

    def addCase[A, Z](c: Schema.Case[A, Z], value: Any): Unit =
      if (c.asInstanceOf[Schema.Case[Any, Any]].deconstructOption(value).isDefined) { builder.append(c.id); () }

    def addCaseSet(cases: Seq[Schema.Case[_, _]], value: Any): Unit =
      cases.foreach(addCase(_, value))

    def addValuePrefix(): Unit = {
      if (builder.nonEmpty) builder.append('&')
      if (label.nonEmpty) builder.append(s"$label=")
      ()
    }

    (value: A) =>
      schema match {
        case record: Schema.GenericRecord =>
          val data = value.asInstanceOf[ListMap[String, _]]
          record.fieldSet.toChunk.foreach { field =>
            addField(field.name, field.schema, data(field.name))
          }
        case cls: Schema.CaseClass1[_, _] =>
          addField(cls.field.name, cls.field.schema, cls.field.get(value))
        case cls: Schema.CaseClass2[_, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
        case cls: Schema.CaseClass3[_, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
        case cls: Schema.CaseClass4[_, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
        case cls: Schema.CaseClass5[_, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
        case cls: Schema.CaseClass6[_, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
        case cls: Schema.CaseClass7[_, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
        case cls: Schema.CaseClass8[_, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
        case cls: Schema.CaseClass9[_, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
        case cls: Schema.CaseClass10[_, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
        case cls: Schema.CaseClass11[_, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
        case cls: Schema.CaseClass12[_, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
        case cls: Schema.CaseClass13[_, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
        case cls: Schema.CaseClass14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
        case cls: Schema.CaseClass15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
          addField(cls.field15.name, cls.field15.schema, cls.field15.get(value))
        case cls: Schema.CaseClass16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
          addField(cls.field15.name, cls.field15.schema, cls.field15.get(value))
          addField(cls.field16.name, cls.field16.schema, cls.field16.get(value))
        case cls: Schema.CaseClass17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
          addField(cls.field15.name, cls.field15.schema, cls.field15.get(value))
          addField(cls.field16.name, cls.field16.schema, cls.field16.get(value))
          addField(cls.field17.name, cls.field17.schema, cls.field17.get(value))
        case cls: Schema.CaseClass18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
          addField(cls.field15.name, cls.field15.schema, cls.field15.get(value))
          addField(cls.field16.name, cls.field16.schema, cls.field16.get(value))
          addField(cls.field17.name, cls.field17.schema, cls.field17.get(value))
          addField(cls.field18.name, cls.field18.schema, cls.field18.get(value))
        case cls: Schema.CaseClass19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
          addField(cls.field15.name, cls.field15.schema, cls.field15.get(value))
          addField(cls.field16.name, cls.field16.schema, cls.field16.get(value))
          addField(cls.field17.name, cls.field17.schema, cls.field17.get(value))
          addField(cls.field18.name, cls.field18.schema, cls.field18.get(value))
          addField(cls.field19.name, cls.field19.schema, cls.field19.get(value))
        case cls: Schema.CaseClass20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
          addField(cls.field15.name, cls.field15.schema, cls.field15.get(value))
          addField(cls.field16.name, cls.field16.schema, cls.field16.get(value))
          addField(cls.field17.name, cls.field17.schema, cls.field17.get(value))
          addField(cls.field18.name, cls.field18.schema, cls.field18.get(value))
          addField(cls.field19.name, cls.field19.schema, cls.field19.get(value))
          addField(cls.field20.name, cls.field20.schema, cls.field20.get(value))
        case cls: Schema.CaseClass21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
          addField(cls.field15.name, cls.field15.schema, cls.field15.get(value))
          addField(cls.field16.name, cls.field16.schema, cls.field16.get(value))
          addField(cls.field17.name, cls.field17.schema, cls.field17.get(value))
          addField(cls.field18.name, cls.field18.schema, cls.field18.get(value))
          addField(cls.field19.name, cls.field19.schema, cls.field19.get(value))
          addField(cls.field20.name, cls.field20.schema, cls.field20.get(value))
          addField(cls.field21.name, cls.field21.schema, cls.field21.get(value))
        case cls: Schema.CaseClass22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addField(cls.field1.name, cls.field1.schema, cls.field1.get(value))
          addField(cls.field2.name, cls.field2.schema, cls.field2.get(value))
          addField(cls.field3.name, cls.field3.schema, cls.field3.get(value))
          addField(cls.field4.name, cls.field4.schema, cls.field4.get(value))
          addField(cls.field5.name, cls.field5.schema, cls.field5.get(value))
          addField(cls.field6.name, cls.field6.schema, cls.field6.get(value))
          addField(cls.field7.name, cls.field7.schema, cls.field7.get(value))
          addField(cls.field8.name, cls.field8.schema, cls.field8.get(value))
          addField(cls.field9.name, cls.field9.schema, cls.field9.get(value))
          addField(cls.field10.name, cls.field10.schema, cls.field10.get(value))
          addField(cls.field11.name, cls.field11.schema, cls.field11.get(value))
          addField(cls.field12.name, cls.field12.schema, cls.field12.get(value))
          addField(cls.field13.name, cls.field13.schema, cls.field13.get(value))
          addField(cls.field14.name, cls.field14.schema, cls.field14.get(value))
          addField(cls.field15.name, cls.field15.schema, cls.field15.get(value))
          addField(cls.field16.name, cls.field16.schema, cls.field16.get(value))
          addField(cls.field17.name, cls.field17.schema, cls.field17.get(value))
          addField(cls.field18.name, cls.field18.schema, cls.field18.get(value))
          addField(cls.field19.name, cls.field19.schema, cls.field19.get(value))
          addField(cls.field20.name, cls.field20.schema, cls.field20.get(value))
          addField(cls.field21.name, cls.field21.schema, cls.field21.get(value))
          addField(cls.field22.name, cls.field22.schema, cls.field22.get(value))
        case enum: Schema.Enum1[_, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
        case enum: Schema.Enum2[_, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
        case enum: Schema.Enum3[_, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
        case enum: Schema.Enum4[_, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
        case enum: Schema.Enum5[_, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
        case enum: Schema.Enum6[_, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
        case enum: Schema.Enum7[_, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
        case enum: Schema.Enum8[_, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
        case enum: Schema.Enum9[_, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
        case enum: Schema.Enum10[_, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
        case enum: Schema.Enum11[_, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
        case enum: Schema.Enum12[_, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
        case enum: Schema.Enum13[_, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
        case enum: Schema.Enum14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
        case enum: Schema.Enum15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
          addCase(enum.case15, value)
        case enum: Schema.Enum16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
          addCase(enum.case15, value)
          addCase(enum.case16, value)
        case enum: Schema.Enum17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
          addCase(enum.case15, value)
          addCase(enum.case16, value)
          addCase(enum.case17, value)
        case enum: Schema.Enum18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
          addCase(enum.case15, value)
          addCase(enum.case16, value)
          addCase(enum.case17, value)
          addCase(enum.case18, value)
        case enum: Schema.Enum19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
          addCase(enum.case15, value)
          addCase(enum.case16, value)
          addCase(enum.case17, value)
          addCase(enum.case18, value)
          addCase(enum.case19, value)
        case enum: Schema.Enum20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
          addCase(enum.case15, value)
          addCase(enum.case16, value)
          addCase(enum.case17, value)
          addCase(enum.case18, value)
          addCase(enum.case19, value)
          addCase(enum.case20, value)
        case enum: Schema.Enum21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
          addCase(enum.case15, value)
          addCase(enum.case16, value)
          addCase(enum.case17, value)
          addCase(enum.case18, value)
          addCase(enum.case19, value)
          addCase(enum.case20, value)
          addCase(enum.case21, value)
        case enum: Schema.Enum22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _] =>
          addValuePrefix()
          addCase(enum.case1, value)
          addCase(enum.case2, value)
          addCase(enum.case3, value)
          addCase(enum.case4, value)
          addCase(enum.case5, value)
          addCase(enum.case6, value)
          addCase(enum.case7, value)
          addCase(enum.case8, value)
          addCase(enum.case9, value)
          addCase(enum.case10, value)
          addCase(enum.case11, value)
          addCase(enum.case12, value)
          addCase(enum.case13, value)
          addCase(enum.case14, value)
          addCase(enum.case15, value)
          addCase(enum.case16, value)
          addCase(enum.case17, value)
          addCase(enum.case18, value)
          addCase(enum.case19, value)
          addCase(enum.case20, value)
          addCase(enum.case21, value)
          addCase(enum.case22, value)
        case enum: Schema.EnumN[_, _] =>
          addValuePrefix()
          addCaseSet(enum.caseSet.toSeq, value)
        case transform: Schema.Transform[_, _, _] =>
          encode(builder, label, transform.schema)(
            transform.g(value).fold((failure: String) => throw new RuntimeException(failure), value => value)
          )
        case primitive: Schema.Primitive[_] =>
          addValuePrefix()
          primitive.standardType match {
            case StandardType.InstantType =>
              builder.append(
                URLEncoder.encode(
                  DateTimeFormatter.ISO_INSTANT.format(value.asInstanceOf[Instant]),
                  StandardCharsets.UTF_8.name()
                )
              );
              ()
            case StandardType.LocalDateType =>
              builder.append(
                URLEncoder.encode(
                  DateTimeFormatter.ISO_LOCAL_DATE.format(value.asInstanceOf[LocalDate]),
                  StandardCharsets.UTF_8.name()
                )
              );
              ()
            case StandardType.LocalTimeType =>
              builder.append(
                URLEncoder.encode(
                  DateTimeFormatter.ISO_LOCAL_TIME.format(value.asInstanceOf[LocalTime]),
                  StandardCharsets.UTF_8.name()
                )
              );
              ()
            case StandardType.LocalDateTimeType =>
              builder.append(
                URLEncoder.encode(
                  DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value.asInstanceOf[LocalDateTime]),
                  StandardCharsets.UTF_8.name()
                )
              );
              ()
            case StandardType.OffsetTimeType =>
              builder.append(
                URLEncoder.encode(
                  DateTimeFormatter.ISO_OFFSET_TIME.format(value.asInstanceOf[OffsetTime]),
                  StandardCharsets.UTF_8.name()
                )
              );
              ()
            case StandardType.OffsetDateTimeType =>
              builder.append(
                URLEncoder.encode(
                  DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value.asInstanceOf[OffsetDateTime]),
                  StandardCharsets.UTF_8.name()
                )
              );
              ()
            case StandardType.ZonedDateTimeType =>
              builder.append(
                URLEncoder.encode(
                  DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value.asInstanceOf[ZonedDateTime]),
                  StandardCharsets.UTF_8.name()
                )
              );
              ()
            case _ => builder.append(URLEncoder.encode(value.toString, StandardCharsets.UTF_8.name())); ()
          }
        case optional: Schema.Optional[_] =>
          value.asInstanceOf[Option[Any]] match {
            case Some(inner) => encode(builder, label, optional.schema.asInstanceOf[Schema[Any]])(inner)
            case None        =>
          }
        case Schema.Lazy(inner) =>
          encode(builder, label, inner())(value)
        case _ =>
          throw new IllegalArgumentException(s"Schema $schema is not supported for x-www-form-urlencoded payloads")
      }
  }
}
