/*
 * Decompiled with CFR 0.152.
 */
package zio.dynamodb;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO$;
import zio.dynamodb.AttrMap;
import zio.dynamodb.AttributeDefinition;
import zio.dynamodb.AttributeValue;
import zio.dynamodb.AttributeValue$;
import zio.dynamodb.BillingMode;
import zio.dynamodb.ConditionExpression;
import zio.dynamodb.ConsistencyMode;
import zio.dynamodb.DynamoDBError;
import zio.dynamodb.DynamoDBQuery;
import zio.dynamodb.DynamoDBQuery$BatchGetItem$;
import zio.dynamodb.DynamoDBQuery$BatchWriteItem$;
import zio.dynamodb.DynamoDBQuery$CreateTable$;
import zio.dynamodb.DynamoDBQuery$DeleteItem$;
import zio.dynamodb.DynamoDBQuery$GetItem$;
import zio.dynamodb.DynamoDBQuery$PutItem$;
import zio.dynamodb.DynamoDBQuery$QueryAll$;
import zio.dynamodb.DynamoDBQuery$QuerySome$;
import zio.dynamodb.DynamoDBQuery$ScanAll$;
import zio.dynamodb.DynamoDBQuery$ScanSome$;
import zio.dynamodb.DynamoDBQuery$UpdateItem$;
import zio.dynamodb.FromAttributeValue$;
import zio.dynamodb.GlobalSecondaryIndex;
import zio.dynamodb.IndexName;
import zio.dynamodb.KeyConditionExpression;
import zio.dynamodb.KeySchema;
import zio.dynamodb.LocalSecondaryIndex;
import zio.dynamodb.NonEmptySet;
import zio.dynamodb.NonEmptySet$;
import zio.dynamodb.ProjectionExpression;
import zio.dynamodb.ProjectionExpression$Root$;
import zio.dynamodb.ReturnConsumedCapacity;
import zio.dynamodb.SSESpecification;
import zio.dynamodb.Select;
import zio.dynamodb.Select$AllAttributes$;
import zio.dynamodb.Select$SpecificAttributes$;
import zio.dynamodb.TableName;
import zio.dynamodb.ToAttributeValue$;
import zio.dynamodb.UpdateExpression;
import zio.prelude.AssociativeBoth$;
import zio.prelude.Covariant;
import zio.prelude.Invariant$;
import zio.prelude.package$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.stream.ZStream;

public final class DynamoDBQuery$ {
    public static final DynamoDBQuery$ MODULE$ = new DynamoDBQuery$();

    public <A> DynamoDBQuery<Object, A> succeed(Function0<A> a) {
        return new DynamoDBQuery.Succeed<A>(a);
    }

    public DynamoDBQuery<Object, Nothing$> fail(Function0<DynamoDBError> e) {
        return new DynamoDBQuery.Fail(e);
    }

    public <A, B> DynamoDBQuery<A, B> absolve(DynamoDBQuery<A, Either<DynamoDBError, B>> query) {
        return new DynamoDBQuery.Absolve<A, B>(query);
    }

    public <A> DynamoDBQuery<Object, A> fromEither(Either<DynamoDBError, A> or) {
        DynamoDBQuery<Object, Object> dynamoDBQuery;
        Either<DynamoDBError, A> either = or;
        if (either instanceof Left) {
            Left left = (Left)either;
            DynamoDBError error = (DynamoDBError)left.value();
            dynamoDBQuery = this.fail((Function0<DynamoDBError>)(Function0 & Serializable)() -> error);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object value = right.value();
            dynamoDBQuery = this.succeed((Function0 & Serializable)() -> value);
        } else {
            throw new MatchError(either);
        }
        return dynamoDBQuery;
    }

    public <In, A, B> DynamoDBQuery<In, List<B>> forEach(Iterable<A> values, Function1<A, DynamoDBQuery<In, B>> body) {
        return (DynamoDBQuery)values.foldRight(this.succeed((Function0 & Serializable)() -> scala.package$.MODULE$.Nil()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object a = tuple2._1();
            DynamoDBQuery query = (DynamoDBQuery)tuple2._2();
            DynamoDBQuery dynamoDBQuery = ((DynamoDBQuery)body.apply(a)).zipWith(query, (Function2 & Serializable)(x$10, x$11) -> {
                Object object = x$10;
                return x$11.$colon$colon(object);
            });
            return dynamoDBQuery;
        });
    }

    public DynamoDBQuery<Object, Option<AttrMap>> getItem(String tableName, AttrMap key, Seq<ProjectionExpression<?, ?>> projections) {
        return new DynamoDBQuery.GetItem(new TableName(tableName), key, projections.toList(), DynamoDBQuery$GetItem$.MODULE$.apply$default$4(), DynamoDBQuery$GetItem$.MODULE$.apply$default$5());
    }

    public <A> DynamoDBQuery<A, Either<DynamoDBError, A>> get(String tableName, AttrMap key, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$1) {
        return this.getItem(tableName, key, projections).map((Function1 & Serializable)x0$1 -> {
            Left left;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                AttrMap item = (AttrMap)some.value();
                left = MODULE$.fromItem(item, evidence$1);
            } else if (None$.MODULE$.equals(option)) {
                left = scala.package$.MODULE$.Left().apply((Object)new DynamoDBError.ValueNotFound(new StringBuilder(25).append("value with key ").append(key).append(" not found").toString()));
            } else {
                throw new MatchError((Object)option);
            }
            return left;
        });
    }

    public <A> Either<DynamoDBError, A> fromItem(AttrMap item, Schema<A> evidence$2) {
        AttributeValue av = ToAttributeValue$.MODULE$.attrMapToAttributeValue().toAttributeValue(item);
        return av.decode(Schema$.MODULE$.apply(evidence$2));
    }

    public DynamoDBQuery<Object, Option<AttrMap>> putItem(String tableName, AttrMap item) {
        return new DynamoDBQuery.PutItem(new TableName(tableName), item, DynamoDBQuery$PutItem$.MODULE$.apply$default$3(), DynamoDBQuery$PutItem$.MODULE$.apply$default$4(), DynamoDBQuery$PutItem$.MODULE$.apply$default$5(), DynamoDBQuery$PutItem$.MODULE$.apply$default$6());
    }

    public <A> DynamoDBQuery<A, Option<A>> put(String tableName, A a, Schema<A> evidence$3) {
        return this.putItem(tableName, this.toItem(a, evidence$3)).map((Function1 & Serializable)x$12 -> x$12.flatMap((Function1 & Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$3).toOption()));
    }

    public <A> AttrMap toItem(A a, Schema<A> schema) {
        return (AttrMap)FromAttributeValue$.MODULE$.attrMapFromAttributeValue().fromAttributeValue(AttributeValue$.MODULE$.encode(a, schema)).getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(15).append("error encoding ").append(a).toString());
        });
    }

    public <A> DynamoDBQuery<A, Option<AttrMap>> updateItem(String tableName, AttrMap key, UpdateExpression.Action<A> action) {
        return new DynamoDBQuery.UpdateItem(new TableName(tableName), key, new UpdateExpression<A>(action), DynamoDBQuery$UpdateItem$.MODULE$.apply$default$4(), DynamoDBQuery$UpdateItem$.MODULE$.apply$default$5(), DynamoDBQuery$UpdateItem$.MODULE$.apply$default$6(), DynamoDBQuery$UpdateItem$.MODULE$.apply$default$7());
    }

    public <A> DynamoDBQuery<A, Option<A>> update(String tableName, AttrMap key, UpdateExpression.Action<A> action, Schema<A> evidence$4) {
        return this.updateItem(tableName, key, action).map((Function1 & Serializable)x$13 -> x$13.flatMap((Function1 & Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$4).toOption()));
    }

    public DynamoDBQuery.Write<Object, Option<AttrMap>> deleteItem(String tableName, AttrMap key) {
        return new DynamoDBQuery.DeleteItem(new TableName(tableName), key, DynamoDBQuery$DeleteItem$.MODULE$.apply$default$3(), DynamoDBQuery$DeleteItem$.MODULE$.apply$default$4(), DynamoDBQuery$DeleteItem$.MODULE$.apply$default$5(), DynamoDBQuery$DeleteItem$.MODULE$.apply$default$6());
    }

    public <A> DynamoDBQuery<Object, Option<A>> delete(String tableName, AttrMap key, Schema<A> evidence$5) {
        return this.deleteItem(tableName, key).map((Function1 & Serializable)x$14 -> x$14.flatMap((Function1 & Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$5).toOption()));
    }

    public DynamoDBQuery.ScanSome scanSomeItem(String tableName, int limit, Seq<ProjectionExpression<?, ?>> projections) {
        TableName x$1 = new TableName(tableName);
        int x$2 = limit;
        Option<Select> x$3 = this.selectOrAll(projections);
        List x$4 = projections.toList();
        Option<IndexName> x$5 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$3();
        ConsistencyMode x$6 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$4();
        Option<AttrMap> x$7 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$5();
        Option<ConditionExpression<?>> x$8 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$6();
        ReturnConsumedCapacity x$9 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$8();
        return new DynamoDBQuery.ScanSome(x$1, x$2, x$5, x$6, x$7, x$8, x$4, x$9, x$3);
    }

    public <A> DynamoDBQuery<A, Tuple2<Chunk<A>, Option<AttrMap>>> scanSome(String tableName, int limit, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$6) {
        return this.absolve(this.scanSomeItem(tableName, limit, projections).map((Function1 & Serializable)x0$1 -> {
            Right right;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Chunk itemsChunk = (Chunk)tuple2._1();
            Option lek = (Option)tuple2._2();
            Either either = ((Either)package$.MODULE$.ForEachOps((Object)itemsChunk).forEach((Function1 & Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$6), AssociativeBoth$.MODULE$.EitherIdentityBoth(), (Covariant)Invariant$.MODULE$.EitherForEach(), Invariant$.MODULE$.ChunkForEach())).map((Function1 & Serializable)it -> Chunk$.MODULE$.fromIterable(it));
            if (either instanceof Right) {
                Right right2 = (Right)either;
                Chunk chunk = (Chunk)right2.value();
                right = scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)chunk, (Object)lek));
                return right;
            } else {
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Left left = (Left)either;
                DynamoDBError error = (DynamoDBError)left.value();
                right = scala.package$.MODULE$.Left().apply((Object)error);
            }
            return right;
        }));
    }

    public DynamoDBQuery.ScanAll scanAllItem(String tableName, Seq<ProjectionExpression<?, ?>> projections) {
        TableName x$1 = new TableName(tableName);
        Option<Select> x$2 = this.selectOrAll(projections);
        List x$3 = projections.toList();
        Option<IndexName> x$4 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$2();
        Option<Object> x$5 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$3();
        ConsistencyMode x$6 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$4();
        Option<AttrMap> x$7 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$5();
        Option<ConditionExpression<?>> x$8 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$6();
        ReturnConsumedCapacity x$9 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$8();
        int x$10 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$10();
        return new DynamoDBQuery.ScanAll(x$1, x$4, x$5, x$6, x$7, x$8, x$3, x$9, x$2, x$10);
    }

    public <A> DynamoDBQuery<A, ZStream<Object, Throwable, A>> scanAll(String tableName, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$7) {
        return this.scanAllItem(tableName, projections).map((Function1 & Serializable)x$15 -> x$15.mapZIO((Function1 & Serializable)item -> ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> MODULE$.fromItem((AttrMap)item, evidence$7), (Object)"zio.dynamodb.DynamoDBQuery.scanAll(DynamoDBQuery.scala:574)").mapError((Function1 & Serializable)x$16 -> new IllegalStateException((Throwable)((Object)x$16)), CanFail$.MODULE$.canFail(), (Object)"zio.dynamodb.DynamoDBQuery.scanAll(DynamoDBQuery.scala:574)"), (Object)"zio.dynamodb.DynamoDBQuery.scanAll(DynamoDBQuery.scala:574)"));
    }

    public DynamoDBQuery.QuerySome querySomeItem(String tableName, int limit, Seq<ProjectionExpression<?, ?>> projections) {
        TableName x$1 = new TableName(tableName);
        int x$2 = limit;
        Option<Select> x$3 = this.selectOrAll(projections);
        List x$4 = projections.toList();
        Option<IndexName> x$5 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$3();
        ConsistencyMode x$6 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$4();
        Option<AttrMap> x$7 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$5();
        Option<ConditionExpression<?>> x$8 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$6();
        Option<KeyConditionExpression> x$9 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$7();
        ReturnConsumedCapacity x$10 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$9();
        boolean x$11 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$11();
        return new DynamoDBQuery.QuerySome(x$1, x$2, x$5, x$6, x$7, x$8, x$9, x$4, x$10, x$3, x$11);
    }

    public <A> DynamoDBQuery<A, Tuple2<Chunk<A>, Option<AttrMap>>> querySome(String tableName, int limit, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$8) {
        return this.absolve(this.querySomeItem(tableName, limit, projections).map((Function1 & Serializable)x0$1 -> {
            Right right;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Chunk itemsChunk = (Chunk)tuple2._1();
            Option lek = (Option)tuple2._2();
            Either either = ((Either)package$.MODULE$.ForEachOps((Object)itemsChunk).forEach((Function1 & Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$8), AssociativeBoth$.MODULE$.EitherIdentityBoth(), (Covariant)Invariant$.MODULE$.EitherForEach(), Invariant$.MODULE$.ChunkForEach())).map((Function1 & Serializable)it -> Chunk$.MODULE$.fromIterable(it));
            if (either instanceof Right) {
                Right right2 = (Right)either;
                Chunk chunk = (Chunk)right2.value();
                right = scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)chunk, (Object)lek));
                return right;
            } else {
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Left left = (Left)either;
                DynamoDBError error = (DynamoDBError)left.value();
                right = scala.package$.MODULE$.Left().apply((Object)error);
            }
            return right;
        }));
    }

    public DynamoDBQuery.QueryAll queryAllItem(String tableName, Seq<ProjectionExpression<?, ?>> projections) {
        TableName x$1 = new TableName(tableName);
        Option<Select> x$2 = this.selectOrAll(projections);
        List x$3 = projections.toList();
        Option<IndexName> x$4 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$2();
        Option<Object> x$5 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$3();
        ConsistencyMode x$6 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$4();
        Option<AttrMap> x$7 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$5();
        Option<ConditionExpression<?>> x$8 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$6();
        Option<KeyConditionExpression> x$9 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$7();
        ReturnConsumedCapacity x$10 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$9();
        boolean x$11 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$11();
        return new DynamoDBQuery.QueryAll(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$3, x$10, x$2, x$11);
    }

    public <A> DynamoDBQuery<A, ZStream<Object, Throwable, A>> queryAll(String tableName, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$9) {
        return this.queryAllItem(tableName, projections).map((Function1 & Serializable)x$17 -> x$17.mapZIO((Function1 & Serializable)item -> ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> MODULE$.fromItem((AttrMap)item, evidence$9), (Object)"zio.dynamodb.DynamoDBQuery.queryAll(DynamoDBQuery.scala:625)").mapError((Function1 & Serializable)x$18 -> new IllegalStateException((Throwable)((Object)x$18)), CanFail$.MODULE$.canFail(), (Object)"zio.dynamodb.DynamoDBQuery.queryAll(DynamoDBQuery.scala:625)"), (Object)"zio.dynamodb.DynamoDBQuery.queryAll(DynamoDBQuery.scala:625)"));
    }

    public DynamoDBQuery.CreateTable createTable(String tableName, KeySchema keySchema, BillingMode billingMode, Option<SSESpecification> sseSpecification, Map<String, String> tags, AttributeDefinition attributeDefinition, Seq<AttributeDefinition> attributeDefinitions) {
        TableName x$1 = new TableName(tableName);
        KeySchema x$2 = keySchema;
        NonEmptySet<AttributeDefinition> x$3 = NonEmptySet$.MODULE$.apply(attributeDefinition, attributeDefinitions);
        BillingMode x$4 = billingMode;
        Option<SSESpecification> x$5 = sseSpecification;
        Map<String, String> x$6 = tags;
        Set<GlobalSecondaryIndex> x$7 = DynamoDBQuery$CreateTable$.MODULE$.apply$default$5();
        Set<LocalSecondaryIndex> x$8 = DynamoDBQuery$CreateTable$.MODULE$.apply$default$6();
        return new DynamoDBQuery.CreateTable(x$1, x$2, x$3, x$4, x$7, x$8, x$5, x$6);
    }

    public Option<SSESpecification> createTable$default$4() {
        return None$.MODULE$;
    }

    public Map<String, String> createTable$default$5() {
        return Map$.MODULE$.empty();
    }

    public DynamoDBQuery.ConditionCheck conditionCheck(String tableName, AttrMap primaryKey, ConditionExpression<?> conditionExpression) {
        return new DynamoDBQuery.ConditionCheck(new TableName(tableName), primaryKey, conditionExpression);
    }

    public DynamoDBQuery.DeleteTable deleteTable(String tableName) {
        return new DynamoDBQuery.DeleteTable(new TableName(tableName));
    }

    public DynamoDBQuery.DescribeTable describeTable(String tableName) {
        return new DynamoDBQuery.DescribeTable(new TableName(tableName));
    }

    private Option<Select> selectOrAll(Seq<ProjectionExpression<?, ?>> projections) {
        return new Some((Object)(projections.isEmpty() ? Select$AllAttributes$.MODULE$ : Select$SpecificAttributes$.MODULE$));
    }

    public <A> DynamoDBQuery<Object, A> apply(Function0<A> a) {
        return new DynamoDBQuery.Succeed<A>(a);
    }

    public <In> Tuple3<Chunk<Tuple2<DynamoDBQuery.Constructor<In, Object>, Object>>, Tuple2<DynamoDBQuery.BatchGetItem, Chunk<Object>>, Tuple2<DynamoDBQuery.BatchWriteItem, Chunk<Object>>> batched(Chunk<DynamoDBQuery.Constructor<In, Object>> constructors) {
        Tuple3 tuple3 = (Tuple3)constructors.zipWithIndex().foldLeft((Object)new Tuple3((Object)Chunk$.MODULE$.empty(), (Object)Chunk$.MODULE$.empty(), (Object)Chunk$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple3 != null) {
                    Chunk nonBatched = (Chunk)tuple3._1();
                    Chunk gets = (Chunk)tuple3._2();
                    Chunk writes = (Chunk)tuple3._3();
                    if (tuple22 != null) {
                        DynamoDBQuery.Constructor get = (DynamoDBQuery.Constructor)tuple22._1();
                        int index = tuple22._2$mcI$sp();
                        if (get instanceof DynamoDBQuery.GetItem) {
                            DynamoDBQuery.GetItem getItem = (DynamoDBQuery.GetItem)get;
                            AttrMap pk = getItem.key();
                            List<ProjectionExpression<?, ?>> pes = getItem.projections();
                            return DynamoDBQuery$.projectionsContainPrimaryKey$1(pes, pk) ? new Tuple3((Object)nonBatched, gets.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)getItem), (Object)BoxesRunTime.boxToInteger((int)index))), (Object)writes) : new Tuple3(nonBatched.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)getItem), (Object)BoxesRunTime.boxToInteger((int)index))), (Object)gets, (Object)writes);
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple3 != null) {
                    Chunk nonBatched = (Chunk)tuple3._1();
                    Chunk gets = (Chunk)tuple3._2();
                    Chunk writes = (Chunk)tuple3._3();
                    if (tuple23 != null) {
                        DynamoDBQuery.Constructor put = (DynamoDBQuery.Constructor)tuple23._1();
                        int index = tuple23._2$mcI$sp();
                        if (put instanceof DynamoDBQuery.PutItem) {
                            Tuple3 tuple32;
                            DynamoDBQuery.PutItem putItem = (DynamoDBQuery.PutItem)put;
                            Option<ConditionExpression<?>> conditionExpression = putItem.conditionExpression();
                            Option<ConditionExpression<?>> option = conditionExpression;
                            if (option instanceof Some) {
                                tuple32 = new Tuple3(nonBatched.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)putItem), (Object)BoxesRunTime.boxToInteger((int)index))), (Object)gets, (Object)writes);
                                return tuple32;
                            } else {
                                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                                tuple32 = new Tuple3((Object)nonBatched, (Object)gets, writes.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)putItem), (Object)BoxesRunTime.boxToInteger((int)index))));
                            }
                            return tuple32;
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple3 != null) {
                    Chunk nonBatched = (Chunk)tuple3._1();
                    Chunk gets = (Chunk)tuple3._2();
                    Chunk writes = (Chunk)tuple3._3();
                    if (tuple24 != null) {
                        DynamoDBQuery.Constructor delete = (DynamoDBQuery.Constructor)tuple24._1();
                        int index = tuple24._2$mcI$sp();
                        if (delete instanceof DynamoDBQuery.DeleteItem) {
                            Tuple3 tuple33;
                            DynamoDBQuery.DeleteItem deleteItem = (DynamoDBQuery.DeleteItem)delete;
                            Option<ConditionExpression<?>> conditionExpression = deleteItem.conditionExpression();
                            Option<ConditionExpression<?>> option = conditionExpression;
                            if (option instanceof Some) {
                                tuple33 = new Tuple3(nonBatched.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deleteItem), (Object)BoxesRunTime.boxToInteger((int)index))), (Object)gets, (Object)writes);
                                return tuple33;
                            } else {
                                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                                tuple33 = new Tuple3((Object)nonBatched, (Object)gets, writes.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deleteItem), (Object)BoxesRunTime.boxToInteger((int)index))));
                            }
                            return tuple33;
                        }
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            Tuple2 tuple25 = (Tuple2)tuple2._2();
            if (tuple3 == null) throw new MatchError((Object)tuple2);
            Chunk nonBatched = (Chunk)tuple3._1();
            Chunk gets = (Chunk)tuple3._2();
            Chunk writes = (Chunk)tuple3._3();
            if (tuple25 == null) throw new MatchError((Object)tuple2);
            DynamoDBQuery.Constructor nonGetItem = (DynamoDBQuery.Constructor)tuple25._1();
            int index = tuple25._2$mcI$sp();
            return new Tuple3(nonBatched.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonGetItem), (Object)BoxesRunTime.boxToInteger((int)index))), (Object)gets, (Object)writes);
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Chunk indexedNonBatched = (Chunk)tuple3._1();
        Chunk indexedGets = (Chunk)tuple3._2();
        Chunk indexedWrites = (Chunk)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)indexedNonBatched, (Object)indexedGets, (Object)indexedWrites);
        Tuple3 tuple33 = tuple32;
        Chunk indexedNonBatched2 = (Chunk)tuple33._1();
        Chunk indexedGets2 = (Chunk)tuple33._2();
        Chunk indexedWrites2 = (Chunk)tuple33._3();
        Tuple2 indexedBatchGetItem = (Tuple2)indexedGets2.foldLeft((Object)new Tuple2((Object)new DynamoDBQuery.BatchGetItem(DynamoDBQuery$BatchGetItem$.MODULE$.apply$default$1(), DynamoDBQuery$BatchGetItem$.MODULE$.apply$default$2(), DynamoDBQuery$BatchGetItem$.MODULE$.apply$default$3(), DynamoDBQuery$BatchGetItem$.MODULE$.apply$default$4()), (Object)Chunk$.MODULE$.empty()), (Function2 & Serializable)(x0$2, x1$2) -> {
            Chunk indexes;
            DynamoDBQuery.BatchGetItem batchGetItem;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$2);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    batchGetItem = (DynamoDBQuery.BatchGetItem)tuple23._1();
                    indexes = (Chunk)tuple23._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            DynamoDBQuery.GetItem getItem = (DynamoDBQuery.GetItem)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Tuple2 tuple24 = new Tuple2((Object)batchGetItem.$plus(getItem), indexes.$colon$plus((Object)BoxesRunTime.boxToInteger((int)index)));
            return tuple24;
        });
        Tuple2 indexedBatchWrite = (Tuple2)indexedWrites2.foldLeft((Object)new Tuple2((Object)new DynamoDBQuery.BatchWriteItem(DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$1(), DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$2(), DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$3(), DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$4(), DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$5()), (Object)Chunk$.MODULE$.empty()), (Function2 & Serializable)(x0$3, x1$3) -> {
            Chunk indexes;
            DynamoDBQuery.BatchWriteItem batchWriteItem;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$3, x1$3);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    batchWriteItem = (DynamoDBQuery.BatchWriteItem)tuple23._1();
                    indexes = (Chunk)tuple23._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            DynamoDBQuery.Write writeItem = (DynamoDBQuery.Write)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Tuple2 tuple24 = new Tuple2((Object)batchWriteItem.$plus(writeItem), indexes.$colon$plus((Object)BoxesRunTime.boxToInteger((int)index)));
            return tuple24;
        });
        return new Tuple3((Object)indexedNonBatched2, (Object)indexedBatchGetItem, (Object)indexedBatchWrite);
    }

    public <In, A> Tuple2<Chunk<DynamoDBQuery.Constructor<In, Object>>, Function1<Chunk<Object>, A>> parallelize(DynamoDBQuery<In, A> query) {
        Tuple2 tuple2;
        block40: {
            DynamoDBQuery<In, A> dynamoDBQuery;
            while (true) {
                if ((dynamoDBQuery = query) instanceof DynamoDBQuery.Map) {
                    DynamoDBQuery.Map map = (DynamoDBQuery.Map)dynamoDBQuery;
                    DynamoDBQuery query2 = map.query();
                    Function1 mapper = map.mapper();
                    Tuple2 tuple22 = this.parallelize(query2);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Chunk constructors = (Chunk)tuple22._1();
                    Function1 assembler = (Function1)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)constructors, (Object)assembler.andThen(mapper));
                    tuple2 = tuple23;
                    break block40;
                }
                if (dynamoDBQuery instanceof DynamoDBQuery.Zip) {
                    DynamoDBQuery.Zip zip = (DynamoDBQuery.Zip)dynamoDBQuery;
                    Tuple2 tuple24 = this.parallelize(zip.left());
                    if (tuple24 == null) {
                        throw new MatchError(tuple24);
                    }
                    Chunk constructorsLeft = (Chunk)tuple24._1();
                    Function1 assemblerLeft = (Function1)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)constructorsLeft, (Object)assemblerLeft);
                    Tuple2 tuple26 = tuple25;
                    Chunk constructorsLeft2 = (Chunk)tuple26._1();
                    Function1 assemblerLeft2 = (Function1)tuple26._2();
                    Tuple2 tuple27 = this.parallelize(zip.right());
                    if (tuple27 == null) {
                        throw new MatchError(tuple27);
                    }
                    Chunk constructorsRight = (Chunk)tuple27._1();
                    Function1 assemblerRight = (Function1)tuple27._2();
                    Tuple2 tuple28 = new Tuple2((Object)constructorsRight, (Object)assemblerRight);
                    Tuple2 tuple29 = tuple28;
                    Chunk constructorsRight2 = (Chunk)tuple29._1();
                    Function1 assemblerRight2 = (Function1)tuple29._2();
                    tuple2 = new Tuple2((Object)constructorsLeft2.$plus$plus(constructorsRight2), (Function1 & Serializable)results -> {
                        Tuple2 tuple2 = results.splitAt(constructorsLeft2.length());
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Chunk leftResults = (Chunk)tuple2._1();
                        Chunk rightResults = (Chunk)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)leftResults, (Object)rightResults);
                        Tuple2 tuple23 = tuple22;
                        Chunk leftResults2 = (Chunk)tuple23._1();
                        Chunk rightResults2 = (Chunk)tuple23._2();
                        Object left = assemblerLeft2.apply((Object)leftResults2);
                        Object right = assemblerRight2.apply((Object)rightResults2);
                        return zip.zippable().zip(left, right);
                    });
                    break block40;
                }
                if (!(dynamoDBQuery instanceof DynamoDBQuery.Absolve)) break;
                DynamoDBQuery.Absolve absolve = (DynamoDBQuery.Absolve)dynamoDBQuery;
                DynamoDBQuery query3 = absolve.query();
                DynamoDBQuery absolved = query3.map((Function1 & Serializable)x0$1 -> {
                    Object a;
                    Either either = x0$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        DynamoDBError dynamoDBError = (DynamoDBError)left.value();
                        throw (Throwable)((Object)dynamoDBError);
                    }
                    if (!(either instanceof Right)) {
                        throw new MatchError((Object)either);
                    }
                    Right right = (Right)either;
                    Object object = a = right.value();
                    return object;
                });
                query = absolved;
            }
            if (dynamoDBQuery instanceof DynamoDBQuery.Fail) {
                DynamoDBQuery.Fail fail = (DynamoDBQuery.Fail)dynamoDBQuery;
                Function0<DynamoDBError> error = fail.error();
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.empty(), (Function1 & Serializable)x$24 -> error.apply());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.Succeed) {
                DynamoDBQuery.Succeed succeed = (DynamoDBQuery.Succeed)dynamoDBQuery;
                Function0 value = succeed.value();
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.empty(), (Function1 & Serializable)x$25 -> value.apply());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.BatchGetItem) {
                DynamoDBQuery.BatchGetItem batchGetItem = (DynamoDBQuery.BatchGetItem)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.BatchGetItem[]{batchGetItem})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.BatchWriteItem) {
                DynamoDBQuery.BatchWriteItem batchWriteItem = (DynamoDBQuery.BatchWriteItem)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.BatchWriteItem[]{batchWriteItem})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.DeleteTable) {
                DynamoDBQuery.DeleteTable deleteTable = (DynamoDBQuery.DeleteTable)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.DeleteTable[]{deleteTable})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.DescribeTable) {
                DynamoDBQuery.DescribeTable describeTable = (DynamoDBQuery.DescribeTable)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.DescribeTable[]{describeTable})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.ConditionCheck) {
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Nil$.MODULE$), (Function1 & Serializable)x$26 -> BoxedUnit.UNIT);
            } else if (dynamoDBQuery instanceof DynamoDBQuery.GetItem) {
                DynamoDBQuery.GetItem getItem = (DynamoDBQuery.GetItem)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.GetItem[]{getItem})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.PutItem) {
                DynamoDBQuery.PutItem putItem = (DynamoDBQuery.PutItem)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.PutItem[]{putItem})), (Function1 & Serializable)results -> results.isEmpty() ? BoxedUnit.UNIT : results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.Transaction) {
                DynamoDBQuery.Transaction transaction = (DynamoDBQuery.Transaction)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.Transaction[]{transaction})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.UpdateItem) {
                DynamoDBQuery.UpdateItem updateItem = (DynamoDBQuery.UpdateItem)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.UpdateItem[]{updateItem})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.DeleteItem) {
                DynamoDBQuery.DeleteItem deleteItem = (DynamoDBQuery.DeleteItem)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.DeleteItem[]{deleteItem})), (Function1 & Serializable)results -> results.isEmpty() ? BoxedUnit.UNIT : results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.ScanSome) {
                DynamoDBQuery.ScanSome scanSome = (DynamoDBQuery.ScanSome)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.ScanSome[]{scanSome})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.ScanAll) {
                DynamoDBQuery.ScanAll scanAll = (DynamoDBQuery.ScanAll)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.ScanAll[]{scanAll})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.QuerySome) {
                DynamoDBQuery.QuerySome querySome = (DynamoDBQuery.QuerySome)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.QuerySome[]{querySome})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.QueryAll) {
                DynamoDBQuery.QueryAll queryAll = (DynamoDBQuery.QueryAll)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.QueryAll[]{queryAll})), (Function1 & Serializable)results -> results.head());
            } else if (dynamoDBQuery instanceof DynamoDBQuery.CreateTable) {
                DynamoDBQuery.CreateTable createTable = (DynamoDBQuery.CreateTable)dynamoDBQuery;
                tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.CreateTable[]{createTable})), (Function1 & Serializable)results -> results.head());
            } else {
                throw new MatchError(dynamoDBQuery);
            }
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$batched$1(boolean x$19) {
        return x$19;
    }

    private static final boolean projectionsContainPrimaryKey$1(List pes, AttrMap pk) {
        List matchedPrimaryKeys = pes.collect((PartialFunction)new Serializable(pk){
            private static final long serialVersionUID = 0L;
            private final AttrMap pk$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends ProjectionExpression<?, ?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ProjectionExpression.MapElement) {
                    ProjectionExpression.MapElement mapElement = (ProjectionExpression.MapElement)A1;
                    ProjectionExpression<From, ?> projectionExpression = mapElement.parent();
                    String key = mapElement.key();
                    if (ProjectionExpression$Root$.MODULE$.equals(projectionExpression) && this.pk$1.map().keySet().contains((Object)key)) {
                        object = BoxesRunTime.boxToBoolean((boolean)true);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(ProjectionExpression<?, ?> x1) {
                ProjectionExpression<?, ?> projectionExpression = x1;
                if (!(projectionExpression instanceof ProjectionExpression.MapElement)) return false;
                ProjectionExpression.MapElement mapElement = (ProjectionExpression.MapElement)projectionExpression;
                ProjectionExpression<From, ?> projectionExpression2 = mapElement.parent();
                String key = mapElement.key();
                if (!ProjectionExpression$Root$.MODULE$.equals(projectionExpression2)) return false;
                if (!this.pk$1.map().keySet().contains((Object)key)) return false;
                return true;
            }
            {
                this.pk$1 = pk$1;
            }
        });
        boolean hasNoProjections = pes.size() == 0;
        return hasNoProjections || matchedPrimaryKeys.filter((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DynamoDBQuery$.$anonfun$batched$1(BoxesRunTime.unboxToBoolean((Object)x$19)))).size() == pk.map().size();
    }

    private DynamoDBQuery$() {
    }
}

