/*
 * Decompiled with CFR 0.152.
 */
package zio.dynamodb;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike$;
import zio.ZIO$;
import zio.dynamodb.AttrMap;
import zio.dynamodb.AttributeDefinition;
import zio.dynamodb.AttributeValue$;
import zio.dynamodb.BillingMode;
import zio.dynamodb.ConditionExpression;
import zio.dynamodb.ConsistencyMode;
import zio.dynamodb.DynamoDBError;
import zio.dynamodb.DynamoDBQuery;
import zio.dynamodb.DynamoDBQuery$BatchGetItem$;
import zio.dynamodb.DynamoDBQuery$BatchWriteItem$;
import zio.dynamodb.DynamoDBQuery$CreateTable$;
import zio.dynamodb.DynamoDBQuery$DeleteItem$;
import zio.dynamodb.DynamoDBQuery$GetItem$;
import zio.dynamodb.DynamoDBQuery$PutItem$;
import zio.dynamodb.DynamoDBQuery$QueryAll$;
import zio.dynamodb.DynamoDBQuery$QuerySome$;
import zio.dynamodb.DynamoDBQuery$ScanAll$;
import zio.dynamodb.DynamoDBQuery$ScanSome$;
import zio.dynamodb.DynamoDBQuery$UpdateItem$;
import zio.dynamodb.EitherUtil$;
import zio.dynamodb.FromAttributeValue$;
import zio.dynamodb.GlobalSecondaryIndex;
import zio.dynamodb.IndexName;
import zio.dynamodb.KeyConditionExpression;
import zio.dynamodb.KeySchema;
import zio.dynamodb.LocalSecondaryIndex;
import zio.dynamodb.NonEmptySet;
import zio.dynamodb.NonEmptySet$;
import zio.dynamodb.ProjectionExpression;
import zio.dynamodb.ReturnConsumedCapacity;
import zio.dynamodb.SSESpecification;
import zio.dynamodb.Select;
import zio.dynamodb.Select$AllAttributes$;
import zio.dynamodb.Select$SpecificAttributes$;
import zio.dynamodb.TableName;
import zio.dynamodb.ToAttributeValue$;
import zio.dynamodb.UpdateExpression;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.stream.ZStream;

public final class DynamoDBQuery$ {
    public static DynamoDBQuery$ MODULE$;

    static {
        new DynamoDBQuery$();
    }

    public <In, A> DynamoDBQuery<In, A> succeed(Function0<A> a) {
        return new DynamoDBQuery.Succeed<A>(a);
    }

    public <In, A, B> DynamoDBQuery<In, List<B>> forEach(Iterable<A> values, Function1<A, DynamoDBQuery<In, B>> body) {
        return (DynamoDBQuery)values.foldRight(this.succeed((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            DynamoDBQuery query = x1$1;
            return ((DynamoDBQuery)body.apply(x0$1)).zipWith(query, (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> x$8.$colon$colon(x$7));
        });
    }

    public DynamoDBQuery<Object, Option<AttrMap>> getItem(String tableName, AttrMap key, Seq<ProjectionExpression<?, ?>> projections) {
        return new DynamoDBQuery.GetItem(new TableName(tableName), key, projections.toList(), DynamoDBQuery$GetItem$.MODULE$.apply$default$4(), DynamoDBQuery$GetItem$.MODULE$.apply$default$5());
    }

    public <A> DynamoDBQuery<A, Either<DynamoDBError, A>> get(String tableName, AttrMap key, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$1) {
        return this.getItem(tableName, key, projections).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (x0$1 instanceof Some) {
                AttrMap item = (AttrMap)((Some)x0$1).value();
                left = MODULE$.fromItem(item, evidence$1);
            } else if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)new DynamoDBError.ValueNotFound(new StringBuilder(25).append("value with key ").append(key).append(" not found").toString()));
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
    }

    public <A> Either<DynamoDBError, A> fromItem(AttrMap item, Schema<A> evidence$2) {
        return ToAttributeValue$.MODULE$.attrMapToAttributeValue().toAttributeValue(item).decode(Schema$.MODULE$.apply(evidence$2));
    }

    public DynamoDBQuery<Object, Option<AttrMap>> putItem(String tableName, AttrMap item) {
        return new DynamoDBQuery.PutItem(new TableName(tableName), item, DynamoDBQuery$PutItem$.MODULE$.apply$default$3(), DynamoDBQuery$PutItem$.MODULE$.apply$default$4(), DynamoDBQuery$PutItem$.MODULE$.apply$default$5(), DynamoDBQuery$PutItem$.MODULE$.apply$default$6());
    }

    public <A> DynamoDBQuery<A, Option<A>> put(String tableName, A a, Schema<A> evidence$3) {
        return this.putItem(tableName, this.toItem(a, evidence$3)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.flatMap((Function1 & Serializable & scala.Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$3).toOption()));
    }

    public <A> AttrMap toItem(A a, Schema<A> schema) {
        return (AttrMap)FromAttributeValue$.MODULE$.attrMapFromAttributeValue().fromAttributeValue(AttributeValue$.MODULE$.encode(a, schema)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(15).append("error encoding ").append(a).toString());
        });
    }

    public <A> DynamoDBQuery<A, Option<AttrMap>> updateItem(String tableName, AttrMap key, UpdateExpression.Action<A> action) {
        return new DynamoDBQuery.UpdateItem(new TableName(tableName), key, new UpdateExpression<A>(action), DynamoDBQuery$UpdateItem$.MODULE$.apply$default$4(), DynamoDBQuery$UpdateItem$.MODULE$.apply$default$5(), DynamoDBQuery$UpdateItem$.MODULE$.apply$default$6(), DynamoDBQuery$UpdateItem$.MODULE$.apply$default$7());
    }

    public <A> DynamoDBQuery<A, Option<A>> update(String tableName, AttrMap key, UpdateExpression.Action<A> action, Schema<A> evidence$4) {
        return this.updateItem(tableName, key, action).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.flatMap((Function1 & Serializable & scala.Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$4).toOption()));
    }

    public DynamoDBQuery.Write<Object, Option<AttrMap>> deleteItem(String tableName, AttrMap key) {
        return new DynamoDBQuery.DeleteItem(new TableName(tableName), key, DynamoDBQuery$DeleteItem$.MODULE$.apply$default$3(), DynamoDBQuery$DeleteItem$.MODULE$.apply$default$4(), DynamoDBQuery$DeleteItem$.MODULE$.apply$default$5(), DynamoDBQuery$DeleteItem$.MODULE$.apply$default$6());
    }

    public <A> DynamoDBQuery<Object, Option<A>> delete(String tableName, AttrMap key, Schema<A> evidence$5) {
        return this.deleteItem(tableName, key).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.flatMap((Function1 & Serializable & scala.Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$5).toOption()));
    }

    public DynamoDBQuery.ScanSome scanSomeItem(String tableName, int limit, Seq<ProjectionExpression<?, ?>> projections) {
        TableName x$1 = new TableName(tableName);
        Option<Select> x$3 = this.selectOrAll(projections);
        List x$4 = projections.toList();
        Option<IndexName> x$5 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$3();
        ConsistencyMode x$6 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$4();
        Option<AttrMap> x$7 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$5();
        Option<ConditionExpression<?>> x$8 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$6();
        ReturnConsumedCapacity x$9 = DynamoDBQuery$ScanSome$.MODULE$.apply$default$8();
        return new DynamoDBQuery.ScanSome(x$1, limit, x$5, x$6, x$7, x$8, x$4, x$9, x$3);
    }

    public <A> DynamoDBQuery<A, Either<DynamoDBError, Tuple2<Chunk<A>, Option<AttrMap>>>> scanSome(String tableName, int limit, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$6) {
        return this.scanSomeItem(tableName, limit, projections).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            Chunk itemsChunk = (Chunk)x0$1._1();
            Option lek = (Option)x0$1._2();
            Either either = EitherUtil$.MODULE$.forEach(itemsChunk, (Function1 & Serializable & scala.Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$6)).map((Function1 & Serializable & scala.Serializable)it -> Chunk$.MODULE$.fromIterable(it));
            if (either instanceof Right) {
                Chunk chunk = (Chunk)((Right)either).value();
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)chunk, (Object)lek));
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            DynamoDBError error = (DynamoDBError)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)error);
        });
    }

    public DynamoDBQuery.ScanAll scanAllItem(String tableName, Seq<ProjectionExpression<?, ?>> projections) {
        TableName x$1 = new TableName(tableName);
        Option<Select> x$2 = this.selectOrAll(projections);
        List x$3 = projections.toList();
        Option<IndexName> x$4 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$2();
        Option<Object> x$5 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$3();
        ConsistencyMode x$6 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$4();
        Option<AttrMap> x$7 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$5();
        Option<ConditionExpression<?>> x$8 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$6();
        ReturnConsumedCapacity x$9 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$8();
        int x$10 = DynamoDBQuery$ScanAll$.MODULE$.apply$default$10();
        return new DynamoDBQuery.ScanAll(x$1, x$4, x$5, x$6, x$7, x$8, x$3, x$9, x$2, x$10);
    }

    public <A> DynamoDBQuery<A, ZStream<Object, Throwable, A>> scanAll(String tableName, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$7) {
        return this.scanAllItem(tableName, projections).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.mapZIO((Function1 & Serializable & scala.Serializable)item -> ZIO$.MODULE$.fromEither((Function0 & Serializable & scala.Serializable)() -> MODULE$.fromItem((AttrMap)item, evidence$7), (Object)"zio.dynamodb.DynamoDBQuery.scanAll(DynamoDBQuery.scala:535)").mapError((Function1 & Serializable & scala.Serializable)x$14 -> new IllegalStateException((Throwable)((Object)x$14)), CanFail$.MODULE$.canFail(), (Object)"zio.dynamodb.DynamoDBQuery.scanAll(DynamoDBQuery.scala:535)"), (Object)"zio.dynamodb.DynamoDBQuery.scanAll(DynamoDBQuery.scala:535)"));
    }

    public DynamoDBQuery.QuerySome querySomeItem(String tableName, int limit, Seq<ProjectionExpression<?, ?>> projections) {
        TableName x$1 = new TableName(tableName);
        Option<Select> x$3 = this.selectOrAll(projections);
        List x$4 = projections.toList();
        Option<IndexName> x$5 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$3();
        ConsistencyMode x$6 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$4();
        Option<AttrMap> x$7 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$5();
        Option<ConditionExpression<?>> x$8 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$6();
        Option<KeyConditionExpression> x$9 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$7();
        ReturnConsumedCapacity x$10 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$9();
        boolean x$11 = DynamoDBQuery$QuerySome$.MODULE$.apply$default$11();
        return new DynamoDBQuery.QuerySome(x$1, limit, x$5, x$6, x$7, x$8, x$9, x$4, x$10, x$3, x$11);
    }

    public <A> DynamoDBQuery<A, Either<DynamoDBError, Tuple2<Chunk<A>, Option<AttrMap>>>> querySome(String tableName, int limit, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$8) {
        return this.querySomeItem(tableName, limit, projections).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            Chunk itemsChunk = (Chunk)x0$1._1();
            Option lek = (Option)x0$1._2();
            Either either = EitherUtil$.MODULE$.forEach(itemsChunk, (Function1 & Serializable & scala.Serializable)item -> MODULE$.fromItem((AttrMap)item, evidence$8)).map((Function1 & Serializable & scala.Serializable)it -> Chunk$.MODULE$.fromIterable(it));
            if (either instanceof Right) {
                Chunk chunk = (Chunk)((Right)either).value();
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)chunk, (Object)lek));
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            DynamoDBError error = (DynamoDBError)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)error);
        });
    }

    public DynamoDBQuery.QueryAll queryAllItem(String tableName, Seq<ProjectionExpression<?, ?>> projections) {
        TableName x$1 = new TableName(tableName);
        Option<Select> x$2 = this.selectOrAll(projections);
        List x$3 = projections.toList();
        Option<IndexName> x$4 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$2();
        Option<Object> x$5 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$3();
        ConsistencyMode x$6 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$4();
        Option<AttrMap> x$7 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$5();
        Option<ConditionExpression<?>> x$8 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$6();
        Option<KeyConditionExpression> x$9 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$7();
        ReturnConsumedCapacity x$10 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$9();
        boolean x$11 = DynamoDBQuery$QueryAll$.MODULE$.apply$default$11();
        return new DynamoDBQuery.QueryAll(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$3, x$10, x$2, x$11);
    }

    public <A> DynamoDBQuery<A, ZStream<Object, Throwable, A>> queryAll(String tableName, Seq<ProjectionExpression<?, ?>> projections, Schema<A> evidence$9) {
        return this.queryAllItem(tableName, projections).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.mapZIO((Function1 & Serializable & scala.Serializable)item -> ZIO$.MODULE$.fromEither((Function0 & Serializable & scala.Serializable)() -> MODULE$.fromItem((AttrMap)item, evidence$9), (Object)"zio.dynamodb.DynamoDBQuery.queryAll(DynamoDBQuery.scala:584)").mapError((Function1 & Serializable & scala.Serializable)x$16 -> new IllegalStateException((Throwable)((Object)x$16)), CanFail$.MODULE$.canFail(), (Object)"zio.dynamodb.DynamoDBQuery.queryAll(DynamoDBQuery.scala:584)"), (Object)"zio.dynamodb.DynamoDBQuery.queryAll(DynamoDBQuery.scala:584)"));
    }

    public DynamoDBQuery.CreateTable createTable(String tableName, KeySchema keySchema, BillingMode billingMode, Option<SSESpecification> sseSpecification, Map<String, String> tags, AttributeDefinition attributeDefinition, Seq<AttributeDefinition> attributeDefinitions) {
        TableName x$1 = new TableName(tableName);
        NonEmptySet<AttributeDefinition> x$3 = NonEmptySet$.MODULE$.apply(attributeDefinition, attributeDefinitions);
        Set<GlobalSecondaryIndex> x$7 = DynamoDBQuery$CreateTable$.MODULE$.apply$default$5();
        Set<LocalSecondaryIndex> x$8 = DynamoDBQuery$CreateTable$.MODULE$.apply$default$6();
        return new DynamoDBQuery.CreateTable(x$1, keySchema, x$3, billingMode, x$7, x$8, sseSpecification, tags);
    }

    public Option<SSESpecification> createTable$default$4() {
        return None$.MODULE$;
    }

    public Map<String, String> createTable$default$5() {
        return Map$.MODULE$.empty();
    }

    public DynamoDBQuery.ConditionCheck conditionCheck(String tableName, AttrMap primaryKey, ConditionExpression<?> conditionExpression) {
        return new DynamoDBQuery.ConditionCheck(new TableName(tableName), primaryKey, conditionExpression);
    }

    public DynamoDBQuery.DeleteTable deleteTable(String tableName) {
        return new DynamoDBQuery.DeleteTable(new TableName(tableName));
    }

    public DynamoDBQuery.DescribeTable describeTable(String tableName) {
        return new DynamoDBQuery.DescribeTable(new TableName(tableName));
    }

    private Option<Select> selectOrAll(Seq<ProjectionExpression<?, ?>> projections) {
        return new Some((Object)(projections.isEmpty() ? Select$AllAttributes$.MODULE$ : Select$SpecificAttributes$.MODULE$));
    }

    public <A> DynamoDBQuery<Object, A> apply(Function0<A> a) {
        return new DynamoDBQuery.Succeed<A>(a);
    }

    public <In> Tuple3<Chunk<Tuple2<DynamoDBQuery.Constructor<In, Object>, Object>>, Tuple2<DynamoDBQuery.BatchGetItem, Chunk<Object>>, Tuple2<DynamoDBQuery.BatchWriteItem, Chunk<Object>>> batched(Chunk<DynamoDBQuery.Constructor<In, Object>> constructors) {
        Tuple3 tuple3 = (Tuple3)constructors.zipWithIndex().foldLeft((Object)new Tuple3((Object)Chunk$.MODULE$.empty(), (Object)Chunk$.MODULE$.empty(), (Object)Chunk$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            Tuple3 tuple3 = x0$1;
            Tuple2 tuple22 = x1$1;
            if (tuple3 != null) {
                Chunk nonBatched = (Chunk)tuple3._1();
                Chunk gets = (Chunk)tuple3._2();
                Chunk writes = (Chunk)tuple3._3();
                if (tuple22 != null) {
                    DynamoDBQuery.Constructor get = (DynamoDBQuery.Constructor)tuple22._1();
                    int index = tuple22._2$mcI$sp();
                    if (get instanceof DynamoDBQuery.GetItem) {
                        DynamoDBQuery.GetItem getItem = (DynamoDBQuery.GetItem)get;
                        return new Tuple3((Object)nonBatched, gets.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)getItem), (Object)BoxesRunTime.boxToInteger((int)index)), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())), (Object)writes);
                    }
                }
            }
            Tuple3 tuple32 = x0$1;
            Tuple2 tuple23 = x1$1;
            if (tuple32 != null) {
                Chunk nonBatched = (Chunk)tuple32._1();
                Chunk gets = (Chunk)tuple32._2();
                Chunk writes = (Chunk)tuple32._3();
                if (tuple23 != null) {
                    DynamoDBQuery.Constructor put = (DynamoDBQuery.Constructor)tuple23._1();
                    int index = tuple23._2$mcI$sp();
                    if (put instanceof DynamoDBQuery.PutItem) {
                        Tuple3 tuple33;
                        DynamoDBQuery.PutItem putItem = (DynamoDBQuery.PutItem)put;
                        Option<ConditionExpression<?>> conditionExpression = putItem.conditionExpression();
                        if (conditionExpression instanceof Some) {
                            tuple33 = new Tuple3(nonBatched.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)putItem), (Object)BoxesRunTime.boxToInteger((int)index)), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())), (Object)gets, (Object)writes);
                            return tuple33;
                        } else {
                            if (!None$.MODULE$.equals(conditionExpression)) throw new MatchError(conditionExpression);
                            tuple33 = new Tuple3((Object)nonBatched, (Object)gets, writes.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)putItem), (Object)BoxesRunTime.boxToInteger((int)index)), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())));
                        }
                        return tuple33;
                    }
                }
            }
            if (tuple2 != null) {
                Tuple3 tuple34 = x0$1;
                Tuple2 tuple24 = x1$1;
                if (tuple34 != null) {
                    Chunk nonBatched = (Chunk)tuple34._1();
                    Chunk gets = (Chunk)tuple34._2();
                    Chunk writes = (Chunk)tuple34._3();
                    if (tuple24 != null) {
                        DynamoDBQuery.Constructor delete = (DynamoDBQuery.Constructor)tuple24._1();
                        int index = tuple24._2$mcI$sp();
                        if (delete instanceof DynamoDBQuery.DeleteItem) {
                            Tuple3 tuple35;
                            DynamoDBQuery.DeleteItem deleteItem = (DynamoDBQuery.DeleteItem)delete;
                            Option<ConditionExpression<?>> conditionExpression = deleteItem.conditionExpression();
                            if (conditionExpression instanceof Some) {
                                tuple35 = new Tuple3(nonBatched.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deleteItem), (Object)BoxesRunTime.boxToInteger((int)index)), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())), (Object)gets, (Object)writes);
                                return tuple35;
                            } else {
                                if (!None$.MODULE$.equals(conditionExpression)) throw new MatchError(conditionExpression);
                                tuple35 = new Tuple3((Object)nonBatched, (Object)gets, writes.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deleteItem), (Object)BoxesRunTime.boxToInteger((int)index)), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())));
                            }
                            return tuple35;
                        }
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple3 tuple36 = x0$1;
            Tuple2 tuple25 = x1$1;
            if (tuple36 == null) throw new MatchError((Object)tuple2);
            Chunk nonBatched = (Chunk)tuple36._1();
            Chunk gets = (Chunk)tuple36._2();
            Chunk writes = (Chunk)tuple36._3();
            if (tuple25 == null) throw new MatchError((Object)tuple2);
            DynamoDBQuery.Constructor nonGetItem = (DynamoDBQuery.Constructor)tuple25._1();
            int index = tuple25._2$mcI$sp();
            return new Tuple3(nonBatched.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonGetItem), (Object)BoxesRunTime.boxToInteger((int)index)), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())), (Object)gets, (Object)writes);
        });
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Chunk chunk = (Chunk)tuple3._1();
        Chunk chunk2 = (Chunk)tuple3._2();
        Chunk chunk3 = (Chunk)tuple3._3();
        Chunk nonBatched = chunk;
        Chunk gets = chunk2;
        Chunk writes = chunk3;
        Tuple2 indexedBatchGetItem = (Tuple2)gets.foldLeft((Object)new Tuple2((Object)new DynamoDBQuery.BatchGetItem(DynamoDBQuery$BatchGetItem$.MODULE$.apply$default$1(), DynamoDBQuery$BatchGetItem$.MODULE$.apply$default$2(), DynamoDBQuery$BatchGetItem$.MODULE$.apply$default$3(), DynamoDBQuery$BatchGetItem$.MODULE$.apply$default$4()), (Object)Chunk$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Chunk indexes;
            DynamoDBQuery.BatchGetItem batchGetItem;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$2);
                    Tuple2 tuple23 = x0$2;
                    tuple2 = x1$2;
                    if (tuple23 == null) break block2;
                    batchGetItem = (DynamoDBQuery.BatchGetItem)tuple23._1();
                    indexes = (Chunk)tuple23._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            DynamoDBQuery.GetItem getItem = (DynamoDBQuery.GetItem)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Tuple2 tuple24 = new Tuple2((Object)batchGetItem.$plus(getItem), indexes.$colon$plus((Object)BoxesRunTime.boxToInteger((int)index), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.chunkCanBuildFromInt())));
            return tuple24;
        });
        Tuple2 indexedBatchWrite = (Tuple2)writes.foldLeft((Object)new Tuple2((Object)new DynamoDBQuery.BatchWriteItem(DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$1(), DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$2(), DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$3(), DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$4(), DynamoDBQuery$BatchWriteItem$.MODULE$.apply$default$5()), (Object)Chunk$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
            Chunk indexes;
            DynamoDBQuery.BatchWriteItem batchWriteItem;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$3, x1$3);
                    Tuple2 tuple23 = x0$3;
                    tuple2 = x1$3;
                    if (tuple23 == null) break block2;
                    batchWriteItem = (DynamoDBQuery.BatchWriteItem)tuple23._1();
                    indexes = (Chunk)tuple23._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            DynamoDBQuery.Write writeItem = (DynamoDBQuery.Write)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Tuple2 tuple24 = new Tuple2((Object)batchWriteItem.$plus(writeItem), indexes.$colon$plus((Object)BoxesRunTime.boxToInteger((int)index), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.chunkCanBuildFromInt())));
            return tuple24;
        });
        return new Tuple3((Object)nonBatched, (Object)indexedBatchGetItem, (Object)indexedBatchWrite);
    }

    public <In, A> Tuple2<Chunk<DynamoDBQuery.Constructor<In, Object>>, Function1<Chunk<Object>, A>> parallelize(DynamoDBQuery<In, A> query) {
        Tuple2 tuple2;
        if (query instanceof DynamoDBQuery.Map) {
            DynamoDBQuery.Map map = (DynamoDBQuery.Map)query;
            DynamoDBQuery query2 = map.query();
            Function1 mapper = map.mapper();
            Tuple2 tuple22 = this.parallelize(query2);
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Chunk constructors = (Chunk)tuple22._1();
            Function1 assembler = (Function1)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)constructors, (Object)assembler.andThen(mapper));
            tuple2 = tuple23;
        } else if (query instanceof DynamoDBQuery.Zip) {
            DynamoDBQuery.Zip zip = (DynamoDBQuery.Zip)query;
            Tuple2 tuple24 = this.parallelize(zip.left());
            if (tuple24 == null) {
                throw new MatchError(null);
            }
            Chunk chunk = (Chunk)tuple24._1();
            Function1 function1 = (Function1)tuple24._2();
            Chunk constructorsLeft = chunk;
            Function1 assemblerLeft = function1;
            Tuple2 tuple25 = this.parallelize(zip.right());
            if (tuple25 == null) {
                throw new MatchError(null);
            }
            Chunk chunk2 = (Chunk)tuple25._1();
            Function1 function12 = (Function1)tuple25._2();
            Chunk constructorsRight = chunk2;
            Function1 assemblerRight = function12;
            tuple2 = new Tuple2((Object)constructorsLeft.$plus$plus(constructorsRight), (Function1 & Serializable & scala.Serializable)results -> {
                Tuple2 tuple2 = results.splitAt(constructorsLeft.length());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Chunk chunk = (Chunk)tuple2._1();
                Chunk chunk2 = (Chunk)tuple2._2();
                Chunk leftResults = chunk;
                Chunk rightResults = chunk2;
                Object left = assemblerLeft.apply((Object)leftResults);
                Object right = assemblerRight.apply((Object)rightResults);
                return zip.zippable().zip(left, right);
            });
        } else if (query instanceof DynamoDBQuery.Succeed) {
            Function0 value = ((DynamoDBQuery.Succeed)query).value();
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)x$21 -> value.apply());
        } else if (query instanceof DynamoDBQuery.BatchGetItem) {
            DynamoDBQuery.BatchGetItem batchGetItem = (DynamoDBQuery.BatchGetItem)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.BatchGetItem[]{batchGetItem})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.BatchWriteItem) {
            DynamoDBQuery.BatchWriteItem batchWriteItem = (DynamoDBQuery.BatchWriteItem)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.BatchWriteItem[]{batchWriteItem})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.DeleteTable) {
            DynamoDBQuery.DeleteTable deleteTable = (DynamoDBQuery.DeleteTable)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.DeleteTable[]{deleteTable})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.DescribeTable) {
            DynamoDBQuery.DescribeTable describeTable = (DynamoDBQuery.DescribeTable)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.DescribeTable[]{describeTable})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.ConditionCheck) {
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Nil$.MODULE$), (Function1 & Serializable & scala.Serializable)x$22 -> BoxedUnit.UNIT);
        } else if (query instanceof DynamoDBQuery.GetItem) {
            DynamoDBQuery.GetItem getItem = (DynamoDBQuery.GetItem)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.GetItem[]{getItem})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.PutItem) {
            DynamoDBQuery.PutItem putItem = (DynamoDBQuery.PutItem)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.PutItem[]{putItem})), (Function1 & Serializable & scala.Serializable)results -> {
                if (results.isEmpty()) {
                    return BoxedUnit.UNIT;
                }
                return results.head();
            });
        } else if (query instanceof DynamoDBQuery.Transaction) {
            DynamoDBQuery.Transaction transaction = (DynamoDBQuery.Transaction)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.Transaction[]{transaction})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.UpdateItem) {
            DynamoDBQuery.UpdateItem updateItem = (DynamoDBQuery.UpdateItem)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.UpdateItem[]{updateItem})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.DeleteItem) {
            DynamoDBQuery.DeleteItem deleteItem = (DynamoDBQuery.DeleteItem)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.DeleteItem[]{deleteItem})), (Function1 & Serializable & scala.Serializable)results -> {
                if (results.isEmpty()) {
                    return BoxedUnit.UNIT;
                }
                return results.head();
            });
        } else if (query instanceof DynamoDBQuery.ScanSome) {
            DynamoDBQuery.ScanSome scanSome = (DynamoDBQuery.ScanSome)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.ScanSome[]{scanSome})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.ScanAll) {
            DynamoDBQuery.ScanAll scanAll = (DynamoDBQuery.ScanAll)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.ScanAll[]{scanAll})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.QuerySome) {
            DynamoDBQuery.QuerySome querySome = (DynamoDBQuery.QuerySome)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.QuerySome[]{querySome})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.QueryAll) {
            DynamoDBQuery.QueryAll queryAll = (DynamoDBQuery.QueryAll)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.QueryAll[]{queryAll})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else if (query instanceof DynamoDBQuery.CreateTable) {
            DynamoDBQuery.CreateTable createTable = (DynamoDBQuery.CreateTable)query;
            tuple2 = new Tuple2((Object)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DynamoDBQuery.CreateTable[]{createTable})), (Function1 & Serializable & scala.Serializable)results -> results.head());
        } else {
            throw new MatchError(query);
        }
        return tuple2;
    }

    private DynamoDBQuery$() {
        MODULE$ = this;
    }
}

