/*
 * Decompiled with CFR 0.152.
 */
package zio.connect.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Duration$;
import zio.IsSubtypeOfError$;
import zio.Queue;
import zio.Queue$;
import zio.Ref;
import zio.Ref$;
import zio.Schedule;
import zio.Schedule$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.Zippable$;
import zio.connect.file.FileConnector;
import zio.connect.file.TestFileConnector;
import zio.connect.file.TestFileConnector$;
import zio.connect.file.TestFileConnector$FileSystemNode$;
import zio.connect.file.TestFileConnector$FileSystemNode$Dir$;
import zio.connect.file.TestFileConnector$FileSystemNode$File$;
import zio.connect.file.TestFileConnector$TestFileSystem$;
import zio.stm.STM$;
import zio.stm.TRef;
import zio.stm.ZSTM;
import zio.stm.ZSTM$;
import zio.stream.ZChannel;
import zio.stream.ZSink;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class TestFileConnector
implements FileConnector,
Product,
Serializable {
    private final TestFileSystem fs;

    public static TestFileConnector apply(TestFileSystem testFileSystem) {
        return TestFileConnector$.MODULE$.apply(testFileSystem);
    }

    public static TestFileConnector fromProduct(Product product) {
        return TestFileConnector$.MODULE$.fromProduct(product);
    }

    public static ZLayer<Object, Nothing$, FileConnector> layer() {
        return TestFileConnector$.MODULE$.layer();
    }

    public static TestFileConnector unapply(TestFileConnector testFileConnector) {
        return TestFileConnector$.MODULE$.unapply(testFileConnector);
    }

    public TestFileConnector(TestFileSystem fs) {
        this.fs = fs;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TestFileConnector)) return false;
        TestFileConnector testFileConnector = (TestFileConnector)object;
        TestFileSystem testFileSystem = this.fs();
        TestFileSystem testFileSystem2 = testFileConnector.fs();
        if (testFileSystem != null) {
            if (!((Object)testFileSystem).equals(testFileSystem2)) return false;
            return true;
        }
        if (testFileSystem2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TestFileConnector;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "TestFileConnector";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "fs";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public TestFileSystem fs() {
        return this.fs;
    }

    @Override
    public ZChannel deletePath(Object trace) {
        return ZSink$.MODULE$.foreach((Function1 & Serializable)path -> this.fs().delete((Path)path), trace);
    }

    @Override
    public ZChannel deletePathRecursively(Object trace) {
        return ZSink$.MODULE$.foreach((Function1 & Serializable)path -> this.fs().deleteRecursively((Path)path), trace);
    }

    @Override
    public ZChannel existsPath(Object trace) {
        ZChannel zChannel = ZSink$.MODULE$.take(1, trace);
        ZChannel zChannel2 = ZSink$.MODULE$.map$extension(zChannel, (Function1 & Serializable)_$1 -> _$1.headOption(), trace);
        return ZSink$.MODULE$.mapZIO$extension(zChannel2, (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Path p = (Path)((Some)option).value();
                ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> Files.exists(p, new LinkOption[0]), trace));
                return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
            }
            if (None$.MODULE$.equals(option)) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> false, trace);
            }
            throw new MatchError((Object)option);
        }, trace);
    }

    @Override
    public ZStream<Object, IOException, Path> listPath(Function0<Path> path, Object trace) {
        return ZStream$.MODULE$.unwrap(() -> this.listPath$$anonfun$1(path, trace), trace);
    }

    @Override
    public ZChannel movePathZIO(Function1<Path, ZIO<Object, IOException, Path>> locator, Object trace) {
        return ZSink$.MODULE$.foreach((Function1 & Serializable)oPath -> this.fs().movePath((Path)oPath, (ZIO<Object, IOException, Path>)((ZIO)locator.apply(oPath))), trace);
    }

    @Override
    public ZStream<Object, IOException, Object> readPath(Function0<Path> path, Object trace) {
        return ZStream$.MODULE$.unwrap(() -> this.readPath$$anonfun$1(path, trace), trace);
    }

    @Override
    public ZStream<Object, IOException, Object> tailPath(Function0<Path> path, Function0<Duration> freq, Object trace) {
        return ZStream$.MODULE$.unwrap(() -> this.tailPath$$anonfun$1(path, trace), trace);
    }

    @Override
    public ZStream<Object, IOException, Object> tailPathUsingWatchService(Function0<Path> path, Function0<Duration> freq, Object trace) {
        return this.tailPath(path, freq, trace);
    }

    @Override
    public ZStream<Object, IOException, Path> tempPath(Object trace) {
        boolean bl = ZStream$.MODULE$.unwrapScoped();
        return ZStream.UnwrapScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> this.tempPath$$anonfun$1(trace), trace);
    }

    @Override
    public ZStream<Object, IOException, Path> tempPathIn(Function0<Path> dirPath, Object trace) {
        boolean bl = ZStream$.MODULE$.unwrapScoped();
        return ZStream.UnwrapScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> this.tempPathIn$$anonfun$1(dirPath, trace), trace);
    }

    @Override
    public ZStream<Object, IOException, Path> tempDirPath(Object trace) {
        boolean bl = ZStream$.MODULE$.unwrapScoped();
        return ZStream.UnwrapScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> this.tempDirPath$$anonfun$1(trace), trace);
    }

    @Override
    public ZStream<Object, IOException, Path> tempDirPathIn(Function0<Path> dirPath, Object trace) {
        boolean bl = ZStream$.MODULE$.unwrapScoped();
        return ZStream.UnwrapScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> this.tempDirPathIn$$anonfun$1(dirPath, trace), trace);
    }

    @Override
    public ZChannel writePath(Function0<Path> path, Object trace) {
        ZChannel zChannel = ZSink$.MODULE$.fromZIO(() -> this.writePath$$anonfun$1(path), trace);
        return ZSink$.MODULE$.flatMap$extension(zChannel, (Function1 & Serializable)x$1 -> new ZSink(this.writePath$$anonfun$2((Function0)path, trace, (BoxedUnit)x$1)), (.less.colon.less)$less$colon$less$.MODULE$.refl(), trace);
    }

    public TestFileConnector copy(TestFileSystem fs) {
        return new TestFileConnector(fs);
    }

    public TestFileSystem copy$default$1() {
        return this.fs();
    }

    public TestFileSystem _1() {
        return this.fs();
    }

    private static final Chunk listPath$$anonfun$1$$anonfun$1$$anonfun$1(Chunk a$1) {
        return a$1;
    }

    private final ZIO listPath$$anonfun$1(Function0 path$1, Object trace$2) {
        return this.fs().list((Path)path$1.apply()).map((Function1 & Serializable)a -> ZStream$.MODULE$.fromChunk(() -> TestFileConnector.listPath$$anonfun$1$$anonfun$1$$anonfun$1(a), trace$2), trace$2);
    }

    private static final Chunk readPath$$anonfun$1$$anonfun$1$$anonfun$1(Chunk a$2) {
        return a$2;
    }

    private final ZIO readPath$$anonfun$1(Function0 path$2, Object trace$4) {
        return this.fs().getContent((Path)path$2.apply()).map((Function1 & Serializable)a -> ZStream$.MODULE$.fromChunk(() -> TestFileConnector.readPath$$anonfun$1$$anonfun$1$$anonfun$1(a), trace$4), trace$4);
    }

    private static final /* synthetic */ Tuple2 push$1$$anonfun$1$$anonfun$1(Chunk content$1, int idx) {
        Chunk newContent = content$1.drop(idx);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)idx), (Object)newContent);
    }

    private final ZIO push$1(Function0 path$3, Object trace$6, Ref index, Queue queue) {
        return this.fs().getContent((Path)path$3.apply()).flatMap((Function1 & Serializable)content -> index.get(trace$6).map((Function1 & Serializable)idx -> TestFileConnector.push$1$$anonfun$1$$anonfun$1(content, BoxesRunTime.unboxToInt((Object)idx)), trace$6).flatMap((Function1 & Serializable)x$13 -> {
            Tuple2 tuple2 = x$13;
            if (tuple2 != null) {
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Chunk newContent = (Chunk)tuple2._2();
                return queue.offerAll((Iterable)newContent, trace$6).map((Function1 & Serializable)x$1 -> {
                    Chunk chunk;
                    Chunk $1$ = chunk = x$1;
                    int newIndex = content.length();
                    return Tuple2$.MODULE$.apply((Object)$1$, (Object)BoxesRunTime.boxToInteger((int)newIndex));
                }, trace$6).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        int newIndex = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        return index.set((Object)BoxesRunTime.boxToInteger((int)newIndex), trace$6).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }, trace$6);
                    }
                    throw new MatchError((Object)tuple2);
                }, trace$6);
            }
            throw new MatchError((Object)tuple2);
        }, trace$6), trace$6);
    }

    private static final int tailPath$$anonfun$1$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private static final Schedule tailPath$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(Object trace$13) {
        return Schedule$.MODULE$.recurs(10, trace$13).$amp$amp(Schedule$.MODULE$.spaced(Duration$.MODULE$.fromMillis(100L), trace$13), Zippable$.MODULE$.Zippable2());
    }

    private static final Queue tailPath$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(Queue queue$5) {
        return queue$5;
    }

    private static final int tailPath$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2() {
        return ZStream$.MODULE$.fromQueue$default$2();
    }

    private final ZIO tailPath$$anonfun$1(Function0 path$4, Object trace$10) {
        return Queue$.MODULE$.unbounded(trace$10).flatMap((Function1 & Serializable)queue -> Ref$.MODULE$.make(TestFileConnector::tailPath$$anonfun$1$$anonfun$1$$anonfun$1, trace$10).flatMap((Function1 & Serializable)index -> this.push$1(path$4, trace$10, (Ref)index, (Queue)queue).repeat(() -> TestFileConnector.tailPath$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(trace$10), trace$10).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            return ZStream$.MODULE$.fromQueue(() -> TestFileConnector.tailPath$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(queue), TestFileConnector::tailPath$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2, trace$10);
        }, trace$10), trace$10), trace$10);
    }

    private final ZIO tempPath$$anonfun$1$$anonfun$1() {
        return this.fs().tempPath();
    }

    private static final ZIO tempPath$$anonfun$1$$anonfun$3$$anonfun$1(Object trace$17, Path path$7) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> path$7, trace$17);
    }

    private final ZIO tempPath$$anonfun$1(Object trace$15) {
        return ZIO$.MODULE$.acquireRelease(this::tempPath$$anonfun$1$$anonfun$1, (Function1 & Serializable)path -> this.fs().delete((Path)path).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$15), trace$15).map((Function1 & Serializable)path -> ZStream$.MODULE$.fromZIO(() -> TestFileConnector.tempPath$$anonfun$1$$anonfun$3$$anonfun$1(trace$15, path), trace$15), trace$15);
    }

    private final ZIO tempPathIn$$anonfun$1$$anonfun$1(Function0 dirPath$2) {
        return this.fs().tempPathIn((Path)dirPath$2.apply());
    }

    private static final ZIO tempPathIn$$anonfun$1$$anonfun$3$$anonfun$1(Object trace$21, Path path$9) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> path$9, trace$21);
    }

    private final ZIO tempPathIn$$anonfun$1(Function0 dirPath$1, Object trace$19) {
        return ZIO$.MODULE$.acquireRelease(() -> this.tempPathIn$$anonfun$1$$anonfun$1(dirPath$1), (Function1 & Serializable)path -> this.fs().delete((Path)path).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$19), trace$19).map((Function1 & Serializable)path -> ZStream$.MODULE$.fromZIO(() -> TestFileConnector.tempPathIn$$anonfun$1$$anonfun$3$$anonfun$1(trace$19, path), trace$19), trace$19);
    }

    private final ZIO tempDirPath$$anonfun$1$$anonfun$1() {
        return this.fs().tempDirPath();
    }

    private static final ZIO tempDirPath$$anonfun$1$$anonfun$3$$anonfun$1(Object trace$25, Path path$11) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> path$11, trace$25);
    }

    private final ZIO tempDirPath$$anonfun$1(Object trace$23) {
        return ZIO$.MODULE$.acquireRelease(this::tempDirPath$$anonfun$1$$anonfun$1, (Function1 & Serializable)path -> this.fs().deleteRecursively((Path)path).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$23), trace$23).map((Function1 & Serializable)path -> ZStream$.MODULE$.fromZIO(() -> TestFileConnector.tempDirPath$$anonfun$1$$anonfun$3$$anonfun$1(trace$23, path), trace$23), trace$23);
    }

    private final ZIO tempDirPathIn$$anonfun$1$$anonfun$1(Function0 dirPath$4) {
        return this.fs().tempDirPathIn((Path)dirPath$4.apply());
    }

    private static final ZIO tempDirPathIn$$anonfun$1$$anonfun$3$$anonfun$1(Object trace$29, Path path$13) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> path$13, trace$29);
    }

    private final ZIO tempDirPathIn$$anonfun$1(Function0 dirPath$3, Object trace$27) {
        return ZIO$.MODULE$.acquireRelease(() -> this.tempDirPathIn$$anonfun$1$$anonfun$1(dirPath$3), (Function1 & Serializable)path -> this.fs().deleteRecursively((Path)path).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$27), trace$27).map((Function1 & Serializable)path -> ZStream$.MODULE$.fromZIO(() -> TestFileConnector.tempDirPathIn$$anonfun$1$$anonfun$3$$anonfun$1(trace$27, path), trace$27), trace$27);
    }

    private final ZIO writePath$$anonfun$1(Function0 path$15) {
        return this.fs().removeContentIfExists((Path)path$15.apply());
    }

    private final /* synthetic */ ZChannel writePath$$anonfun$2(Function0 path$16, Object trace$31, BoxedUnit x$12) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        ZChannel zChannel = ZSink$.MODULE$.foreachChunk((Function1 & Serializable)bytes -> this.fs().write((Path)path$16.apply(), (Chunk<Object>)bytes), trace$31);
        return ZSink$.MODULE$.map$extension(zChannel, (Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, trace$31);
    }

    public static interface FileSystemNode {
        public static int ordinal(FileSystemNode fileSystemNode) {
            return TestFileConnector$FileSystemNode$.MODULE$.ordinal(fileSystemNode);
        }

        public Path path();

        public FileSystemNode replacePath(Path var1);
    }

    public static final class TestFileSystem
    implements Product,
    Serializable {
        private final TRef map;

        public static TestFileSystem apply(TRef<Map<Path, FileSystemNode>> tRef) {
            return TestFileConnector$TestFileSystem$.MODULE$.apply(tRef);
        }

        public static TestFileSystem fromProduct(Product product) {
            return TestFileConnector$TestFileSystem$.MODULE$.fromProduct(product);
        }

        public static TestFileSystem unapply(TestFileSystem testFileSystem) {
            return TestFileConnector$TestFileSystem$.MODULE$.unapply(testFileSystem);
        }

        public TestFileSystem(TRef<Map<Path, FileSystemNode>> map) {
            this.map = map;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TestFileSystem)) return false;
            TestFileSystem testFileSystem = (TestFileSystem)object;
            TRef<Map<Path, FileSystemNode>> tRef = this.map();
            TRef<Map<Path, FileSystemNode>> tRef2 = testFileSystem.map();
            if (tRef != null) {
                if (!tRef.equals(tRef2)) return false;
                return true;
            }
            if (tRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TestFileSystem;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TestFileSystem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "map";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TRef<Map<Path, FileSystemNode>> map() {
            return this.map;
        }

        public ZIO<Object, IOException, BoxedUnit> delete(Path path) {
            return STM$.MODULE$.atomically(this.deleteSTM(path), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.delete(TestFileConnector.scala:135)");
        }

        private ZSTM<Object, IOException, BoxedUnit> deleteSTM(Path path) {
            return this.findFileSTM(path).flatMap((Function1 & Serializable)file -> {
                ZSTM zSTM;
                Option option = file;
                if (option instanceof Some) {
                    FileSystemNode value = (FileSystemNode)((Some)option).value();
                    FileSystemNode fileSystemNode = value;
                    if (fileSystemNode instanceof FileSystemNode.Dir) {
                        FileSystemNode.Dir dir = TestFileConnector$FileSystemNode$Dir$.MODULE$.unapply((FileSystemNode.Dir)fileSystemNode);
                        Path path = dir._1();
                        zSTM = this.getChildren(path).flatMap((Function1 & Serializable)children -> (children.isEmpty() ? this.map().update((Function1 & Serializable)m -> (Map)m.$minus((Object)path)) : ZSTM$.MODULE$.fail(() -> this.deleteSTM$$anonfun$1$$anonfun$1$$anonfun$2(path))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }));
                        return zSTM.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    } else {
                        if (!(fileSystemNode instanceof FileSystemNode.File)) throw new MatchError((Object)fileSystemNode);
                        FileSystemNode.File file2 = TestFileConnector$FileSystemNode$File$.MODULE$.unapply((FileSystemNode.File)fileSystemNode);
                        Path path = file2._1();
                        Chunk<Object> chunk = file2._2();
                        zSTM = this.map().update((Function1 & Serializable)m -> (Map)m.$minus((Object)path));
                    }
                    return zSTM.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    zSTM = ZSTM$.MODULE$.unit();
                }
                return zSTM.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }

        private ZSTM<Object, IOException, BoxedUnit> deleteRecursivelySTM(Path path) {
            return this.findFileSTM(path).flatMap((Function1 & Serializable)file -> this.getChildren(path).map((Function1 & Serializable)children -> {
                Chunk all = children.$plus$plus(Chunk$.MODULE$.fromIterable((Iterable)file.toList()));
                return Tuple2$.MODULE$.apply(children, (Object)all);
            }).flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    Chunk children = (Chunk)tuple2._1();
                    Chunk all = (Chunk)tuple2._2();
                    return this.map().update((Function1 & Serializable)m -> (Map)m.$minus$minus((IterableOnce)all.map((Function1 & Serializable)_$2 -> _$2.path()))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                }
                throw new MatchError((Object)tuple2);
            }));
        }

        public ZIO<Object, IOException, BoxedUnit> deleteRecursively(Path path) {
            return STM$.MODULE$.atomically(this.deleteRecursivelySTM(path), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.deleteRecursively(TestFileConnector.scala:167)");
        }

        public ZIO<Object, Nothing$, Object> exists(Path path) {
            return STM$.MODULE$.atomically(this.map().get().flatMap((Function1 & Serializable)files -> ZSTM$.MODULE$.succeed(() -> this.exists$$anonfun$1$$anonfun$1(path, files)).map((Function1 & Serializable)r -> this.exists$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)r)))), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.exists(TestFileConnector.scala:175)");
        }

        private ZSTM<Object, Nothing$, Option<FileSystemNode>> findFileSTM(Path path) {
            return this.map().get().map((Function1 & Serializable)_$3 -> _$3.get((Object)path));
        }

        private ZSTM<Object, IOException, FileSystemNode> getFile(Path path) {
            return this.findFileSTM(path).flatMap((Function1 & Serializable)file -> {
                ZSTM zSTM;
                Option option = file;
                if (option instanceof Some) {
                    FileSystemNode p = (FileSystemNode)((Some)option).value();
                    zSTM = STM$.MODULE$.succeed(() -> this.getFile$$anonfun$1$$anonfun$1(p));
                } else if (None$.MODULE$.equals(option)) {
                    zSTM = STM$.MODULE$.fail(() -> this.getFile$$anonfun$1$$anonfun$2(path));
                } else {
                    throw new MatchError((Object)option);
                }
                return zSTM.map((Function1 & Serializable)r -> r);
            });
        }

        private ZSTM<Object, Nothing$, Chunk<FileSystemNode>> getChildren(Path path) {
            return this.map().get().map((Function1 & Serializable)files -> {
                Chunk children = ((Chunk)Chunk$.MODULE$.fromIterable((Iterable)files.filter((Function1 & Serializable)_$4 -> ((Path)_$4._1()).startsWith(path))).filterNot((Function1 & Serializable)_$5 -> {
                    Object object = _$5._1();
                    Path path = path;
                    return !(object != null ? !object.equals(path) : path != null);
                })).filter((Function1 & Serializable)a -> !((Path)a._1()).toString().replace(new StringBuilder(0).append(path.toString()).append(File.separator).toString(), "").contains(File.separator)).map((Function1 & Serializable)_$6 -> (FileSystemNode)_$6._2());
                return Tuple2$.MODULE$.apply(files, (Object)children);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Map files = (Map)tuple2._1();
                    Chunk children = (Chunk)tuple2._2();
                    return children;
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public ZIO<Object, IOException, Chunk<Object>> getContent(Path path) {
            return STM$.MODULE$.atomically(this.findFileSTM(path).flatMap((Function1 & Serializable)file -> {
                ZSTM zSTM;
                Option option = file;
                if (option instanceof Some) {
                    FileSystemNode p = (FileSystemNode)((Some)option).value();
                    FileSystemNode fileSystemNode = p;
                    if (fileSystemNode instanceof FileSystemNode.Dir) {
                        Path path;
                        FileSystemNode.Dir dir = TestFileConnector$FileSystemNode$Dir$.MODULE$.unapply((FileSystemNode.Dir)fileSystemNode);
                        Path path2 = path = dir._1();
                        zSTM = STM$.MODULE$.fail(() -> this.getContent$$anonfun$1$$anonfun$1(path2));
                        return zSTM.map((Function1 & Serializable)r -> r);
                    } else {
                        Chunk<Object> chunk;
                        if (!(fileSystemNode instanceof FileSystemNode.File)) throw new MatchError((Object)fileSystemNode);
                        FileSystemNode.File file2 = TestFileConnector$FileSystemNode$File$.MODULE$.unapply((FileSystemNode.File)fileSystemNode);
                        Path path = file2._1();
                        Chunk<Object> content = chunk = file2._2();
                        zSTM = STM$.MODULE$.succeed(() -> this.getContent$$anonfun$1$$anonfun$2(content));
                    }
                    return zSTM.map((Function1 & Serializable)r -> r);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    zSTM = STM$.MODULE$.fail(() -> this.getContent$$anonfun$1$$anonfun$3(path));
                }
                return zSTM.map((Function1 & Serializable)r -> r);
            }), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.getContent(TestFileConnector.scala:215)");
        }

        public ZIO<Object, IOException, Chunk<Path>> list(Path path) {
            return STM$.MODULE$.atomically(this.findFileSTM(path).map((Function1 & Serializable)_$7 -> _$7.isDefined()).flatMap((Function1 & Serializable)fileExists -> this.list$$anonfun$2(path, BoxesRunTime.unboxToBoolean((Object)fileExists))), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.list(TestFileConnector.scala:224)");
        }

        private ZSTM<Object, Nothing$, Chunk<FileSystemNode>> listFileAndAllDescendants(Path path) {
            return this.map().get().map((Function1 & Serializable)files -> {
                Chunk children = Chunk$.MODULE$.fromIterable((Iterable)files.filter((Function1 & Serializable)_$10 -> ((Path)_$10._1()).startsWith(path))).map((Function1 & Serializable)_$11 -> (FileSystemNode)_$11._2());
                return Tuple2$.MODULE$.apply(files, (Object)children);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Map files = (Map)tuple2._1();
                    Chunk children = (Chunk)tuple2._2();
                    return children;
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public ZIO<Object, IOException, BoxedUnit> movePath(Path sourcePath, ZIO<Object, IOException, Path> destinationPath) {
            return destinationPath.flatMap((Function1 & Serializable)dest -> STM$.MODULE$.atomically(this.movePathSTM(sourcePath, (Path)dest), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.movePath(TestFileConnector.scala:237)").map((Function1)(JProcedure1 & Serializable)r -> {}, (Object)"zio.connect.file.TestFileConnector.TestFileSystem.movePath(TestFileConnector.scala:238)"), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.movePath(TestFileConnector.scala:238)");
        }

        private ZSTM<Object, IOException, BoxedUnit> movePathSTM(Path sourcePath, Path destinationPath) {
            return this.getFile(sourcePath).flatMap((Function1 & Serializable)sourceFile -> this.findFileSTM(destinationPath).map((Function1 & Serializable)_$12 -> _$12.isDefined()).flatMap((Function1 & Serializable)fileAlreadyExists -> this.movePathSTM$$anonfun$1$$anonfun$2(destinationPath, (FileSystemNode)sourceFile, BoxesRunTime.unboxToBoolean((Object)fileAlreadyExists))));
        }

        public ZIO<Object, IOException, BoxedUnit> removeContentIfExists(Path path) {
            return STM$.MODULE$.atomically(this.findFileSTM(path).flatMap((Function1 & Serializable)file -> {
                ZSTM zSTM;
                Option option = file;
                if (option instanceof Some) {
                    FileSystemNode p = (FileSystemNode)((Some)option).value();
                    FileSystemNode fileSystemNode = p;
                    if (fileSystemNode instanceof FileSystemNode.Dir) {
                        Path path;
                        FileSystemNode.Dir dir = TestFileConnector$FileSystemNode$Dir$.MODULE$.unapply((FileSystemNode.Dir)fileSystemNode);
                        Path path2 = path = dir._1();
                        zSTM = ZSTM$.MODULE$.fail(() -> this.removeContentIfExists$$anonfun$1$$anonfun$1(path2));
                        return zSTM.map((Function1)(JProcedure1 & Serializable)r -> {});
                    } else {
                        if (!(fileSystemNode instanceof FileSystemNode.File)) throw new MatchError((Object)fileSystemNode);
                        FileSystemNode.File file2 = TestFileConnector$FileSystemNode$File$.MODULE$.unapply((FileSystemNode.File)fileSystemNode);
                        Path path = file2._1();
                        Chunk<Object> chunk = file2._2();
                        zSTM = this.map().update((Function1 & Serializable)m -> (Map)m.updated((Object)path, (Object)TestFileConnector$FileSystemNode$File$.MODULE$.apply(path, (Chunk<Object>)Chunk$.MODULE$.empty())));
                    }
                    return zSTM.map((Function1)(JProcedure1 & Serializable)r -> {});
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    zSTM = ZSTM$.MODULE$.fail(() -> this.removeContentIfExists$$anonfun$1$$anonfun$3(path));
                }
                return zSTM.map((Function1)(JProcedure1 & Serializable)r -> {});
            }), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.removeContentIfExists(TestFileConnector.scala:285)");
        }

        public ZIO<Object, Nothing$, Path> tempDirPath() {
            return STM$.MODULE$.atomically(ZSTM$.MODULE$.attempt(this::tempDirPath$$anonfun$2).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).flatMap((Function1 & Serializable)tempPath -> this.map().update((Function1 & Serializable)m -> (Map)m.updated(tempPath, (Object)TestFileConnector$FileSystemNode$Dir$.MODULE$.apply((Path)tempPath))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return tempPath;
            })), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.tempDirPath(TestFileConnector.scala:293)");
        }

        public ZIO<Object, Nothing$, Path> tempDirPathIn(Path path) {
            return STM$.MODULE$.atomically(this.getFile(path).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).flatMap((Function1 & Serializable)file -> {
                ZSTM zSTM;
                FileSystemNode fileSystemNode = file;
                if (fileSystemNode instanceof FileSystemNode.Dir) {
                    FileSystemNode.Dir dir = TestFileConnector$FileSystemNode$Dir$.MODULE$.unapply((FileSystemNode.Dir)fileSystemNode);
                    Path path = dir._1();
                    zSTM = ZSTM$.MODULE$.succeed(() -> this.tempDirPathIn$$anonfun$2$$anonfun$1(path)).flatMap((Function1 & Serializable)tempPath -> this.map().update((Function1 & Serializable)m -> (Map)m.updated(tempPath, (Object)TestFileConnector$FileSystemNode$Dir$.MODULE$.apply((Path)tempPath))).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return tempPath;
                    }));
                } else if (fileSystemNode instanceof FileSystemNode.File) {
                    FileSystemNode.File file2 = TestFileConnector$FileSystemNode$File$.MODULE$.unapply((FileSystemNode.File)fileSystemNode);
                    Path path = file2._1();
                    Chunk<Object> chunk = file2._2();
                    zSTM = STM$.MODULE$.die(() -> this.tempDirPathIn$$anonfun$2$$anonfun$3(path));
                } else {
                    throw new MatchError((Object)fileSystemNode);
                }
                return zSTM.map((Function1 & Serializable)r -> r);
            }), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.tempDirPathIn(TestFileConnector.scala:308)");
        }

        public ZIO<Object, Nothing$, Path> tempPath() {
            return STM$.MODULE$.atomically(STM$.MODULE$.attempt(this::tempPath$$anonfun$2).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).flatMap((Function1 & Serializable)tempPath -> this.map().update((Function1 & Serializable)m -> (Map)m.updated(tempPath, (Object)TestFileConnector$FileSystemNode$File$.MODULE$.apply((Path)tempPath, (Chunk<Object>)Chunk$.MODULE$.empty()))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return tempPath;
            })), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.tempPath(TestFileConnector.scala:316)");
        }

        public ZIO<Object, Nothing$, Path> tempPathIn(Path dir) {
            return STM$.MODULE$.atomically(STM$.MODULE$.attempt(() -> this.tempPathIn$$anonfun$2(dir)).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).flatMap((Function1 & Serializable)tempPath -> this.map().update((Function1 & Serializable)m -> (Map)m.updated(tempPath, (Object)TestFileConnector$FileSystemNode$File$.MODULE$.apply((Path)tempPath, (Chunk<Object>)Chunk$.MODULE$.empty()))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return tempPath;
            })), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.tempPathIn(TestFileConnector.scala:324)");
        }

        public ZIO<Object, IOException, BoxedUnit> write(Path path, Chunk<Object> bytes) {
            return STM$.MODULE$.atomically(this.findFileSTM(path).flatMap((Function1 & Serializable)file -> {
                ZSTM zSTM;
                Option option = file;
                if (option instanceof Some) {
                    FileSystemNode p = (FileSystemNode)((Some)option).value();
                    FileSystemNode fileSystemNode = p;
                    if (fileSystemNode instanceof FileSystemNode.Dir) {
                        Path path;
                        FileSystemNode.Dir dir = TestFileConnector$FileSystemNode$Dir$.MODULE$.unapply((FileSystemNode.Dir)fileSystemNode);
                        Path path2 = path = dir._1();
                        zSTM = ZSTM$.MODULE$.fail(() -> this.write$$anonfun$1$$anonfun$1(path2));
                        return zSTM.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    } else {
                        if (!(fileSystemNode instanceof FileSystemNode.File)) throw new MatchError((Object)fileSystemNode);
                        FileSystemNode.File file2 = TestFileConnector$FileSystemNode$File$.MODULE$.unapply((FileSystemNode.File)fileSystemNode);
                        Path path = file2._1();
                        Chunk<Object> chunk = file2._2();
                        Path path3 = path;
                        Chunk<Object> content = chunk;
                        zSTM = this.map().update((Function1 & Serializable)m -> (Map)m.updated((Object)path3, (Object)TestFileConnector$FileSystemNode$File$.MODULE$.apply(path3, (Chunk<Object>)content.$plus$plus(bytes))));
                    }
                    return zSTM.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    zSTM = this.map().update((Function1 & Serializable)m -> (Map)m.updated((Object)path, (Object)TestFileConnector$FileSystemNode$File$.MODULE$.apply(path, bytes)));
                }
                return zSTM.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            }), (Object)"zio.connect.file.TestFileConnector.TestFileSystem.write(TestFileConnector.scala:341)");
        }

        public TestFileSystem copy(TRef<Map<Path, FileSystemNode>> map) {
            return new TestFileSystem(map);
        }

        public TRef<Map<Path, FileSystemNode>> copy$default$1() {
            return this.map();
        }

        public TRef<Map<Path, FileSystemNode>> _1() {
            return this.map();
        }

        private final DirectoryNotEmptyException deleteSTM$$anonfun$1$$anonfun$1$$anonfun$2(Path path$21) {
            return new DirectoryNotEmptyException(String.valueOf(path$21));
        }

        private final boolean exists$$anonfun$1$$anonfun$1(Path path$24, Map files$1) {
            return files$1.contains((Object)path$24);
        }

        private final /* synthetic */ boolean exists$$anonfun$1$$anonfun$2(boolean r) {
            return r;
        }

        private final FileSystemNode getFile$$anonfun$1$$anonfun$1(FileSystemNode p$2) {
            return p$2;
        }

        private final FileNotFoundException getFile$$anonfun$1$$anonfun$2(Path path$28) {
            return new FileNotFoundException(String.valueOf(path$28));
        }

        private final IOException getContent$$anonfun$1$$anonfun$1(Path path$33) {
            return new IOException(new StringBuilder(15).append(path$33).append(" is a directory").toString());
        }

        private final Chunk getContent$$anonfun$1$$anonfun$2(Chunk content$4) {
            return content$4;
        }

        private final FileNotFoundException getContent$$anonfun$1$$anonfun$3(Path path$35) {
            return new FileNotFoundException(String.valueOf(path$35));
        }

        private final boolean list$$anonfun$2$$anonfun$1(boolean fileExists$1) {
            return !fileExists$1;
        }

        private final FileNotFoundException list$$anonfun$2$$anonfun$2$$anonfun$1(Path path$38) {
            return new FileNotFoundException(String.valueOf(path$38));
        }

        private final ZSTM list$$anonfun$2$$anonfun$2(Path path$37) {
            return ZSTM$.MODULE$.fail(() -> this.list$$anonfun$2$$anonfun$2$$anonfun$1(path$37));
        }

        private final /* synthetic */ ZSTM list$$anonfun$2(Path path$36, boolean fileExists) {
            return ZSTM$.MODULE$.when(() -> this.list$$anonfun$2$$anonfun$1(fileExists), () -> this.list$$anonfun$2$$anonfun$2(path$36)).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                return this.getChildren(path$36).map((Function1 & Serializable)_$8 -> _$8.map((Function1 & Serializable)_$9 -> _$9.path())).map((Function1 & Serializable)children -> children);
            });
        }

        private final boolean movePathSTM$$anonfun$1$$anonfun$2$$anonfun$1(boolean fileAlreadyExists$1) {
            return fileAlreadyExists$1;
        }

        private final IOException movePathSTM$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(Path destinationPath$4) {
            return new IOException(new StringBuilder(35).append("File already exists at destination ").append(destinationPath$4).toString());
        }

        private final ZSTM movePathSTM$$anonfun$1$$anonfun$2$$anonfun$2(Path destinationPath$3) {
            return ZSTM$.MODULE$.fail(() -> this.movePathSTM$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(destinationPath$3));
        }

        private final FileSystemNode movePathSTM$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$3(Path destinationPath$8, FileSystemNode.File a$6) {
            return a$6.replacePath(destinationPath$8);
        }

        private final /* synthetic */ ZSTM movePathSTM$$anonfun$1$$anonfun$2(Path destinationPath$2, FileSystemNode sourceFile$1, boolean fileAlreadyExists) {
            return STM$.MODULE$.when(() -> this.movePathSTM$$anonfun$1$$anonfun$2$$anonfun$1(fileAlreadyExists), () -> this.movePathSTM$$anonfun$1$$anonfun$2$$anonfun$2(destinationPath$2)).flatMap((Function1 & Serializable)x$12 -> {
                ZSTM zSTM;
                Option option = x$12;
                FileSystemNode fileSystemNode = sourceFile$1;
                if (fileSystemNode instanceof FileSystemNode.Dir) {
                    FileSystemNode.Dir a = (FileSystemNode.Dir)fileSystemNode;
                    zSTM = this.listFileAndAllDescendants(a.path()).map((Function1 & Serializable)fileAndAllDescendants -> {
                        Chunk renamedFiles = fileAndAllDescendants.map((Function1 & Serializable)f -> f.replacePath(Paths.get(f.path().toString().replace(a.path().toString(), destinationPath$2.toString()), new String[0])));
                        return Tuple2$.MODULE$.apply(fileAndAllDescendants, (Object)renamedFiles);
                    }).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Chunk fileAndAllDescendants = (Chunk)tuple2._1();
                            Chunk renamedFiles = (Chunk)tuple2._2();
                            return this.deleteRecursivelySTM(a.path()).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return this.map().update((Function1 & Serializable)m -> (Map)m.$plus$plus((IterableOnce)renamedFiles.map((Function1 & Serializable)f -> {
                                    Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)f.path());
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, f);
                                }))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                });
                            });
                        }
                        throw new MatchError((Object)tuple2);
                    });
                } else if (fileSystemNode instanceof FileSystemNode.File) {
                    FileSystemNode.File a = (FileSystemNode.File)fileSystemNode;
                    zSTM = STM$.MODULE$.succeed(() -> this.movePathSTM$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$3(destinationPath$2, a)).flatMap((Function1 & Serializable)newFile -> this.map().update((Function1 & Serializable)m -> (Map)m.updated((Object)destinationPath$2, newFile)).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.deleteSTM(a.path()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    }));
                } else {
                    throw new MatchError((Object)fileSystemNode);
                }
                return zSTM.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }

        private final IOException removeContentIfExists$$anonfun$1$$anonfun$1(Path path$42) {
            return new IOException(new StringBuilder(15).append(path$42).append(" is a directory").toString());
        }

        private final FileNotFoundException removeContentIfExists$$anonfun$1$$anonfun$3(Path path$45) {
            return new FileNotFoundException(String.valueOf(path$45));
        }

        private final Path tempDirPath$$anonfun$2() {
            return Paths.get(UUID.randomUUID().toString(), new String[0]);
        }

        private final Path tempDirPathIn$$anonfun$2$$anonfun$1(Path path$47) {
            return Paths.get(path$47.toString(), UUID.randomUUID().toString());
        }

        private final IOException tempDirPathIn$$anonfun$2$$anonfun$3(Path path$48) {
            return new IOException(new StringBuilder(19).append(path$48).append(" is not a directory").toString());
        }

        private final Path tempPath$$anonfun$2() {
            return Paths.get(UUID.randomUUID().toString(), new String[0]);
        }

        private final Path tempPathIn$$anonfun$2(Path dir$1) {
            return Paths.get(dir$1.toString(), UUID.randomUUID().toString());
        }

        private final IOException write$$anonfun$1$$anonfun$1(Path path$49) {
            return new IOException(new StringBuilder(15).append(path$49).append(" is a directory").toString());
        }
    }
}

