/*
 * Decompiled with CFR 0.152.
 */
package zio.config.yaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.jdk.CollectionConverters$;
import zio.CanFail$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.config.ConfigSourceModule;
import zio.config.PropertyTree;
import zio.config.PropertyTree$;
import zio.config.ReadError;
import zio.config.package$;
import zio.config.yaml.EnvConfigImpl$;

public final class YamlConfigSource$ {
    public static YamlConfigSource$ MODULE$;

    static {
        new YamlConfigSource$();
    }

    public ConfigSourceModule.ConfigSource fromYamlFile(File file) {
        return this.fromYamlRepr(file, (Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.loadYaml((File)x$1), file.getAbsolutePath());
    }

    public ConfigSourceModule.ConfigSource fromYamlPath(Path path) {
        return this.fromYamlFile(path.toFile());
    }

    public ConfigSourceModule.ConfigSource fromYamlReader(Reader reader, String sourceName) {
        return this.fromYamlRepr(reader, (Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.loadYaml((Reader)x$2), sourceName);
    }

    public String fromYamlReader$default$2() {
        return "yaml";
    }

    public ConfigSourceModule.ConfigSource fromYamlString(String yamlString, String sourceName) {
        return this.fromYamlRepr(yamlString, (Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.loadYaml((String)x$3), sourceName);
    }

    public String fromYamlString$default$2() {
        return "yaml";
    }

    public <A> ConfigSourceModule.ConfigSource fromYamlRepr(A repr, Function1<A, ZIO<Object, ReadError<String>, Object>> loadYaml, String sourceName) {
        ZManaged managedTree = ((ZIO)loadYaml.apply(repr)).flatMap((Function1 & Serializable & scala.Serializable)anyRef -> MODULE$.convertYaml(anyRef)).toManaged_();
        return package$.MODULE$.ConfigSource().fromManaged(sourceName, managedTree.map((Function1 & Serializable & scala.Serializable)tree -> (Function1 & Serializable & scala.Serializable)path -> ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> tree.at(path)))).memoize();
    }

    public <A> String fromYamlRepr$default$3(A repr) {
        return "yaml";
    }

    public ZIO<Object, ReadError<String>, PropertyTree<String, String>> convertYaml(Object data) {
        ZIO zIO;
        if (data == null) {
            zIO = ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> PropertyTree$.MODULE$.empty());
        } else if (data instanceof Integer) {
            Integer n = (Integer)data;
            zIO = ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> YamlConfigSource$.strictLeaf$1(n.toString()));
        } else if (data instanceof Long) {
            Long l = (Long)data;
            zIO = ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> YamlConfigSource$.strictLeaf$1(l.toString()));
        } else if (data instanceof Float) {
            Float f = (Float)data;
            zIO = ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> YamlConfigSource$.strictLeaf$1(f.toString()));
        } else if (data instanceof Double) {
            Double d = (Double)data;
            zIO = ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> YamlConfigSource$.strictLeaf$1(d.toString()));
        } else if (data instanceof String) {
            String string = (String)data;
            zIO = ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> YamlConfigSource$.strictLeaf$1(string));
        } else if (data instanceof Boolean) {
            Boolean bl = (Boolean)data;
            zIO = ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> YamlConfigSource$.strictLeaf$1(bl.toString()));
        } else if (data instanceof List) {
            List list = (List)data;
            zIO = ZIO$.MODULE$.foreach((Iterable)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(list).asScala()).toList(), (Function1 & Serializable & scala.Serializable)each -> MODULE$.convertYaml(each), List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)x$4 -> new PropertyTree.Sequence(x$4));
        } else if (data instanceof Map) {
            Map map = (Map)data;
            zIO = ZIO$.MODULE$.foreach((Iterable)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).toList(), (Function1 & Serializable & scala.Serializable)each -> MODULE$.convertYaml(each._2()).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(each._1(), r)), List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)res -> new PropertyTree.Record(res.toMap(Predef$.MODULE$.$conforms())));
        } else {
            zIO = ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new ReadError.SourceError("unexpected data type in convertYaml", ReadError.SourceError$.MODULE$.apply$default$2()));
        }
        return zIO;
    }

    private ZIO<Object, ReadError<String>, Object> loadYaml(File yamlFile) {
        return this.snakeYamlLoader().flatMap((Function1 & Serializable & scala.Serializable)r -> ZIO$.MODULE$.effect((Function0 & Serializable & scala.Serializable)() -> r.loadFromInputStream((InputStream)new FileInputStream(yamlFile))).mapError((Function1 & Serializable & scala.Serializable)throwable -> new ReadError.SourceError(throwable.toString(), ReadError.SourceError$.MODULE$.apply$default$2()), CanFail$.MODULE$.canFail()));
    }

    private ZIO<Object, ReadError<String>, Object> loadYaml(Reader yamlReader) {
        return this.snakeYamlLoader().flatMap((Function1 & Serializable & scala.Serializable)r -> ZIO$.MODULE$.effect((Function0 & Serializable & scala.Serializable)() -> r.loadFromReader(yamlReader)).mapError((Function1 & Serializable & scala.Serializable)throwable -> new ReadError.SourceError(throwable.toString(), ReadError.SourceError$.MODULE$.apply$default$2()), CanFail$.MODULE$.canFail()));
    }

    private ZIO<Object, ReadError<String>, Object> loadYaml(String yamlString) {
        return this.snakeYamlLoader().flatMap((Function1 & Serializable & scala.Serializable)r -> ZIO$.MODULE$.effect((Function0 & Serializable & scala.Serializable)() -> r.loadFromString(yamlString)).mapError((Function1 & Serializable & scala.Serializable)throwable -> new ReadError.SourceError(throwable.toString(), ReadError.SourceError$.MODULE$.apply$default$2()), CanFail$.MODULE$.canFail()));
    }

    private ZIO<Object, ReadError<String>, Load> snakeYamlLoader() {
        return ZIO$.MODULE$.effect((Function0 & Serializable & scala.Serializable)() -> new Load(LoadSettings.builder().setEnvConfig(Optional.of(EnvConfigImpl$.MODULE$)).build())).mapError((Function1 & Serializable & scala.Serializable)throwable -> new ReadError.SourceError(new StringBuilder(45).append("Failed to load snake yaml environment config ").append(throwable.toString()).toString(), ReadError.SourceError$.MODULE$.apply$default$2()), CanFail$.MODULE$.canFail());
    }

    private static final PropertyTree.Leaf strictLeaf$1(Object leaf) {
        return new PropertyTree.Leaf(leaf, false);
    }

    private YamlConfigSource$() {
        MODULE$ = this;
    }
}

