/*
 * Decompiled with CFR 0.152.
 */
package zio.cache;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.Exit;
import zio.Exit$;
import zio.NeedsEnv$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.ZManaged$;
import zio.cache.CacheStats;
import zio.cache.EntryStats;
import zio.cache.ManagedCache;
import zio.cache.ManagedCache$CacheState$;
import zio.cache.ManagedLookup;
import zio.cache.MapKey;
import zio.cache.MapKey$;
import zio.package$;

public final class ManagedCache$ {
    public static final ManagedCache$ MODULE$ = new ManagedCache$();

    public <Key, Environment, Error, Value> ZManaged<Environment, Nothing$, ManagedCache<Key, Error, Value>> make(int capacity, Duration timeToLive, ManagedLookup<Key, Environment, Error, Value> lookup) {
        return this.makeWith(capacity, lookup, (Function1 & Serializable)x$1 -> timeToLive);
    }

    public <Key, Environment, Error, Value> ZManaged<Environment, Nothing$, ManagedCache<Key, Error, Value>> makeWith(int capacity, ManagedLookup<Key, Environment, Error, Value> managedLookup, Function1<Exit<Error, Value>, Duration> timeToLive) {
        return this.makeWith(capacity, managedLookup, Clock.systemUTC(), timeToLive);
    }

    public <Key, Environment, Error, Value> ZManaged<Environment, Nothing$, ManagedCache<Key, Error, Value>> makeWith(int capacity, ManagedLookup<Key, Environment, Error, Value> managedLookup, Clock clock, Function1<Exit<Error, Value>, Duration> timeToLive) {
        return ZManaged$.MODULE$.make(this.buildWith(capacity, managedLookup, clock, timeToLive), (Function1 & Serializable)x$2 -> x$2.invalidateAll());
    }

    private <Key, Environment, Error, Value> ZIO<Environment, Nothing$, ManagedCache<Key, Error, Value>> buildWith(int capacity, ManagedLookup<Key, Environment, Error, Value> managedLookup, Clock clock, Function1<Exit<Error, Value>, Duration> timeToLive) {
        return ZIO$.MODULE$.environment().map((Function1 & Serializable)environment -> {
            ManagedCache.CacheState cacheState = ManagedCache$CacheState$.MODULE$.initial();
            return new ManagedCache<Key, Error, Value>(cacheState, managedLookup, environment, clock, timeToLive, capacity){
                private final ManagedCache.CacheState cacheState$1;
                private final ManagedLookup managedLookup$1;
                private final Object environment$1;
                private final Clock clock$1;
                private final Function1 timeToLive$2;
                private final int capacity$1;

                private ZIO<Object, Nothing$, BoxedUnit> ensureMapSizeNotExceeded(MapKey<Key> key) {
                    return ZIO$.MODULE$.foreachPar_((Iterable)Predef$.MODULE$.wrapRefArray((Object[])ManagedCache$.zio$cache$ManagedCache$$trackAccess$1(key, this.cacheState$1, this.capacity$1)), (Function1 & Serializable)cleanedMapValue -> this.cleanMapValue((ManagedCache.MapValue<Key, Error, Value>)cleanedMapValue));
                }

                public ZIO<Object, Nothing$, CacheStats> cacheStats() {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> new CacheStats($this.cacheState$1.hits().longValue(), $this.cacheState$1.misses().longValue(), $this.cacheState$1.map().size()));
                }

                public ZIO<Object, Nothing$, Object> contains(Key k) {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.cacheState$1.map().containsKey(k));
                }

                public ZIO<Object, Nothing$, Option<EntryStats>> entryStats(Key k) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                        ManagedCache.MapValue.Complete<Key, Error, Value> complete;
                        None$ none$;
                        ManagedCache.MapValue<Key, Error, Value> value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            return None$.MODULE$;
                        }
                        if (value instanceof ManagedCache.MapValue.Pending) {
                            none$ = None$.MODULE$;
                        } else if (value instanceof ManagedCache.MapValue.Complete) {
                            EntryStats entryState = ((ManagedCache.MapValue.Complete)value).entryStats();
                            none$ = Option$.MODULE$.apply((Object)new EntryStats(entryState.loaded()));
                        } else if (value instanceof ManagedCache.MapValue.Refreshing && (complete = ((ManagedCache.MapValue.Refreshing)value).complete()) != null) {
                            EntryStats entryState = complete.entryStats();
                            none$ = Option$.MODULE$.apply((Object)new EntryStats(entryState.loaded()));
                        } else {
                            throw new MatchError(value);
                        }
                        return none$;
                    });
                }

                public ZManaged<Object, Error, Value> get(Key k) {
                    return package$.MODULE$.Managed().unwrap(this.lookupValueOf(k).memoize().flatMap((Function1 & Serializable)lookupValue -> UIO$.MODULE$.effectSuspendTotal((Function0 & Serializable)() -> {
                        MapKey<Object> key = null;
                        ManagedCache.MapValue value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            key = new MapKey<Object>(k, null, null);
                            value = $this.cacheState$1.map().putIfAbsent(k, new ManagedCache.MapValue.Pending<Object, Error, Value>(key, lookupValue));
                        }
                        if (value == null) {
                            ManagedCache$.zio$cache$ManagedCache$$trackMiss$1($this.cacheState$1);
                            return this.ensureMapSizeNotExceeded(key).$times$greater((Function0 & Serializable)() -> lookupValue);
                        }
                        if (value instanceof ManagedCache.MapValue.Pending) {
                            ManagedCache.MapValue.Pending pending = (ManagedCache.MapValue.Pending)value;
                            MapKey<Key> key2 = pending.key();
                            ZIO<Object, Nothing$, ZManaged<Object, Error, Value>> managed = pending.managed();
                            ManagedCache$.zio$cache$ManagedCache$$trackHit$1($this.cacheState$1);
                            return this.ensureMapSizeNotExceeded(key2).$times$greater((Function0 & Serializable)() -> managed);
                        }
                        if (value instanceof ManagedCache.MapValue.Complete) {
                            ZIO zIO;
                            ManagedCache.MapValue.Complete complete = (ManagedCache.MapValue.Complete)value;
                            MapKey<Key> key3 = complete.key();
                            Instant timeToLive = complete.timeToLive();
                            ManagedCache$.zio$cache$ManagedCache$$trackHit$1($this.cacheState$1);
                            if (this.hasExpired(timeToLive)) {
                                $this.cacheState$1.map().remove(k, value);
                                zIO = this.ensureMapSizeNotExceeded(key3).$times$greater((Function0 & Serializable)() -> complete.releaseOwner()).$times$greater((Function0 & Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.get(k)));
                                return zIO;
                            } else {
                                zIO = this.ensureMapSizeNotExceeded(key3).as((Function0 & Serializable)() -> complete.toManaged());
                            }
                            return zIO;
                        }
                        if (!(value instanceof ManagedCache.MapValue.Refreshing)) throw new MatchError(value);
                        ManagedCache.MapValue.Refreshing refreshing = (ManagedCache.MapValue.Refreshing)value;
                        ZIO<Object, Nothing$, ZManaged<Object, Error, Value>> promiseInProgress = refreshing.managedEffect();
                        ManagedCache.MapValue.Complete<Key, Error, Value> complete = refreshing.complete();
                        if (complete == null) throw new MatchError(value);
                        MapKey<Key> mapKey = complete.key();
                        Instant ttl = complete.timeToLive();
                        ManagedCache$.zio$cache$ManagedCache$$trackHit$1($this.cacheState$1);
                        return this.hasExpired(ttl) ? this.ensureMapSizeNotExceeded(mapKey).$times$greater((Function0 & Serializable)() -> promiseInProgress) : this.ensureMapSizeNotExceeded(mapKey).as((Function0 & Serializable)() -> complete.toManaged());
                    })));
                }

                public ZIO<Object, Error, BoxedUnit> refresh(Key k) {
                    return this.lookupValueOf(k).memoize().flatMap((Function1 & Serializable)managed -> {
                        ZIO zIO;
                        ManagedCache.MapValue value = $this.cacheState$1.map().get(k);
                        MapKey<Object> newKey = null;
                        if (value == null) {
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            newKey = new MapKey<Object>(k, null, null);
                            value = $this.cacheState$1.map().putIfAbsent(k, new ManagedCache.MapValue.Pending<Object, Error, Value>(newKey, managed));
                        }
                        if (value == null) {
                            zIO = this.ensureMapSizeNotExceeded(newKey).$times$greater((Function0 & Serializable)() -> managed);
                        } else {
                            ZIO zIO2;
                            if (value instanceof ManagedCache.MapValue.Pending) {
                                zIO2 = ((ManagedCache.MapValue.Pending)value).managed();
                            } else if (value instanceof ManagedCache.MapValue.Complete) {
                                ManagedCache.MapValue.Complete complete = (ManagedCache.MapValue.Complete)value;
                                Instant ttl = complete.timeToLive();
                                zIO2 = this.hasExpired(ttl) ? ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.get(k)) : ($this.cacheState$1.map().replace(k, complete, new ManagedCache.MapValue.Refreshing<Key, Error, Value>(managed, complete)) ? managed : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.get(k)));
                            } else if (value instanceof ManagedCache.MapValue.Refreshing) {
                                zIO2 = ((ManagedCache.MapValue.Refreshing)value).managedEffect();
                            } else {
                                throw new MatchError(value);
                            }
                            zIO = zIO2;
                        }
                        return zIO.flatMap((Function1 & Serializable)x$3 -> x$3.use_(ZIO$.MODULE$.unit()));
                    });
                }

                public ZIO<Object, Nothing$, BoxedUnit> invalidate(Key k) {
                    return UIO$.MODULE$.effectSuspendTotal((Function0 & Serializable)() -> {
                        ManagedCache.MapValue<Key, Error, Value> mapValue = $this.cacheState$1.map().remove(k);
                        ZIO<Object, Nothing$, BoxedUnit> zIO = mapValue instanceof ManagedCache.MapValue.Complete ? ((ManagedCache.MapValue.Complete)mapValue).releaseOwner() : (mapValue instanceof ManagedCache.MapValue.Refreshing ? ((ManagedCache.MapValue.Refreshing)mapValue).complete().releaseOwner() : UIO$.MODULE$.unit());
                        return zIO;
                    });
                }

                public ZIO<Object, Nothing$, BoxedUnit> invalidateAll() {
                    return ZIO$.MODULE$.foreachPar_((Iterable)CollectionConverters$.MODULE$.SetHasAsScala(this.cacheState$1.map().keySet()).asScala(), (Function1 & Serializable)k -> this.invalidate(k));
                }

                public ZIO<Object, Nothing$, Object> size() {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.cacheState$1.map().size());
                }

                private ZIO<Object, Nothing$, BoxedUnit> cleanMapValue(ManagedCache.MapValue<Key, Error, Value> mapValue) {
                    ZIO<Object, Nothing$, BoxedUnit> zIO = mapValue instanceof ManagedCache.MapValue.Complete ? ((ManagedCache.MapValue.Complete)mapValue).releaseOwner() : (mapValue instanceof ManagedCache.MapValue.Refreshing ? ((ManagedCache.MapValue.Refreshing)mapValue).complete().releaseOwner() : ZIO$.MODULE$.unit());
                    return zIO;
                }

                private ZIO<Object, Nothing$, ZManaged<Object, Error, Value>> lookupValueOf(Key key) {
                    return this.managedLookup$1.apply(key).provide(this.environment$1, NeedsEnv$.MODULE$.needsEnv()).reserve().flatMap((Function1 & Serializable)reservation -> reservation.acquire().run().map((Function1 & Serializable)exit -> new Tuple2(exit, (Object)reservation.release()))).onInterrupt(ZIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.cacheState$1.map().remove(key))).flatMap((Function1 & Serializable)x0$1 -> {
                        if (x0$1 == null) throw new MatchError(null);
                        Exit exit = (Exit)x0$1._1();
                        Function1 release = (Function1)x0$1._2();
                        Instant now = Instant.now($this.clock$1);
                        Instant expiredAt = now.plus((TemporalAmount)$this.timeToLive$2.apply((Object)exit));
                        if (exit instanceof Exit.Success) {
                            Object value = ((Exit.Success)exit).value();
                            Exit exitWithReleaser = Exit$.MODULE$.succeed((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(value), (Object)release));
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            ManagedCache.MapValue.Complete<Object, Error, Value> completedResult = new ManagedCache.MapValue.Complete<Object, Error, Value>(new MapKey<Object>(key, null, null), exitWithReleaser, new AtomicInteger(1), new EntryStats(now), expiredAt);
                            ManagedCache.MapValue previousValue = $this.cacheState$1.map().put(key, completedResult);
                            return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> package$.MODULE$.Managed().unwrap(this.cleanMapValue(previousValue).as((Function0 & Serializable)() -> completedResult.toManaged())));
                        }
                        if (!(exit instanceof Exit.Failure)) throw new MatchError((Object)exit);
                        Exit.Failure failure = (Exit.Failure)exit;
                        MapKey$.MODULE$.$lessinit$greater$default$2();
                        MapKey$.MODULE$.$lessinit$greater$default$3();
                        ManagedCache.MapValue.Complete<Object, Error, Value> completedResult = new ManagedCache.MapValue.Complete<Object, Error, Value>(new MapKey<Object>(key, null, null), failure, new AtomicInteger(0), new EntryStats(now), expiredAt);
                        ManagedCache.MapValue previousValue = $this.cacheState$1.map().put(key, completedResult);
                        return ((ZIO)release.apply((Object)failure)).$times$greater((Function0 & Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> package$.MODULE$.Managed().unwrap(this.cleanMapValue(previousValue).as((Function0 & Serializable)() -> completedResult.toManaged()))));
                    }).memoize().map((Function1 & Serializable)managedEffect -> package$.MODULE$.Managed().unwrap(managedEffect));
                }

                private boolean hasExpired(Instant timeToLive) {
                    return Instant.now(this.clock$1).isAfter(timeToLive);
                }
                {
                    this.cacheState$1 = cacheState$1;
                    this.managedLookup$1 = managedLookup$1;
                    this.environment$1 = environment$1;
                    this.clock$1 = clock$1;
                    this.timeToLive$2 = timeToLive$2;
                    this.capacity$1 = capacity$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheStats$1(zio.cache.ManagedCache$$anon$1 ), $anonfun$contains$1(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$ensureMapSizeNotExceeded$1(zio.cache.ManagedCache$$anon$1 zio.cache.ManagedCache$MapValue ), $anonfun$entryStats$1(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$get$1(zio.cache.ManagedCache$$anon$1 java.lang.Object zio.ZIO ), $anonfun$get$10(zio.cache.ManagedCache$MapValue$Complete ), $anonfun$get$2(zio.cache.ManagedCache$$anon$1 java.lang.Object zio.ZIO ), $anonfun$get$3(zio.ZIO ), $anonfun$get$4(zio.ZIO ), $anonfun$get$5(zio.cache.ManagedCache$MapValue$Complete ), $anonfun$get$6(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$get$7(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$get$8(zio.cache.ManagedCache$MapValue$Complete ), $anonfun$get$9(zio.ZIO ), $anonfun$invalidate$1(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$invalidateAll$1(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$lookupValueOf$1(zio.Reservation ), $anonfun$lookupValueOf$10(zio.ZIO ), $anonfun$lookupValueOf$2(zio.Reservation zio.Exit ), $anonfun$lookupValueOf$3(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$lookupValueOf$4(zio.cache.ManagedCache$$anon$1 java.lang.Object scala.Tuple2 ), $anonfun$lookupValueOf$5(zio.cache.ManagedCache$$anon$1 zio.cache.ManagedCache$MapValue zio.cache.ManagedCache$MapValue$Complete ), $anonfun$lookupValueOf$6(zio.cache.ManagedCache$MapValue$Complete ), $anonfun$lookupValueOf$7(zio.cache.ManagedCache$$anon$1 zio.cache.ManagedCache$MapValue zio.cache.ManagedCache$MapValue$Complete ), $anonfun$lookupValueOf$8(zio.cache.ManagedCache$$anon$1 zio.cache.ManagedCache$MapValue zio.cache.ManagedCache$MapValue$Complete ), $anonfun$lookupValueOf$9(zio.cache.ManagedCache$MapValue$Complete ), $anonfun$refresh$1(zio.cache.ManagedCache$$anon$1 java.lang.Object zio.ZIO ), $anonfun$refresh$2(zio.ZIO ), $anonfun$refresh$3(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$refresh$4(zio.cache.ManagedCache$$anon$1 java.lang.Object ), $anonfun$refresh$5(zio.ZManaged ), $anonfun$size$1(zio.cache.ManagedCache$$anon$1 )}, serializedLambda);
                }
            };
        });
    }

    public static final ManagedCache.MapValue[] zio$cache$ManagedCache$$trackAccess$1(MapKey key, ManagedCache.CacheState cacheState$1, int capacity$1) {
        ArrayBuilder cleanedKey = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ManagedCache.MapValue.class));
        cacheState$1.accesses().offer((Object)key);
        if (cacheState$1.updating().compareAndSet(false, true)) {
            boolean loop = true;
            while (loop) {
                MapKey key2 = (MapKey)cacheState$1.accesses().poll(null);
                if (key2 != null) {
                    cacheState$1.keys().add(key2);
                    continue;
                }
                loop = false;
            }
            int size = cacheState$1.map().size();
            boolean bl = loop = size > capacity$1;
            while (loop) {
                MapKey key3 = cacheState$1.keys().remove();
                if (key3 != null) {
                    ManagedCache.MapValue removed = cacheState$1.map().remove(key3.value());
                    if (removed == null) continue;
                    cleanedKey.$plus$eq(removed);
                    loop = --size > capacity$1;
                    continue;
                }
                loop = false;
            }
            cacheState$1.updating().set(false);
        }
        return (ManagedCache.MapValue[])cleanedKey.result();
    }

    public static final void zio$cache$ManagedCache$$trackHit$1(ManagedCache.CacheState cacheState$1) {
        cacheState$1.hits().increment();
    }

    public static final void zio$cache$ManagedCache$$trackMiss$1(ManagedCache.CacheState cacheState$1) {
        cacheState$1.misses().increment();
    }

    private ManagedCache$() {
    }
}

