/*
 * Decompiled with CFR 0.152.
 */
package zio.cache;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.Exit;
import zio.Fiber;
import zio.NeedsEnv$;
import zio.Promise;
import zio.Promise$;
import zio.ZIO;
import zio.ZIO$;
import zio.cache.Cache;
import zio.cache.Cache$CacheState$;
import zio.cache.CacheStats;
import zio.cache.EntryStats;
import zio.cache.Lookup;
import zio.cache.MapKey;
import zio.cache.MapKey$;

public final class Cache$ {
    public static final Cache$ MODULE$ = new Cache$();

    public <Key, Environment, Error, Value> ZIO<Environment, Nothing$, Cache<Key, Error, Value>> make(int capacity, Duration timeToLive, Lookup<Key, Environment, Error, Value> lookup) {
        return this.makeWith(capacity, lookup, (Function1 & Serializable)x$1 -> timeToLive);
    }

    public <Key, Environment, Error, Value> ZIO<Environment, Nothing$, Cache<Key, Error, Value>> makeWith(int capacity, Lookup<Key, Environment, Error, Value> lookup, Function1<Exit<Error, Value>, Duration> timeToLive) {
        return ZIO$.MODULE$.environment().flatMap((Function1 & Serializable)environment -> ZIO$.MODULE$.fiberId().map((Function1 & Serializable)fiberId -> {
            Cache.CacheState cacheState = Cache$CacheState$.MODULE$.initial();
            return new Cache<Key, Error, Value>(cacheState, lookup, environment, timeToLive, (Fiber.Id)fiberId, capacity){
                private final Cache.CacheState cacheState$1;
                private final Lookup lookup$1;
                private final Object environment$1;
                private final Function1 timeToLive$2;
                private final Fiber.Id fiberId$1;
                private final int capacity$1;

                public ZIO<Object, Nothing$, CacheStats> cacheStats() {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> new CacheStats($this.cacheState$1.hits().longValue(), $this.cacheState$1.misses().longValue(), $this.cacheState$1.map().size()));
                }

                public ZIO<Object, Nothing$, Object> contains(Key k) {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.cacheState$1.map().containsKey(k));
                }

                public ZIO<Object, Nothing$, Option<EntryStats>> entryStats(Key k) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                        Cache.MapValue.Complete<Key, Error, Value> complete;
                        None$ none$;
                        Cache.MapValue<Key, Error, Value> value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            return None$.MODULE$;
                        }
                        if (value instanceof Cache.MapValue.Pending) {
                            none$ = None$.MODULE$;
                        } else if (value instanceof Cache.MapValue.Complete) {
                            EntryStats entryState = ((Cache.MapValue.Complete)value).entryStats();
                            none$ = Option$.MODULE$.apply((Object)new EntryStats(entryState.loaded()));
                        } else if (value instanceof Cache.MapValue.Refreshing && (complete = ((Cache.MapValue.Refreshing)value).complete()) != null) {
                            EntryStats entryState = complete.entryStats();
                            none$ = Option$.MODULE$.apply((Object)new EntryStats(entryState.loaded()));
                        } else {
                            throw new MatchError(value);
                        }
                        return none$;
                    });
                }

                public ZIO<Object, Error, Value> get(Key k) {
                    return ZIO$.MODULE$.effectSuspendTotal((Function0 & Serializable)() -> {
                        MapKey<Object> key = null;
                        Promise<Error, Value> promise = null;
                        Cache.MapValue value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            promise = this.newPromise();
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            key = new MapKey<Object>(k, null, null);
                            value = $this.cacheState$1.map().putIfAbsent(k, new Cache.MapValue.Pending<Object, Error, Value>(key, promise));
                        }
                        if (value == null) {
                            Cache$.zio$cache$Cache$$trackAccess$1(key, $this.cacheState$1, $this.capacity$1);
                            Cache$.zio$cache$Cache$$trackMiss$1($this.cacheState$1);
                            return this.lookupValueOf(k, promise);
                        }
                        if (value instanceof Cache.MapValue.Pending) {
                            Cache.MapValue.Pending pending = (Cache.MapValue.Pending)value;
                            MapKey<Key> key2 = pending.key();
                            Promise<Error, Value> promise2 = pending.promise();
                            Cache$.zio$cache$Cache$$trackAccess$1(key2, $this.cacheState$1, $this.capacity$1);
                            Cache$.zio$cache$Cache$$trackHit$1($this.cacheState$1);
                            return promise2.await();
                        }
                        if (value instanceof Cache.MapValue.Complete) {
                            ZIO<Object, Error, Value> zIO;
                            Cache.MapValue.Complete complete = (Cache.MapValue.Complete)value;
                            MapKey<Key> key3 = complete.key();
                            Exit<Error, Value> exit = complete.exit();
                            Instant timeToLive = complete.timeToLive();
                            Cache$.zio$cache$Cache$$trackAccess$1(key3, $this.cacheState$1, $this.capacity$1);
                            Cache$.zio$cache$Cache$$trackHit$1($this.cacheState$1);
                            if (this.hasExpired(timeToLive)) {
                                $this.cacheState$1.map().remove(k, value);
                                zIO = this.get(k);
                                return zIO;
                            } else {
                                zIO = ZIO$.MODULE$.done((Function0 & Serializable)() -> exit);
                            }
                            return zIO;
                        }
                        if (!(value instanceof Cache.MapValue.Refreshing)) throw new MatchError(value);
                        Cache.MapValue.Refreshing refreshing = (Cache.MapValue.Refreshing)value;
                        Promise<Error, Value> promiseInProgress = refreshing.promise();
                        Cache.MapValue.Complete<Key, Error, Value> complete = refreshing.complete();
                        if (complete == null) throw new MatchError(value);
                        MapKey<Key> mapKey = complete.key();
                        Exit<Error, Value> currentResult = complete.exit();
                        Instant ttl = complete.timeToLive();
                        Cache$.zio$cache$Cache$$trackAccess$1(mapKey, $this.cacheState$1, $this.capacity$1);
                        Cache$.zio$cache$Cache$$trackHit$1($this.cacheState$1);
                        return this.hasExpired(ttl) ? promiseInProgress.await() : ZIO$.MODULE$.done((Function0 & Serializable)() -> currentResult);
                    });
                }

                public ZIO<Object, Error, BoxedUnit> refresh(Key k) {
                    return ZIO$.MODULE$.effectSuspendTotal((Function0 & Serializable)() -> {
                        ZIO zIO;
                        Promise<Error, Value> promise = this.newPromise();
                        Cache.MapValue value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            Map<Key, Cache.MapValue<Key, Error, Value>> map = $this.cacheState$1.map();
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            value = map.putIfAbsent(k, new Cache.MapValue.Pending<Object, Error, Value>(new MapKey<Object>(k, null, null), promise));
                        }
                        if (value == null) {
                            zIO = this.lookupValueOf(k, promise);
                        } else {
                            ZIO zIO2;
                            if (value instanceof Cache.MapValue.Pending) {
                                zIO2 = ((Cache.MapValue.Pending)value).promise().await();
                            } else if (value instanceof Cache.MapValue.Complete) {
                                ZIO zIO3;
                                Cache.MapValue.Complete complete = (Cache.MapValue.Complete)value;
                                MapKey<Key> mapKey = complete.key();
                                Instant ttl = complete.timeToLive();
                                if (this.hasExpired(ttl)) {
                                    $this.cacheState$1.map().remove(k, value);
                                    zIO3 = this.get(k);
                                } else {
                                    zIO3 = this.lookupValueOf(mapKey.value(), promise).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.cacheState$1.map().replace(k, complete, new Cache.MapValue.Refreshing<Key, Error, Value>(promise, complete)));
                                }
                                zIO2 = zIO3;
                            } else if (value instanceof Cache.MapValue.Refreshing) {
                                zIO2 = ((Cache.MapValue.Refreshing)value).promise().await();
                            } else {
                                throw new MatchError(value);
                            }
                            zIO = zIO2;
                        }
                        return zIO.unit();
                    });
                }

                public ZIO<Object, Nothing$, BoxedUnit> invalidate(Key k) {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.cacheState$1.map().remove(k));
                }

                public ZIO<Object, Nothing$, BoxedUnit> invalidateAll() {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.cacheState$1.map().clear());
                }

                public ZIO<Object, Nothing$, Object> size() {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.cacheState$1.map().size());
                }

                private ZIO<Object, Error, Value> lookupValueOf(Key key, Promise<Error, Value> promise) {
                    return this.lookup$1.apply(key).provide(this.environment$1, NeedsEnv$.MODULE$.needsEnv()).run().flatMap((Function1 & Serializable)lookupResult -> {
                        Instant now = Instant.now();
                        MapKey$.MODULE$.$lessinit$greater$default$2();
                        MapKey$.MODULE$.$lessinit$greater$default$3();
                        Cache.MapValue.Complete<Object, Error, Value> completedResult = new Cache.MapValue.Complete<Object, Error, Value>(new MapKey<Object>(key, null, null), lookupResult, new EntryStats(now), now.plus((TemporalAmount)$this.timeToLive$2.apply(lookupResult)));
                        $this.cacheState$1.map().put(key, completedResult);
                        return promise.done(lookupResult).$times$greater((Function0 & Serializable)() -> ZIO$.MODULE$.done((Function0 & Serializable)() -> lookupResult));
                    }).onInterrupt(promise.interrupt().as((Function0 & Serializable)() -> $this.cacheState$1.map().remove(key)));
                }

                private Promise<Error, Value> newPromise() {
                    return Promise$.MODULE$.unsafeMake(this.fiberId$1);
                }

                private boolean hasExpired(Instant timeToLive) {
                    return Instant.now().isAfter(timeToLive);
                }
                {
                    this.cacheState$1 = cacheState$1;
                    this.lookup$1 = lookup$1;
                    this.environment$1 = environment$1;
                    this.timeToLive$2 = timeToLive$2;
                    this.fiberId$1 = fiberId$1;
                    this.capacity$1 = capacity$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheStats$1(zio.cache.Cache$$anon$1 ), $anonfun$contains$1(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$entryStats$1(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$get$1(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$get$2(zio.Exit ), $anonfun$get$3(zio.Exit ), $anonfun$invalidate$1(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$invalidateAll$1(zio.cache.Cache$$anon$1 ), $anonfun$lookupValueOf$1(zio.cache.Cache$$anon$1 java.lang.Object zio.Promise zio.Exit ), $anonfun$lookupValueOf$2(zio.Exit ), $anonfun$lookupValueOf$3(zio.Exit ), $anonfun$lookupValueOf$4(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$refresh$1(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$refresh$2(zio.cache.Cache$$anon$1 java.lang.Object zio.cache.Cache$MapValue$Complete zio.Promise ), $anonfun$size$1(zio.cache.Cache$$anon$1 )}, serializedLambda);
                }
            };
        }));
    }

    public static final void zio$cache$Cache$$trackAccess$1(MapKey key, Cache.CacheState cacheState$1, int capacity$1) {
        cacheState$1.accesses().offer((Object)key);
        if (cacheState$1.updating().compareAndSet(false, true)) {
            boolean loop = true;
            while (loop) {
                MapKey key2 = (MapKey)cacheState$1.accesses().poll(null);
                if (key2 != null) {
                    cacheState$1.keys().add(key2);
                    continue;
                }
                loop = false;
            }
            int size = cacheState$1.map().size();
            boolean bl = loop = size > capacity$1;
            while (loop) {
                MapKey key3 = cacheState$1.keys().remove();
                if (key3 != null) {
                    if (cacheState$1.map().remove(key3.value()) == null) continue;
                    loop = --size > capacity$1;
                    continue;
                }
                loop = false;
            }
            cacheState$1.updating().set(false);
        }
    }

    public static final void zio$cache$Cache$$trackHit$1(Cache.CacheState cacheState$1) {
        cacheState$1.hits().increment();
    }

    public static final void zio$cache$Cache$$trackMiss$1(Cache.CacheState cacheState$1) {
        cacheState$1.misses().increment();
    }

    private Cache$() {
    }
}

