package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{ARN, KinesisStreamArn}
import scala.jdk.CollectionConverters.*
final case class UserAccessLoggingSettingsSummary(
    kinesisStreamArn: Optional[KinesisStreamArn] = Optional.Absent,
    userAccessLoggingSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary = {
    import UserAccessLoggingSettingsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary
      .builder()
      .optionallyWith(
        kinesisStreamArn.map(value =>
          KinesisStreamArn.unwrap(value): java.lang.String
        )
      )(_.kinesisStreamArn)
      .userAccessLoggingSettingsArn(
        ARN.unwrap(userAccessLoggingSettingsArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary.ReadOnly =
    zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary
      .wrap(buildAwsValue())
}
object UserAccessLoggingSettingsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary =
      zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary(
        kinesisStreamArn.map(value => value),
        userAccessLoggingSettingsArn
      )
    def kinesisStreamArn: Optional[KinesisStreamArn]
    def userAccessLoggingSettingsArn: ARN
    def getKinesisStreamArn: ZIO[Any, AwsError, KinesisStreamArn] =
      AwsError.unwrapOptionField("kinesisStreamArn", kinesisStreamArn)
    def getUserAccessLoggingSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userAccessLoggingSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary
  ) extends zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary.ReadOnly {
    override val kinesisStreamArn: Optional[KinesisStreamArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisStreamArn())
        .map(value =>
          zio.aws.workspacesweb.model.primitives.KinesisStreamArn(value)
        )
    override val userAccessLoggingSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives
        .ARN(impl.userAccessLoggingSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary
  ): zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary.ReadOnly =
    new Wrapper(impl)
}
