package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{
  SubnetId,
  VpcId,
  SecurityGroupId,
  ClientToken,
  ARN
}
import scala.jdk.CollectionConverters.*
final case class UpdateNetworkSettingsRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    networkSettingsArn: ARN,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest = {
    import UpdateNetworkSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .networkSettingsArn(ARN.unwrap(networkSettingsArn): java.lang.String)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateNetworkSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest =
      zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest(
        clientToken.map(value => value),
        networkSettingsArn,
        securityGroupIds.map(value => value),
        subnetIds.map(value => value),
        vpcId.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def networkSettingsArn: ARN
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def subnetIds: Optional[List[SubnetId]]
    def vpcId: Optional[VpcId]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNetworkSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(networkSettingsArn)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest
  ) extends zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val networkSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.networkSettingsArn())
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.primitives.SubnetId(item)
        }.toList
      )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.workspacesweb.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest
  ): zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
