package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class DisassociateIpAccessSettingsRequest(portalArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest = {
    import DisassociateIpAccessSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DisassociateIpAccessSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DisassociateIpAccessSettingsRequest
      .wrap(buildAwsValue())
}
object DisassociateIpAccessSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.DisassociateIpAccessSettingsRequest =
      zio.aws.workspacesweb.model.DisassociateIpAccessSettingsRequest(portalArn)
    def portalArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest
  ) extends zio.aws.workspacesweb.model.DisassociateIpAccessSettingsRequest.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest
  ): zio.aws.workspacesweb.model.DisassociateIpAccessSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
