package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CookieSynchronizationConfiguration(
    allowlist: Iterable[zio.aws.workspacesweb.model.CookieSpecification],
    blocklist: Optional[
      Iterable[zio.aws.workspacesweb.model.CookieSpecification]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CookieSynchronizationConfiguration = {
    import CookieSynchronizationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CookieSynchronizationConfiguration
      .builder()
      .allowlist(allowlist.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        blocklist.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blocklist)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly =
    zio.aws.workspacesweb.model.CookieSynchronizationConfiguration
      .wrap(buildAwsValue())
}
object CookieSynchronizationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CookieSynchronizationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.CookieSynchronizationConfiguration =
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration(
        allowlist.map { item =>
          item.asEditable
        },
        blocklist.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allowlist
        : List[zio.aws.workspacesweb.model.CookieSpecification.ReadOnly]
    def blocklist: Optional[
      List[zio.aws.workspacesweb.model.CookieSpecification.ReadOnly]
    ]
    def getAllowlist: ZIO[Any, Nothing, List[
      zio.aws.workspacesweb.model.CookieSpecification.ReadOnly
    ]] = ZIO.succeed(allowlist)
    def getBlocklist: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.CookieSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("blocklist", blocklist)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CookieSynchronizationConfiguration
  ) extends zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly {
    override val allowlist
        : List[zio.aws.workspacesweb.model.CookieSpecification.ReadOnly] = impl
      .allowlist()
      .asScala
      .map { item =>
        zio.aws.workspacesweb.model.CookieSpecification.wrap(item)
      }
      .toList
    override val blocklist: Optional[
      List[zio.aws.workspacesweb.model.CookieSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blocklist())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.CookieSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CookieSynchronizationConfiguration
  ): zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly =
    new Wrapper(impl)
}
