package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{
  ARN,
  DisplayName,
  Description,
  ClientToken
}
import scala.jdk.CollectionConverters.*
final case class UpdateIpAccessSettingsRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    ipAccessSettingsArn: ARN,
    ipRules: Optional[Iterable[zio.aws.workspacesweb.model.IpRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest = {
    import UpdateIpAccessSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .ipAccessSettingsArn(ARN.unwrap(ipAccessSettingsArn): java.lang.String)
      .optionallyWith(
        ipRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRules)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateIpAccessSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateIpAccessSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateIpAccessSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateIpAccessSettingsRequest =
      zio.aws.workspacesweb.model.UpdateIpAccessSettingsRequest(
        clientToken.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        ipAccessSettingsArn,
        ipRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def ipAccessSettingsArn: ARN
    def ipRules: Optional[List[zio.aws.workspacesweb.model.IpRule.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getIpAccessSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(ipAccessSettingsArn)
    def getIpRules: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.IpRule.ReadOnly
    ]] = AwsError.unwrapOptionField("ipRules", ipRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest
  ) extends zio.aws.workspacesweb.model.UpdateIpAccessSettingsRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.workspacesweb.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.workspacesweb.model.primitives.DisplayName(value))
    override val ipAccessSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.ipAccessSettingsArn())
    override val ipRules
        : Optional[List[zio.aws.workspacesweb.model.IpRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.IpRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest
  ): zio.aws.workspacesweb.model.UpdateIpAccessSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
