package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListIpAccessSettingsResponse(
    ipAccessSettings: Optional[
      Iterable[zio.aws.workspacesweb.model.IpAccessSettingsSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse = {
    import ListIpAccessSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse
      .builder()
      .optionallyWith(
        ipAccessSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipAccessSettings)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListIpAccessSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListIpAccessSettingsResponse
      .wrap(buildAwsValue())
}
object ListIpAccessSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListIpAccessSettingsResponse =
      zio.aws.workspacesweb.model.ListIpAccessSettingsResponse(
        ipAccessSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ipAccessSettings: Optional[
      List[zio.aws.workspacesweb.model.IpAccessSettingsSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getIpAccessSettings: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.IpAccessSettingsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("ipAccessSettings", ipAccessSettings)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse
  ) extends zio.aws.workspacesweb.model.ListIpAccessSettingsResponse.ReadOnly {
    override val ipAccessSettings: Optional[
      List[zio.aws.workspacesweb.model.IpAccessSettingsSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAccessSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.IpAccessSettingsSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse
  ): zio.aws.workspacesweb.model.ListIpAccessSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
