package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{
  CookiePath,
  CookieName,
  CookieDomain
}
import scala.jdk.CollectionConverters.*
final case class CookieSpecification(
    domain: CookieDomain,
    name: Optional[CookieName] = Optional.Absent,
    path: Optional[CookiePath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CookieSpecification = {
    import CookieSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CookieSpecification
      .builder()
      .domain(CookieDomain.unwrap(domain): java.lang.String)
      .optionallyWith(
        name.map(value => CookieName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        path.map(value => CookiePath.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.CookieSpecification.ReadOnly =
    zio.aws.workspacesweb.model.CookieSpecification.wrap(buildAwsValue())
}
object CookieSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CookieSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CookieSpecification =
      zio.aws.workspacesweb.model.CookieSpecification(
        domain,
        name.map(value => value),
        path.map(value => value)
      )
    def domain: CookieDomain
    def name: Optional[CookieName]
    def path: Optional[CookiePath]
    def getDomain: ZIO[Any, Nothing, CookieDomain] = ZIO.succeed(domain)
    def getName: ZIO[Any, AwsError, CookieName] =
      AwsError.unwrapOptionField("name", name)
    def getPath: ZIO[Any, AwsError, CookiePath] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CookieSpecification
  ) extends zio.aws.workspacesweb.model.CookieSpecification.ReadOnly {
    override val domain: CookieDomain =
      zio.aws.workspacesweb.model.primitives.CookieDomain(impl.domain())
    override val name: Optional[CookieName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workspacesweb.model.primitives.CookieName(value))
    override val path: Optional[CookiePath] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.workspacesweb.model.primitives.CookiePath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CookieSpecification
  ): zio.aws.workspacesweb.model.CookieSpecification.ReadOnly = new Wrapper(
    impl
  )
}
