package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class BrowserSettingsSummary(browserSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary = {
    import BrowserSettingsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary
      .builder()
      .browserSettingsArn(ARN.unwrap(browserSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly =
    zio.aws.workspacesweb.model.BrowserSettingsSummary.wrap(buildAwsValue())
}
object BrowserSettingsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.BrowserSettingsSummary =
      zio.aws.workspacesweb.model.BrowserSettingsSummary(browserSettingsArn)
    def browserSettingsArn: ARN
    def getBrowserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(browserSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary
  ) extends zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly {
    override val browserSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.browserSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary
  ): zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly = new Wrapper(
    impl
  )
}
