package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.SubresourceARN
import scala.jdk.CollectionConverters.*
final case class GetIdentityProviderRequest(
    identityProviderArn: SubresourceARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest = {
    import GetIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest
      .builder()
      .identityProviderArn(
        SubresourceARN.unwrap(identityProviderArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetIdentityProviderRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetIdentityProviderRequest.wrap(buildAwsValue())
}
object GetIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetIdentityProviderRequest =
      zio.aws.workspacesweb.model
        .GetIdentityProviderRequest(identityProviderArn)
    def identityProviderArn: SubresourceARN
    def getIdentityProviderArn: ZIO[Any, Nothing, SubresourceARN] =
      ZIO.succeed(identityProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest
  ) extends zio.aws.workspacesweb.model.GetIdentityProviderRequest.ReadOnly {
    override val identityProviderArn: SubresourceARN =
      zio.aws.workspacesweb.model.primitives
        .SubresourceARN(impl.identityProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest
  ): zio.aws.workspacesweb.model.GetIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
