package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class AssociateIpAccessSettingsRequest(
    ipAccessSettingsArn: ARN,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest = {
    import AssociateIpAccessSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest
      .builder()
      .ipAccessSettingsArn(ARN.unwrap(ipAccessSettingsArn): java.lang.String)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateIpAccessSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.AssociateIpAccessSettingsRequest
      .wrap(buildAwsValue())
}
object AssociateIpAccessSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.AssociateIpAccessSettingsRequest =
      zio.aws.workspacesweb.model
        .AssociateIpAccessSettingsRequest(ipAccessSettingsArn, portalArn)
    def ipAccessSettingsArn: ARN
    def portalArn: ARN
    def getIpAccessSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(ipAccessSettingsArn)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest
  ) extends zio.aws.workspacesweb.model.AssociateIpAccessSettingsRequest.ReadOnly {
    override val ipAccessSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.ipAccessSettingsArn())
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest
  ): zio.aws.workspacesweb.model.AssociateIpAccessSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
