package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{KinesisStreamArn, ARN}
import scala.jdk.CollectionConverters.*
final case class UserAccessLoggingSettings(
    associatedPortalArns: Optional[Iterable[ARN]] = Optional.Absent,
    kinesisStreamArn: Optional[KinesisStreamArn] = Optional.Absent,
    userAccessLoggingSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettings = {
    import UserAccessLoggingSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettings
      .builder()
      .optionallyWith(
        associatedPortalArns.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedPortalArns)
      .optionallyWith(
        kinesisStreamArn.map(value =>
          KinesisStreamArn.unwrap(value): java.lang.String
        )
      )(_.kinesisStreamArn)
      .userAccessLoggingSettingsArn(
        ARN.unwrap(userAccessLoggingSettingsArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UserAccessLoggingSettings.ReadOnly =
    zio.aws.workspacesweb.model.UserAccessLoggingSettings.wrap(buildAwsValue())
}
object UserAccessLoggingSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UserAccessLoggingSettings =
      zio.aws.workspacesweb.model.UserAccessLoggingSettings(
        associatedPortalArns.map(value => value),
        kinesisStreamArn.map(value => value),
        userAccessLoggingSettingsArn
      )
    def associatedPortalArns: Optional[List[ARN]]
    def kinesisStreamArn: Optional[KinesisStreamArn]
    def userAccessLoggingSettingsArn: ARN
    def getAssociatedPortalArns: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("associatedPortalArns", associatedPortalArns)
    def getKinesisStreamArn: ZIO[Any, AwsError, KinesisStreamArn] =
      AwsError.unwrapOptionField("kinesisStreamArn", kinesisStreamArn)
    def getUserAccessLoggingSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userAccessLoggingSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettings
  ) extends zio.aws.workspacesweb.model.UserAccessLoggingSettings.ReadOnly {
    override val associatedPortalArns: Optional[List[ARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedPortalArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.primitives.ARN(item)
          }.toList
        )
    override val kinesisStreamArn: Optional[KinesisStreamArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisStreamArn())
        .map(value =>
          zio.aws.workspacesweb.model.primitives.KinesisStreamArn(value)
        )
    override val userAccessLoggingSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives
        .ARN(impl.userAccessLoggingSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettings
  ): zio.aws.workspacesweb.model.UserAccessLoggingSettings.ReadOnly =
    new Wrapper(impl)
}
