package zio.aws.workspacesweb.model
import scala.jdk.CollectionConverters.*
sealed trait RendererType {
  def unwrap: software.amazon.awssdk.services.workspacesweb.model.RendererType
}
object RendererType {
  def wrap(
      value: software.amazon.awssdk.services.workspacesweb.model.RendererType
  ): zio.aws.workspacesweb.model.RendererType = value match {
    case software.amazon.awssdk.services.workspacesweb.model.RendererType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspacesweb.model.RendererType.APP_STREAM =>
      val r = AppStream
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspacesweb.model.RendererType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.RendererType =
      software.amazon.awssdk.services.workspacesweb.model.RendererType.UNKNOWN_TO_SDK_VERSION
  }
  case object AppStream extends zio.aws.workspacesweb.model.RendererType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.RendererType =
      software.amazon.awssdk.services.workspacesweb.model.RendererType.APP_STREAM
  }
}
