package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListTrustStoresResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    trustStores: Optional[
      Iterable[zio.aws.workspacesweb.model.TrustStoreSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse = {
    import ListTrustStoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        trustStores.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trustStores)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.ListTrustStoresResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListTrustStoresResponse.wrap(buildAwsValue())
}
object ListTrustStoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListTrustStoresResponse =
      zio.aws.workspacesweb.model.ListTrustStoresResponse(
        nextToken.map(value => value),
        trustStores.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def trustStores
        : Optional[List[zio.aws.workspacesweb.model.TrustStoreSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTrustStores: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.TrustStoreSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("trustStores", trustStores)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse
  ) extends zio.aws.workspacesweb.model.ListTrustStoresResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
    override val trustStores: Optional[
      List[zio.aws.workspacesweb.model.TrustStoreSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trustStores())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.TrustStoreSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse
  ): zio.aws.workspacesweb.model.ListTrustStoresResponse.ReadOnly = new Wrapper(
    impl
  )
}
