package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class GetUserAccessLoggingSettingsRequest(
    userAccessLoggingSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest = {
    import GetUserAccessLoggingSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest
      .builder()
      .userAccessLoggingSettingsArn(
        ARN.unwrap(userAccessLoggingSettingsArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsRequest
      .wrap(buildAwsValue())
}
object GetUserAccessLoggingSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsRequest =
      zio.aws.workspacesweb.model
        .GetUserAccessLoggingSettingsRequest(userAccessLoggingSettingsArn)
    def userAccessLoggingSettingsArn: ARN
    def getUserAccessLoggingSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userAccessLoggingSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest
  ) extends zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsRequest.ReadOnly {
    override val userAccessLoggingSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives
        .ARN(impl.userAccessLoggingSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest
  ): zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
