package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class DeleteUserAccessLoggingSettingsRequest(
    userAccessLoggingSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest = {
    import DeleteUserAccessLoggingSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest
      .builder()
      .userAccessLoggingSettingsArn(
        ARN.unwrap(userAccessLoggingSettingsArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest
      .wrap(buildAwsValue())
}
object DeleteUserAccessLoggingSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest =
      zio.aws.workspacesweb.model
        .DeleteUserAccessLoggingSettingsRequest(userAccessLoggingSettingsArn)
    def userAccessLoggingSettingsArn: ARN
    def getUserAccessLoggingSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userAccessLoggingSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest
  ) extends zio.aws.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest.ReadOnly {
    override val userAccessLoggingSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives
        .ARN(impl.userAccessLoggingSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest
  ): zio.aws.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
